﻿---
title: Suspicious Antimalware Scan Interface DLL
description: Identifies the creation of the Antimalware Scan Interface (AMSI) DLL in an unusual location. This may indicate an attempt to bypass AMSI by loading a...
url: https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/windows/defense_evasion_amsi_bypass_dllhijack
products:
  - Elastic Security
---

# Suspicious Antimalware Scan Interface DLL
Identifies the creation of the Antimalware Scan Interface (AMSI) DLL in an unusual location. This may indicate an
attempt to bypass AMSI by loading a rogue AMSI module instead of the legit one.
**Rule type**: eql
**Rule indices**:
- winlogbeat-*
- logs-endpoint.events.file-*
- logs-windows.sysmon_operational-*
- endgame-*
- logs-sentinel_one_cloud_funnel.*
- logs-m365_defender.event-*
- logs-crowdstrike.fdr*

**Rule Severity**: high
**Risk Score**: 73
**Runs every**: 
**Searches indices from**: `now-9m`
**Maximum alerts per execution**: 100
**References**:
- [[https://github.com/S3cur3Th1sSh1t/Amsi-Bypass-Powershell](https://github.com/S3cur3Th1sSh1t/Amsi-Bypass-Powershell)](https://github.com/S3cur3Th1sSh1t/Amsi-Bypass-Powershell)

**Tags**:
- Domain: Endpoint
- OS: Windows
- Use Case: Threat Detection
- Tactic: Defense Evasion
- Data Source: Elastic Endgame
- Resources: Investigation Guide
- Data Source: Elastic Defend
- Data Source: Sysmon
- Data Source: SentinelOne
- Data Source: Microsoft Defender for Endpoint
- Data Source: Crowdstrike

**Version**: 319
**Rule authors**:
- Elastic

**Rule license**: Elastic License v2

## Investigation guide


## Triage and analysis


### Investigating Suspicious Antimalware Scan Interface DLL

The Windows Antimalware Scan Interface (AMSI) is a versatile interface standard that allows your applications and services to integrate with any antimalware product on a machine. AMSI integrates with multiple Windows components, ranging from User Account Control (UAC) to VBA macros and PowerShell.
Attackers might copy a rogue AMSI DLL to an unusual location to prevent the process from loading the legitimate module, achieving a bypass to execute malicious code.> **Note**:
This investigation guide uses the [Osquery Markdown Plugin](https://www.elastic.co/guide/en/security/current/invest-guide-run-osquery.html) introduced in Elastic Stack version 8.5.0. Older Elastic Stack versions will display unrendered Markdown in this guide.

#### Possible investigation steps

- Identify the process that created the DLL and which account was used.
- Investigate the process execution chain (parent process tree) for unknown processes. Examine their executable files for prevalence, whether they are located in expected locations, and if they are signed with valid digital signatures.
- Investigate other alerts associated with the user/host during the past 48 hours.
- Investigate the execution of scripts and macros after the registry modification.
- Investigate other processes launched from the directory that the DLL was created.
- Inspect the host for suspicious or abnormal behavior in the alert timeframe:
  - Observe and collect information about the following activities in the alert subject host:
  - Attempts to contact external domains and addresses.
  - Use the Elastic Defend network events to determine domains and addresses contacted by the subject process by filtering by the process' `process.entity_id`.
- Examine the DNS cache for suspicious or anomalous entries.
  - $osquery_0
- Use the Elastic Defend registry events to examine registry keys accessed, modified, or created by the related processes in the process tree.
- Examine the host services for suspicious or anomalous entries.
  - $osquery_1
- $osquery_2
- $osquery_3


### False positive analysis

- This modification should not happen legitimately. Any potential benign true positive (B-TP) should be mapped and monitored by the security team as these modifications expose the host to malware infections.


### Response and remediation

- Initiate the incident response process based on the outcome of the triage.
- Isolate the involved hosts to prevent further post-compromise behavior.
- If the triage identified malware, search the environment for additional compromised hosts.
  - Implement temporary network rules, procedures, and segmentation to contain the malware.
- Stop suspicious processes.
- Immediately block the identified indicators of compromise (IoCs).
- Inspect the affected systems for additional malware backdoors like reverse shells, reverse proxies, or droppers that attackers could use to reinfect the system.
- Remove and block malicious artifacts identified during triage.
- Run a full antimalware scan. This may reveal additional artifacts left in the system, persistence mechanisms, and malware components.
- Determine the initial vector abused by the attacker and take action to prevent reinfection through the same vector.
- Using the incident response data, update logging and audit policies to improve the mean time to detect (MTTD) and the mean time to respond (MTTR).


## Rule Query

```eql
file where host.os.type == "windows" and event.type != "deletion" and file.path != null and
  file.name : ("amsi.dll", "amsi") and 
  event.action != "A process changed a file creation time" and 
  not file.path : (
    "?:\\$SysReset\\CloudImage\\Package_for_RollupFix*\\amsi.dll",
    "?:\\Windows\\system32\\amsi.dll",
    "?:\\Windows\\Syswow64\\amsi.dll",
    "?:\\$WINDOWS.~BT\\*\\amsi.dll",
    "?:\\Windows\\CbsTemp\\*\\amsi.dll",
    "?:\\Windows\\SoftwareDistribution\\Download\\*",
    "?:\\Windows\\WinSxS\\*\\amsi.dll", 
    "?:\\Windows\\servicing\\*\\amsi.dll",
    "\\\\?\\Volume{*}\\Windows\\WinSxS\\*\\amsi.dll", 
    "\\\\?\\Volume{*}\\Windows\\system32\\amsi.dll", 
    "\\\\?\\Volume{*}\\Windows\\syswow64\\amsi.dll",

    /* Crowdstrike specific exclusion as it uses NT Object paths */
    "\\Device\\HarddiskVolume*\\Windows\\system32\\amsi.dll", 
    "\\Device\\HarddiskVolume*\\Windows\\syswow64\\amsi.dll", 
    "\\Device\\HarddiskVolume*\\Windows\\WinSxS\\*\\amsi.dll",
    "\\Device\\HarddiskVolume*\\$SysReset\\CloudImage\\Package_for_RollupFix*\\amsi.dll",
    "\\Device\\HarddiskVolume*\\$WINDOWS.~BT\\*\\amsi.dll", 
    "\\Device\\HarddiskVolume*\\Windows\\SoftwareDistribution\\Download\\*\\amsi.dll", 
    "\\Device\\HarddiskVolume*\\Windows\\CbsTemp\\*\\amsi.dll", 
    "\\Device\\HarddiskVolume*\\Windows\\servicing\\*\\amsi.dll"
  ) 
```

**Framework:** MITRE ATT&CK
- Tactic:
  - Name: Defense Evasion
- Id: TA0005
- Reference URL: [[https://attack.mitre.org/tactics/TA0005/](https://attack.mitre.org/tactics/TA0005/)](https://attack.mitre.org/tactics/TA0005/)
- Technique:
  - Name: Impair Defenses
- Id: T1562
- Reference URL: [[https://attack.mitre.org/techniques/T1562/](https://attack.mitre.org/techniques/T1562/)](https://attack.mitre.org/techniques/T1562/)
- Sub Technique:
  - Name: Disable or Modify Tools
- Id: T1562.001
- Reference URL: [[https://attack.mitre.org/techniques/T1562/001/](https://attack.mitre.org/techniques/T1562/001/)](https://attack.mitre.org/techniques/T1562/001/)
- Technique:
  - Name: Hijack Execution Flow
- Id: T1574
- Reference URL: [[https://attack.mitre.org/techniques/T1574/](https://attack.mitre.org/techniques/T1574/)](https://attack.mitre.org/techniques/T1574/)
- Sub Technique:
  - Name: DLL
- Id: T1574.001
- Reference URL: [[https://attack.mitre.org/techniques/T1574/001/](https://attack.mitre.org/techniques/T1574/001/)](https://attack.mitre.org/techniques/T1574/001/)