﻿---
title: Unusual Web Config File Access
description: Detects unusual access to the web.config file, which contains sensitive credential information such as database connection strings, machineKey validation/decryption...
url: https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/windows/credential_access_web_config_file_access
products:
  - Elastic Security
---

# Unusual Web Config File Access
Detects unusual access to the web.config file, which contains sensitive credential information such as database
connection strings, machineKey validation/decryption keys, and SAML/OAuth token settings. Attackers can use the
information extracted to forge malicious __VIEWSTATE requests for persistent RCE on the web server or pivot to the SQL
server using exposed connection strings.
**Rule type**: new_terms
**Rule indices**:
- logs-endpoint.events.file-*

**Rule Severity**: high
**Risk Score**: 73
**Runs every**: 
**Searches indices from**: `now-9m`
**Maximum alerts per execution**: 100
**References**:
- [[https://unit42.paloaltonetworks.com/microsoft-sharepoint-cve-2025-49704-cve-2025-49706-cve-2025-53770/](https://unit42.paloaltonetworks.com/microsoft-sharepoint-cve-2025-49704-cve-2025-49706-cve-2025-53770/)](https://unit42.paloaltonetworks.com/microsoft-sharepoint-cve-2025-49704-cve-2025-49706-cve-2025-53770/)

**Tags**:
- Domain: Endpoint
- OS: Windows
- Use Case: Threat Detection
- Tactic: Credential Access
- Data Source: Elastic Defend
- Resources: Investigation Guide

**Version**: 2
**Rule authors**:
- Elastic

**Rule license**: Elastic License v2

## Investigation guide


## Triage and analysis> **Disclaimer**:
This investigation guide was created using generative AI technology and has been reviewed to improve its accuracy and relevance. While every effort has been made to ensure its quality, we recommend validating the content and adapting it to suit your specific environment and operational needs.

### Investigating Unusual Web Config File Access

Web.config files are crucial in Windows environments, storing sensitive data like database credentials and encryption keys. Adversaries target these files to extract information for attacks such as forging malicious requests or accessing databases. The detection rule identifies suspicious access patterns by monitoring file access events in specific directories, helping analysts spot potential credential theft or server exploitation attempts.

### Possible investigation steps

- Investigate the user account associated with the access event to verify if the account has legitimate reasons to access the web.config file or if it might be compromised.
- Analyze recent activity from the same user or IP address to identify any other suspicious behavior or access patterns that could indicate a broader security incident.
- Review system logs and network traffic around the time of the alert to identify any related anomalies or signs of exploitation attempts, such as unusual database queries or web server requests.


### False positive analysis

- Routine administrative tasks by IT personnel may trigger alerts when accessing web.config files for legitimate configuration updates. To manage this, create exceptions for known administrative accounts or scheduled maintenance windows.
- Automated backup processes that access web.config files can be mistaken for suspicious activity. Identify and exclude these processes by their specific user accounts or service names.
- Web application updates or deployments often involve accessing web.config files. Exclude these activities by correlating them with known deployment tools or scripts.
- Security scanning tools that check web.config files for vulnerabilities might generate false positives. Whitelist these tools by their process names or IP addresses to prevent unnecessary alerts.
- Monitoring or logging solutions that periodically read web.config files for audit purposes can be excluded by identifying their specific access patterns and excluding them from the rule.


### Response and remediation

- Immediately isolate the affected server to prevent further unauthorized access and potential lateral movement within the network.
- Conduct a thorough review of the web.config file to identify any unauthorized changes or access patterns, focusing on exposed credentials and keys.
- Rotate all credentials and keys found within the web.config file, including database connection strings and encryption keys, to mitigate the risk of credential theft.
- Implement additional monitoring and logging for access to web.config files across all servers to detect future unauthorized access attempts.
- Escalate the incident to the security operations center (SOC) for further investigation and correlation with other potential indicators of compromise.
- Review and update firewall rules and access controls to ensure that only authorized users and applications can access sensitive directories containing web.config files.
- Conduct a post-incident analysis to identify gaps in security controls and enhance detection capabilities for similar threats in the future.


## Rule Query

```kuery
event.category:file and host.os.type:windows and event.action:open and
  file.name:"web.config" and file.path : *VirtualDirectories* and
  not process.executable: (
        "C:\Program Files\Microsoft Security Client\MsMpEng.exe" or
        "C:\Program Files\Windows Defender Advanced Threat Protection\MsSense.exe" or
        "C:\Windows\System32\MRT.exe"
  )
```

**Framework:** MITRE ATT&CK
- Tactic:
  - Name: Credential Access
- Id: TA0006
- Reference URL: [[https://attack.mitre.org/tactics/TA0006/](https://attack.mitre.org/tactics/TA0006/)](https://attack.mitre.org/tactics/TA0006/)
- Technique:
  - Name: OS Credential Dumping
- Id: T1003
- Reference URL: [[https://attack.mitre.org/techniques/T1003/](https://attack.mitre.org/techniques/T1003/)](https://attack.mitre.org/techniques/T1003/)