﻿---
title: NTDS Dump via Wbadmin
description: Identifies the execution of wbadmin to access the NTDS.dit file in a domain controller. Attackers with privileges from groups like Backup Operators can...
url: https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/windows/credential_access_wbadmin_ntds
products:
  - Elastic Security
---

# NTDS Dump via Wbadmin
Identifies the execution of wbadmin to access the NTDS.dit file in a domain controller. Attackers with privileges from
groups like Backup Operators can abuse the utility to perform credential access and compromise the domain.
**Rule type**: eql
**Rule indices**:
- endgame-*
- logs-crowdstrike.fdr*
- logs-endpoint.events.process-*
- logs-m365_defender.event-*
- logs-sentinel_one_cloud_funnel.*
- logs-system.security*
- logs-windows.forwarded*
- logs-windows.sysmon_operational-*
- winlogbeat-*

**Rule Severity**: medium
**Risk Score**: 47
**Runs every**: 
**Searches indices from**: `now-9m`
**Maximum alerts per execution**: 100
**References**:
- [[https://medium.com/r3d-buck3t/windows-privesc-with-sebackupprivilege-65d2cd1eb960](https://medium.com/r3d-buck3t/windows-privesc-with-sebackupprivilege-65d2cd1eb960)](https://medium.com/r3d-buck3t/windows-privesc-with-sebackupprivilege-65d2cd1eb960)

**Tags**:
- Domain: Endpoint
- OS: Windows
- Use Case: Threat Detection
- Tactic: Credential Access
- Data Source: Elastic Endgame
- Data Source: Elastic Defend
- Data Source: Windows Security Event Logs
- Data Source: Microsoft Defender for Endpoint
- Data Source: Sysmon
- Data Source: SentinelOne
- Data Source: Crowdstrike
- Resources: Investigation Guide

**Version**: 207
**Rule authors**:
- Elastic

**Rule license**: Elastic License v2

## Investigation guide


## Triage and analysis> **Disclaimer**:
This investigation guide was created using generative AI technology and has been reviewed to improve its accuracy and relevance. While every effort has been made to ensure its quality, we recommend validating the content and adapting it to suit your specific environment and operational needs.

### Investigating NTDS Dump via Wbadmin

Wbadmin is a Windows utility for backup and recovery, often used by administrators to safeguard critical data. However, adversaries with sufficient privileges, such as those in the Backup Operators group, can exploit it to access the NTDS.dit file on domain controllers, which contains sensitive credential information. The detection rule identifies suspicious use of wbadmin by monitoring for its execution with specific arguments related to NTDS.dit, helping to flag potential credential dumping activities.

### Possible investigation steps

- Review the process execution details to confirm the presence of wbadmin.exe with the specific arguments related to NTDS.dit, as indicated by the process.command_line field.
- Check the user account associated with the process execution to determine if it belongs to a privileged group such as Backup Operators, which could indicate potential misuse of privileges.
- Investigate the source host identified by host.os.type to determine if it is a domain controller, as this would be a critical factor in assessing the risk of the activity.
- Correlate the event with other security logs or alerts from data sources like Microsoft Defender for Endpoint or Sysmon to identify any related suspicious activities or patterns.
- Examine recent changes or access attempts to the NTDS.dit file on the domain controller to identify any unauthorized access or modifications.
- Assess the risk score and severity level to prioritize the investigation and determine if immediate response actions are necessary.


### False positive analysis

- Scheduled backups by legitimate IT staff can trigger the rule. Verify the identity and role of the user executing wbadmin and consider excluding known backup schedules from detection.
- Automated recovery processes in disaster recovery plans might use wbadmin with similar arguments. Review and whitelist these processes if they are part of approved recovery procedures.
- Security audits or compliance checks may involve accessing NTDS.dit for validation purposes. Confirm the legitimacy of these activities and exclude them if they are part of regular audits.
- Test environments that mimic production setups might execute similar commands. Ensure these environments are properly documented and excluded from detection if they are used for testing purposes.


### Response and remediation

- Immediately isolate the affected domain controller from the network to prevent further unauthorized access or data exfiltration.
- Revoke any suspicious or unauthorized accounts from the Backup Operators group and review all accounts with elevated privileges for legitimacy.
- Conduct a thorough review of recent backup and recovery operations on the affected domain controller to identify any unauthorized access or data manipulation.
- Change all domain administrator and service account passwords to mitigate potential credential compromise.
- Restore the NTDS.dit file from a known good backup if any unauthorized modifications are detected.
- Implement enhanced monitoring and logging for wbadmin.exe usage across all domain controllers to detect future unauthorized access attempts.
- Escalate the incident to the security operations center (SOC) or incident response team for further investigation and to assess the potential impact on the broader network.


## Rule Query

```eql
process where host.os.type == "windows" and event.type == "start" and
    (process.name : "wbadmin.exe" or ?process.pe.original_file_name : "wbadmin.exe") and
     process.args : "recovery" and process.command_line : "*ntds.dit*"
```

**Framework:** MITRE ATT&CK
- Tactic:
  - Name: Credential Access
- Id: TA0006
- Reference URL: [[https://attack.mitre.org/tactics/TA0006/](https://attack.mitre.org/tactics/TA0006/)](https://attack.mitre.org/tactics/TA0006/)
- Technique:
  - Name: OS Credential Dumping
- Id: T1003
- Reference URL: [[https://attack.mitre.org/techniques/T1003/](https://attack.mitre.org/techniques/T1003/)](https://attack.mitre.org/techniques/T1003/)
- Sub Technique:
  - Name: Security Account Manager
- Id: T1003.002
- Reference URL: [[https://attack.mitre.org/techniques/T1003/002/](https://attack.mitre.org/techniques/T1003/002/)](https://attack.mitre.org/techniques/T1003/002/)
- Sub Technique:
  - Name: NTDS
- Id: T1003.003
- Reference URL: [[https://attack.mitre.org/techniques/T1003/003/](https://attack.mitre.org/techniques/T1003/003/)](https://attack.mitre.org/techniques/T1003/003/)

**Framework:** MITRE ATT&CK
- Tactic:
  - Name: Defense Evasion
- Id: TA0005
- Reference URL: [[https://attack.mitre.org/tactics/TA0005/](https://attack.mitre.org/tactics/TA0005/)](https://attack.mitre.org/tactics/TA0005/)
- Technique:
  - Name: Direct Volume Access
- Id: T1006
- Reference URL: [[https://attack.mitre.org/techniques/T1006/](https://attack.mitre.org/techniques/T1006/)](https://attack.mitre.org/techniques/T1006/)