﻿---
title: Suspicious Remote Registry Access via SeBackupPrivilege
description: Identifies remote access to the registry using an account with Backup Operators group membership. This may indicate an attempt to exfiltrate credentials...
url: https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/windows/credential_access_suspicious_winreg_access_via_sebackup_priv
products:
  - Elastic Security
---

# Suspicious Remote Registry Access via SeBackupPrivilege
Identifies remote access to the registry using an account with Backup Operators group membership. This may indicate an
attempt to exfiltrate credentials by dumping the Security Account Manager (SAM) registry hive in preparation for
credential access and privileges elevation.
**Rule type**: eql
**Rule indices**:
- logs-system.security*
- logs-windows.forwarded*
- winlogbeat-*

**Rule Severity**: medium
**Risk Score**: 47
**Runs every**: 
**Searches indices from**: `now-9m`
**Maximum alerts per execution**: 100
**References**:
- [[https://github.com/mpgn/BackupOperatorToDA](https://github.com/mpgn/BackupOperatorToDA)](https://github.com/mpgn/BackupOperatorToDA)
- [[https://raw.githubusercontent.com/Wh04m1001/Random/main/BackupOperators.cpp](https://raw.githubusercontent.com/Wh04m1001/Random/main/BackupOperators.cpp)](https://raw.githubusercontent.com/Wh04m1001/Random/main/BackupOperators.cpp)
- [[https://www.elastic.co/security-labs/detect-credential-access](https://www.elastic.co/security-labs/detect-credential-access)](https://www.elastic.co/security-labs/detect-credential-access)

**Tags**:
- Domain: Endpoint
- OS: Windows
- Use Case: Threat Detection
- Tactic: Lateral Movement
- Tactic: Credential Access
- Resources: Investigation Guide
- Use Case: Active Directory Monitoring
- Data Source: Active Directory
- Data Source: Windows Security Event Logs

**Version**: 216
**Rule authors**:
- Elastic

**Rule license**: Elastic License v2

## Setup

The 'Audit Detailed File Share' audit policy is required be configured (Success) on Domain Controllers and Sensitive Windows Servers.
Steps to implement the logging policy with Advanced Audit Configuration:
```
Computer Configuration >
Policies >
Windows Settings >
Security Settings >
Advanced Audit Policies Configuration >
Audit Policies >
Object Access >
Audit Detailed File Share (Success)
```

The 'Special Logon' audit policy must be configured (Success).
Steps to implement the logging policy with Advanced Audit Configuration:
```
Computer Configuration >
Policies >
Windows Settings >
Security Settings >
Advanced Audit Policies Configuration >
Audit Policies >
Logon/Logoff >
Special Logon (Success)
```


## Investigation guide


## Triage and analysis


### Investigating Suspicious Remote Registry Access via SeBackupPrivilege

SeBackupPrivilege is a privilege that allows file content retrieval, designed to enable users to create backup copies of the system. Since it is impossible to make a backup of something you cannot read, this privilege comes at the cost of providing the user with full read access to the file system. This privilege must bypass any access control list (ACL) placed in the system.
This rule identifies remote access to the registry using an account with Backup Operators group membership. This may indicate an attempt to exfiltrate credentials by dumping the Security Account Manager (SAM) registry hive in preparation for credential access and privileges elevation.

#### Possible investigation steps

- Identify the user account that performed the action and whether it should perform this kind of action.
- Investigate the activities done by the subject user the login session. The field `winlog.event_data.SubjectLogonId` can be used to get this data.
- Investigate other alerts associated with the user/host during the past 48 hours.
- Contact the account owner and confirm whether they are aware of this activity.
- Investigate abnormal behaviors observed by the subject user such as network connections, registry or file modifications, and processes created.
- Investigate if the registry file was retrieved or exfiltrated.


### False positive analysis

- If this activity is expected and noisy in your environment, benign true positives (B-TPs) can be added as exceptions if necessary.


### Response and remediation

- Initiate the incident response process based on the outcome of the triage.
- Limit or disable the involved user account to prevent further post-compromise behavior.
- Investigate credential exposure on systems compromised or used by the attacker to ensure all compromised accounts are identified. Reset passwords for these accounts and other potentially compromised credentials, such as email, business systems, and web services.
- Run a full antimalware scan. This may reveal additional artifacts left in the system, persistence mechanisms, and malware components.
- Determine the initial vector abused by the attacker and take action to prevent reinfection through the same vector.
- Using the incident response data, update logging and audit policies to improve the mean time to detect (MTTD) and the mean time to respond (MTTR).


## Rule Query

```eql
sequence by winlog.computer_name, winlog.event_data.SubjectLogonId with maxspan=1m
 [iam where host.os.type == "windows" and event.action == "logged-in-special" and
  winlog.event_data.PrivilegeList : "SeBackupPrivilege" and

  /* excluding accounts with existing privileged access */
  not winlog.event_data.PrivilegeList : "SeDebugPrivilege"]
 [any where host.os.type == "windows" and event.code == "5145" and winlog.event_data.RelativeTargetName : "winreg"]
```

**Framework:** MITRE ATT&CK
- Tactic:
  - Name: Credential Access
- Id: TA0006
- Reference URL: [[https://attack.mitre.org/tactics/TA0006/](https://attack.mitre.org/tactics/TA0006/)](https://attack.mitre.org/tactics/TA0006/)
- Technique:
  - Name: OS Credential Dumping
- Id: T1003
- Reference URL: [[https://attack.mitre.org/techniques/T1003/](https://attack.mitre.org/techniques/T1003/)](https://attack.mitre.org/techniques/T1003/)
- Sub Technique:
  - Name: Security Account Manager
- Id: T1003.002
- Reference URL: [[https://attack.mitre.org/techniques/T1003/002/](https://attack.mitre.org/techniques/T1003/002/)](https://attack.mitre.org/techniques/T1003/002/)
- Sub Technique:
  - Name: LSA Secrets
- Id: T1003.004
- Reference URL: [[https://attack.mitre.org/techniques/T1003/004/](https://attack.mitre.org/techniques/T1003/004/)](https://attack.mitre.org/techniques/T1003/004/)

**Framework:** MITRE ATT&CK
- Tactic:
  - Name: Lateral Movement
- Id: TA0008
- Reference URL: [[https://attack.mitre.org/tactics/TA0008/](https://attack.mitre.org/tactics/TA0008/)](https://attack.mitre.org/tactics/TA0008/)
- Technique:
  - Name: Remote Services
- Id: T1021
- Reference URL: [[https://attack.mitre.org/techniques/T1021/](https://attack.mitre.org/techniques/T1021/)](https://attack.mitre.org/techniques/T1021/)