﻿---
title: User account exposed to Kerberoasting
description: Detects when a user account has the servicePrincipalName attribute modified. Attackers can abuse write privileges over a user to configure Service Principle...
url: https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/windows/credential_access_spn_attribute_modified
products:
  - Elastic Security
---

# User account exposed to Kerberoasting
Detects when a user account has the servicePrincipalName attribute modified. Attackers can abuse write privileges over a
user to configure Service Principle Names (SPNs) so that they can perform Kerberoasting. Administrators can also
configure this for legitimate purposes, exposing the account to Kerberoasting.
**Rule type**: query
**Rule indices**:
- winlogbeat-*
- logs-system.security*
- logs-windows.forwarded*

**Rule Severity**: medium
**Risk Score**: 47
**Runs every**: 
**Searches indices from**: `now-9m`
**Maximum alerts per execution**: 100
**References**:
- [[https://www.thehacker.recipes/ad/movement/access-controls/targeted-kerberoasting](https://www.thehacker.recipes/ad/movement/access-controls/targeted-kerberoasting)](https://www.thehacker.recipes/ad/movement/access-controls/targeted-kerberoasting)
- [[https://www.qomplx.com/qomplx-knowledge-kerberoasting-attacks-explained/](https://www.qomplx.com/qomplx-knowledge-kerberoasting-attacks-explained/)](https://www.qomplx.com/qomplx-knowledge-kerberoasting-attacks-explained/)
- [[https://www.thehacker.recipes/ad/movement/kerberos/kerberoast](https://www.thehacker.recipes/ad/movement/kerberos/kerberoast)](https://www.thehacker.recipes/ad/movement/kerberos/kerberoast)
- [[https://attack.stealthbits.com/cracking-kerberos-tgs-tickets-using-kerberoasting](https://attack.stealthbits.com/cracking-kerberos-tgs-tickets-using-kerberoasting)](https://attack.stealthbits.com/cracking-kerberos-tgs-tickets-using-kerberoasting)
- [[https://adsecurity.org/?p=280](https://adsecurity.org/?p=280)](https://adsecurity.org/?p=280)
- [[https://github.com/OTRF/Set-AuditRule](https://github.com/OTRF/Set-AuditRule)](https://github.com/OTRF/Set-AuditRule)

**Tags**:
- Domain: Endpoint
- OS: Windows
- Use Case: Threat Detection
- Tactic: Credential Access
- Data Source: Active Directory
- Resources: Investigation Guide
- Use Case: Active Directory Monitoring
- Data Source: Windows Security Event Logs

**Version**: 219
**Rule authors**:
- Elastic

**Rule license**: Elastic License v2

## Setup

The 'Audit Directory Service Changes' logging policy must be configured for (Success, Failure).
Steps to implement the logging policy with Advanced Audit Configuration:
```
Computer Configuration >
Policies >
Windows Settings >
Security Settings >
Advanced Audit Policies Configuration >
Audit Policies >
DS Access >
Audit Directory Service Changes (Success,Failure)
```

The above policy does not cover User objects, so set up an AuditRule using [https://github.com/OTRF/Set-AuditRule](https://github.com/OTRF/Set-AuditRule).
As this specifies the servicePrincipalName Attribute GUID, it is expected to be low noise.
```
Set-AuditRule -AdObjectPath 'AD:\CN=Users,DC=Domain,DC=com' -WellKnownSidType WorldSid -Rights WriteProperty -InheritanceFlags Children -AttributeGUID f3a64788-5306-11d1-a9c5-0000f80367c1 -AuditFlags Success
```


## Investigation guide


## Triage and analysis


### Investigating User account exposed to Kerberoasting

Service Principal Names (SPNs) are names by which Kerberos clients uniquely identify service instances for Kerberos target computers.
By default, only computer accounts have SPNs, which creates no significant risk, since machine accounts have a default domain policy that rotates their passwords every 30 days, and the password is composed of 120 random characters, making them invulnerable to Kerberoasting.
A user account with an SPN assigned is considered a service account, and is accessible to the entire domain. If any user in the directory requests a ticket-granting service (TGS), the domain controller will encrypt it with the secret key of the account executing the service. An attacker can potentially perform a Kerberoasting attack with this information, as the human-defined password is likely to be less complex.
For scenarios where SPNs cannot be avoided on user accounts, Microsoft provides the Group Managed Service Accounts (gMSA) feature, which ensures that account passwords are robust and changed regularly and automatically. More information can be found [here](https://docs.microsoft.com/en-us/windows-server/security/group-managed-service-accounts/group-managed-service-accounts-overview).
Attackers can also perform "Targeted Kerberoasting", which consists of adding fake SPNs to user accounts that they have write privileges to, making them potentially vulnerable to Kerberoasting.

#### Possible investigation steps

- Identify the user account that performed the action and whether it should perform this kind of action.
- Contact the account owner and confirm whether they are aware of this activity.
- Investigate if the target account is a member of privileged groups (Domain Admins, Enterprise Admins, etc.).
- Investigate if tickets have been requested for the target account.
- Investigate other alerts associated with the user/host during the past 48 hours.


### False positive analysis

- The use of user accounts as service accounts is a bad security practice and should not be allowed in the domain. The security team should map and monitor any potential benign true positive (B-TP), especially if the account is privileged. Domain Administrators that define this kind of setting can put the domain at risk as user accounts don't have the same security standards as computer accounts (which have long, complex, random passwords that change frequently), exposing them to credential cracking attacks (Kerberoasting, brute force, etc.).


### Response and remediation

- Initiate the incident response process based on the outcome of the triage.
- Investigate credential exposure on systems compromised or used by the attacker to ensure all compromised accounts are identified. Reset passwords for these accounts and other potentially compromised credentials, such as email, business systems, and web services. Prioritize privileged accounts.
- Isolate the involved hosts to prevent further post-compromise behavior.
- Determine the initial vector abused by the attacker and take action to prevent reinfection through the same vector.
- Using the incident response data, update logging and audit policies to improve the mean time to detect (MTTD) and the mean time to respond (MTTR).


## Rule Query

```kuery
event.code:5136 and host.os.type:"windows" and winlog.event_data.OperationType:"%%14674" and
  winlog.event_data.ObjectClass:"user" and
  winlog.event_data.AttributeLDAPDisplayName:"servicePrincipalName"
```

**Framework:** MITRE ATT&CK
- Tactic:
  - Name: Credential Access
- Id: TA0006
- Reference URL: [[https://attack.mitre.org/tactics/TA0006/](https://attack.mitre.org/tactics/TA0006/)](https://attack.mitre.org/tactics/TA0006/)
- Technique:
  - Name: Steal or Forge Kerberos Tickets
- Id: T1558
- Reference URL: [[https://attack.mitre.org/techniques/T1558/](https://attack.mitre.org/techniques/T1558/)](https://attack.mitre.org/techniques/T1558/)
- Sub Technique:
  - Name: Kerberoasting
- Id: T1558.003
- Reference URL: [[https://attack.mitre.org/techniques/T1558/003/](https://attack.mitre.org/techniques/T1558/003/)](https://attack.mitre.org/techniques/T1558/003/)