﻿---
title: Sensitive Privilege SeEnableDelegationPrivilege assigned to a User
description: Identifies the assignment of the SeEnableDelegationPrivilege sensitive "user right" to a user. The SeEnableDelegationPrivilege "user right" enables computer...
url: https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/windows/credential_access_seenabledelegationprivilege_assigned_to_user
products:
  - Elastic Security
---

# Sensitive Privilege SeEnableDelegationPrivilege assigned to a User
Identifies the assignment of the SeEnableDelegationPrivilege sensitive "user right" to a user. The
SeEnableDelegationPrivilege "user right" enables computer and user accounts to be trusted for delegation. Attackers can
abuse this right to compromise Active Directory accounts and elevate their privileges.
**Rule type**: query
**Rule indices**:
- winlogbeat-*
- logs-system.security*
- logs-windows.forwarded*

**Rule Severity**: high
**Risk Score**: 73
**Runs every**: 
**Searches indices from**: `now-9m`
**Maximum alerts per execution**: 100
**References**:
- [[https://blog.harmj0y.net/activedirectory/the-most-dangerous-user-right-you-probably-have-never-heard-of/](https://blog.harmj0y.net/activedirectory/the-most-dangerous-user-right-you-probably-have-never-heard-of/)](https://blog.harmj0y.net/activedirectory/the-most-dangerous-user-right-you-probably-have-never-heard-of/)
- [[https://github.com/SigmaHQ/sigma/blob/master/rules/windows/builtin/security/win_alert_active_directory_user_control.yml](https://github.com/SigmaHQ/sigma/blob/master/rules/windows/builtin/security/win_alert_active_directory_user_control.yml)](https://github.com/SigmaHQ/sigma/blob/master/rules/windows/builtin/security/win_alert_active_directory_user_control.yml)
- [[https://twitter.com/_nwodtuhs/status/1454049485080907776](https://twitter.com/_nwodtuhs/status/1454049485080907776)](https://twitter.com/_nwodtuhs/status/1454049485080907776)
- [[https://www.thehacker.recipes/ad/movement/kerberos/delegations](https://www.thehacker.recipes/ad/movement/kerberos/delegations)](https://www.thehacker.recipes/ad/movement/kerberos/delegations)
- [[https://github.com/atc-project/atomic-threat-coverage/blob/master/Atomic_Threat_Coverage/Logging_Policies/LP_0105_windows_audit_authorization_policy_change.md](https://github.com/atc-project/atomic-threat-coverage/blob/master/Atomic_Threat_Coverage/Logging_Policies/LP_0105_windows_audit_authorization_policy_change.md)](https://github.com/atc-project/atomic-threat-coverage/blob/master/Atomic_Threat_Coverage/Logging_Policies/LP_0105_windows_audit_authorization_policy_change.md)

**Tags**:
- Domain: Endpoint
- OS: Windows
- Use Case: Threat Detection
- Tactic: Credential Access
- Tactic: Persistence
- Data Source: Active Directory
- Resources: Investigation Guide
- Use Case: Active Directory Monitoring
- Data Source: Windows Security Event Logs

**Version**: 218
**Rule authors**:
- Elastic

**Rule license**: Elastic License v2

## Setup

The 'Audit Authorization Policy Change' logging policy must be configured for (Success, Failure).
Steps to implement the logging policy with Advanced Audit Configuration:
```
Computer Configuration >
Windows Settings >
Security Settings >
Advanced Audit Policy Configuration >
Audit Policies >
Policy Change >
Audit Authorization Policy Change (Success,Failure)
```


## Investigation guide


## Triage and analysis


### Investigating Sensitive Privilege SeEnableDelegationPrivilege assigned to a User

Kerberos delegation is an Active Directory feature that allows user and computer accounts to impersonate other accounts, act on their behalf, and use their privileges. Delegation (constrained and unconstrained) can be configured for user and computer objects.
Enabling unconstrained delegation for a computer causes the computer to store the ticket-granting ticket (TGT) in memory at any time an account connects to the computer, so it can be used by the computer for impersonation when needed. Risk is heightened if an attacker compromises computers with unconstrained delegation enabled, as they could extract TGTs from memory and then replay them to move laterally on the domain. If the attacker coerces a privileged user to connect to the server, or if the user does so routinely, the account will be compromised and the attacker will be able to pass-the-ticket to privileged assets.
SeEnableDelegationPrivilege is a user right that is controlled within the Local Security Policy of a domain controller and is managed through Group Policy. This setting is named **Enable computer and user accounts to be trusted for delegation**.
It is critical to control the assignment of this privilege. A user with this privilege and write access to a computer can control delegation settings, perform the attacks described above, and harvest TGTs from any user that connects to the system.

#### Possible investigation steps

- Investigate how the privilege was assigned to the user and who assigned it.
- Investigate other potentially malicious activity that was performed by the user that assigned the privileges using the `user.id` and `winlog.activity_id` fields as a filter during the past 48 hours.
- Investigate other alerts associated with the users/host during the past 48 hours.


### False positive analysis

- The SeEnableDelegationPrivilege privilege should not be assigned to users. If this rule is triggered in your environment legitimately, the security team should notify the administrators about the risks of using it.


### Related rules

- KRBTGT Delegation Backdoor - e052c845-48d0-4f46-8a13-7d0aba05df82


### Response and remediation

- Initiate the incident response process based on the outcome of the triage.
- Remove the privilege from the account.
- Review the privileges of the administrator account that performed the action.
- Determine the initial vector abused by the attacker and take action to prevent reinfection through the same vector.
- Using the incident response data, update logging and audit policies to improve the mean time to detect (MTTD) and the mean time to respond (MTTR).


## Rule Query

```kuery
event.code:4704 and host.os.type:"windows" and winlog.event_data.PrivilegeList:"SeEnableDelegationPrivilege"
```

**Framework:** MITRE ATT&CK
- Tactic:
  - Name: Credential Access
- Id: TA0006
- Reference URL: [[https://attack.mitre.org/tactics/TA0006/](https://attack.mitre.org/tactics/TA0006/)](https://attack.mitre.org/tactics/TA0006/)
- Technique:
  - Name: Steal or Forge Kerberos Tickets
- Id: T1558
- Reference URL: [[https://attack.mitre.org/techniques/T1558/](https://attack.mitre.org/techniques/T1558/)](https://attack.mitre.org/techniques/T1558/)

**Framework:** MITRE ATT&CK
- Tactic:
  - Name: Persistence
- Id: TA0003
- Reference URL: [[https://attack.mitre.org/tactics/TA0003/](https://attack.mitre.org/tactics/TA0003/)](https://attack.mitre.org/tactics/TA0003/)
- Technique:
  - Name: Account Manipulation
- Id: T1098
- Reference URL: [[https://attack.mitre.org/techniques/T1098/](https://attack.mitre.org/techniques/T1098/)](https://attack.mitre.org/techniques/T1098/)