﻿---
title: Potential Local NTLM Relay via HTTP
description: Identifies attempt to coerce a local NTLM authentication via HTTP using the Windows Printer Spooler service as a target. An adversary may use this primitive...
url: https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/windows/credential_access_relay_ntlm_auth_via_http_spoolss
products:
  - Elastic Security
---

# Potential Local NTLM Relay via HTTP
Identifies attempt to coerce a local NTLM authentication via HTTP using the Windows Printer Spooler service as a target.
An adversary may use this primitive in combination with other techniques to elevate privileges on a compromised system.
**Rule type**: eql
**Rule indices**:
- endgame-*
- logs-crowdstrike.fdr*
- logs-endpoint.events.process-*
- logs-m365_defender.event-*
- logs-sentinel_one_cloud_funnel.*
- logs-system.security*
- logs-windows.forwarded*
- logs-windows.sysmon_operational-*
- winlogbeat-*

**Rule Severity**: high
**Risk Score**: 73
**Runs every**: 
**Searches indices from**: `now-9m`
**Maximum alerts per execution**: 100
**References**:
- [[https://github.com/med0x2e/NTLMRelay2Self](https://github.com/med0x2e/NTLMRelay2Self)](https://github.com/med0x2e/NTLMRelay2Self)
- [[https://github.com/topotam/PetitPotam](https://github.com/topotam/PetitPotam)](https://github.com/topotam/PetitPotam)
- [[https://github.com/dirkjanm/krbrelayx/blob/master/printerbug.py](https://github.com/dirkjanm/krbrelayx/blob/master/printerbug.py)](https://github.com/dirkjanm/krbrelayx/blob/master/printerbug.py)

**Tags**:
- Domain: Endpoint
- OS: Windows
- Use Case: Threat Detection
- Tactic: Credential Access
- Tactic: Defense Evasion
- Data Source: Elastic Endgame
- Data Source: Elastic Defend
- Data Source: Windows Security Event Logs
- Data Source: Microsoft Defender for Endpoint
- Data Source: Sysmon
- Data Source: SentinelOne
- Data Source: Crowdstrike
- Resources: Investigation Guide

**Version**: 315
**Rule authors**:
- Elastic

**Rule license**: Elastic License v2

## Investigation guide


## Triage and analysis> **Disclaimer**:
This investigation guide was created using generative AI technology and has been reviewed to improve its accuracy and relevance. While every effort has been made to ensure its quality, we recommend validating the content and adapting it to suit your specific environment and operational needs.

### Investigating Potential Local NTLM Relay via HTTP

NTLM, a suite of Microsoft security protocols, is often targeted by adversaries for credential theft. Attackers may exploit the Windows Printer Spooler service to coerce NTLM authentication over HTTP, potentially elevating privileges. The detection rule identifies suspicious rundll32.exe executions invoking WebDAV client DLLs with specific arguments, signaling attempts to access named pipes via HTTP, indicative of NTLM relay attacks.

### Possible investigation steps

- Review the process execution details for rundll32.exe, focusing on the specific arguments related to davclnt.dll and DavSetCookie, to confirm the presence of suspicious WebDAV client activity.
- Investigate the network connections initiated by the rundll32.exe process to identify any HTTP requests targeting named pipes, such as those containing "/print/pipe/", "/pipe/spoolss", or "/pipe/srvsvc".
- Check the system's event logs for any related authentication attempts or failures around the time of the alert to identify potential NTLM relay activity.
- Analyze the history of the Windows Printer Spooler service on the affected host to determine if it has been recently manipulated or exploited.
- Correlate the alert with other security events or alerts from data sources like Microsoft Defender for Endpoint or Sysmon to identify any related suspicious activities or patterns.
- Assess the user account associated with the NTLM authentication attempt to determine if it has been compromised or is being used in an unauthorized manner.


### False positive analysis

- Legitimate administrative tasks using rundll32.exe with WebDAV client DLLs may trigger the rule. Review the context of the execution, such as the user account and the timing, to determine if it aligns with expected administrative activities.
- Automated software deployment or update processes might use similar rundll32.exe calls. Verify if the process is part of a scheduled or known deployment task and consider excluding these specific processes from the rule.
- Some third-party applications may use WebDAV for legitimate purposes, which could mimic the behavior detected by the rule. Identify these applications and create exceptions for their known processes to prevent false alerts.
- System maintenance scripts or tools that interact with network resources via HTTP might inadvertently match the rule's criteria. Ensure these scripts are documented and exclude them if they are verified as non-threatening.
- Regularly review and update the exclusion list to accommodate changes in legitimate software behavior, ensuring that only verified false positives are excluded to maintain the rule's effectiveness.


### Response and remediation

- Immediately isolate the affected system from the network to prevent further unauthorized access or lateral movement.
- Terminate any suspicious rundll32.exe processes identified in the alert to stop ongoing malicious activity.
- Conduct a thorough review of the affected system's event logs and network traffic to identify any additional indicators of compromise or related malicious activity.
- Reset credentials for any accounts that may have been exposed or compromised during the attack to prevent unauthorized access.
- Apply the latest security patches and updates to the Windows Printer Spooler service and related components to mitigate known vulnerabilities.
- Implement network segmentation to limit the exposure of critical services and reduce the risk of similar attacks in the future.
- Escalate the incident to the security operations center (SOC) or incident response team for further investigation and to ensure comprehensive remediation efforts are undertaken.


## Rule Query

```eql
process where host.os.type == "windows" and event.type == "start" and
  process.name : "rundll32.exe" and

  /* Rundll32 WbeDav Client  */
  process.args : ("?:\\Windows\\System32\\davclnt.dll,DavSetCookie", "?:\\Windows\\SysWOW64\\davclnt.dll,DavSetCookie") and

  /* Access to named pipe via http */
  process.args : ("http*/print/pipe/*", "http*/pipe/spoolss", "http*/pipe/srvsvc")
```

**Framework:** MITRE ATT&CK
- Tactic:
  - Name: Credential Access
- Id: TA0006
- Reference URL: [[https://attack.mitre.org/tactics/TA0006/](https://attack.mitre.org/tactics/TA0006/)](https://attack.mitre.org/tactics/TA0006/)
- Technique:
  - Name: Exploitation for Credential Access
- Id: T1212
- Reference URL: [[https://attack.mitre.org/techniques/T1212/](https://attack.mitre.org/techniques/T1212/)](https://attack.mitre.org/techniques/T1212/)

**Framework:** MITRE ATT&CK
- Tactic:
  - Name: Defense Evasion
- Id: TA0005
- Reference URL: [[https://attack.mitre.org/tactics/TA0005/](https://attack.mitre.org/tactics/TA0005/)](https://attack.mitre.org/tactics/TA0005/)
- Technique:
  - Name: System Binary Proxy Execution
- Id: T1218
- Reference URL: [[https://attack.mitre.org/techniques/T1218/](https://attack.mitre.org/techniques/T1218/)](https://attack.mitre.org/techniques/T1218/)
- Sub Technique:
  - Name: Rundll32
- Id: T1218.011
- Reference URL: [[https://attack.mitre.org/techniques/T1218/011/](https://attack.mitre.org/techniques/T1218/011/)](https://attack.mitre.org/techniques/T1218/011/)