﻿---
title: PowerShell Script with Veeam Credential Access Capabilities
description: Identifies PowerShell script block content that queries Veeam credential tables or uses ProtectedStorage to decrypt stored secrets. Attackers abuse Veeam...
url: https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/windows/credential_access_posh_veeam_sql
products:
  - Elastic Security
---

# PowerShell Script with Veeam Credential Access Capabilities
Identifies PowerShell script block content that queries Veeam credential tables or uses ProtectedStorage to decrypt stored
secrets. Attackers abuse Veeam credentials to access backup infrastructure and enable ransomware operations.
**Rule type**: query
**Rule indices**:
- winlogbeat-*
- logs-windows.powershell*

**Rule Severity**: medium
**Risk Score**: 47
**Runs every**: 
**Searches indices from**: `now-9m`
**Maximum alerts per execution**: 100
**References**:
- [[https://forums.veeam.com/veeam-backup-replication-f2/recover-esxi-password-in-veeam-t34630.html](https://forums.veeam.com/veeam-backup-replication-f2/recover-esxi-password-in-veeam-t34630.html)](https://forums.veeam.com/veeam-backup-replication-f2/recover-esxi-password-in-veeam-t34630.html)
- [[https://www.crowdstrike.com/blog/anatomy-of-alpha-spider-ransomware/](https://www.crowdstrike.com/blog/anatomy-of-alpha-spider-ransomware/)](https://www.crowdstrike.com/blog/anatomy-of-alpha-spider-ransomware/)

**Tags**:
- Domain: Endpoint
- OS: Windows
- Use Case: Threat Detection
- Tactic: Credential Access
- Data Source: PowerShell Logs
- Resources: Investigation Guide

**Version**: 107
**Rule authors**:
- Elastic

**Rule license**: Elastic License v2

## Setup

PowerShell Script Block Logging must be enabled to generate the events used by this rule (e.g., 4104).
Setup instructions: [https://ela.st/powershell-logging-setup](https://ela.st/powershell-logging-setup)

## Investigation guide


## Triage and analysis> **Disclaimer**:
This investigation guide was created using generative AI technology and has been reviewed to improve its accuracy and relevance. While every effort has been made to ensure its quality, we recommend validating the content and adapting it to suit your specific environment and operational needs.

### Investigating PowerShell Script with Veeam Credential Access Capabilities

This alert indicates PowerShell script content consistent with accessing credential material used by Veeam, either by querying the Veeam configuration database credential table or by invoking ProtectedStorage decryption routines. Because backup credentials often provide privileged access to infrastructure and backup systems, treat this activity as high risk until verified as authorized.

#### Key alert fields to review

- `user.name`, `user.domain`, `user.id`: Account execution context for correlation, prioritization, and scoping.
- `host.name`, `host.id`: Host execution context for correlation, prioritization, and scoping.
- `powershell.file.script_block_text`: Script block content that matched the detection logic.
- `powershell.file.script_block_id`, `powershell.sequence`, `powershell.total`: Script block metadata to pivot to other fragments or reconstruct full script content when split across multiple events.
- `file.path`, `file.directory`, `file.name`: File-origin context when the script block is sourced from an on-disk file.
- `powershell.file.script_block_length`: Script block length (size) context.


#### Possible investigation steps

- Confirm execution context and prioritize:
  - Review `host.name` and `host.id` to determine whether the activity occurred on a host expected to administer Veeam or access its configuration database.
- Review `user.name`, `user.domain`, and `user.id` to determine whether the initiating account is expected to perform backup administration, database querying, or credential recovery activities.
- Note the alert `@timestamp` and determine whether it aligns with an approved maintenance window or change activity.
- Analyze the script block content for intent:
  - Review `powershell.file.script_block_text` to understand which capability is present:
  - Credential table access patterns (for example, references to `[dbo].[Credentials]` with Veeam-related identifiers).
- ProtectedStorage decryption usage (for example, `ProtectedStorage]::GetLocalString`), which may indicate an attempt to decrypt stored secret material.
- Identify and record any embedded target details present in the script content (database server names, instances, connection parameters, or credential object identifiers) to drive scoping and correlation.
- Look for evidence of data handling that suggests extraction, such as formatting credential data, aggregating results, writing output to disk, or preparing data for transfer.
- Reconstruct the complete script when split across multiple events:
  - Group related events by `powershell.file.script_block_id` and order them by `powershell.sequence` through `powershell.total` to rebuild the full script logic before assessing intent.
- If only one fragment triggered the alert, ensure you retrieve the remaining fragments for the same `powershell.file.script_block_id`, since supporting logic may be contained in non-matching fragments.
- Use `powershell.file.script_block_length` as context; unusually large script blocks can indicate imported tooling or staged functionality rather than routine administration.
- Determine script origin and assess whether it is expected:
  - If `file.path`, `file.directory`, or `file.name` are present, identify the on-disk script source and evaluate whether the location and naming align with approved administrative scripts (versus unexpected user-writable locations).
- If file metadata is absent, consider inline or remote execution and prioritize correlation with other endpoint telemetry to identify how PowerShell was initiated.
- Scope within PowerShell telemetry:
  - Search for additional PowerShell script block activity from the same `host.name` and `user.name` near the alert time to identify surrounding steps (database connectivity setup, credential parsing, decryption routines, or output handling).
- Pivot on `powershell.file.script_block_id` to determine whether the script was executed repeatedly on the same host, and whether the same script appears on other hosts or under different users.
- Search for other occurrences of the same key strings in `powershell.file.script_block_text` across hosts and users to identify broader use, reuse, or distribution.
- Correlate with adjacent telemetry to validate access and identify follow-on behavior:
  - Process execution telemetry: determine whether PowerShell activity was interactive or triggered by another process, and whether the launch chain is expected for the user and host.
- Network telemetry: check for connections from the alerting host to database servers and to backup-related infrastructure around the alert time, and validate whether the destinations are expected.
- Authentication telemetry: look for new or unusual logons involving the initiating user or any accounts referenced in the script content, especially to backup servers, database servers, and other high-value systems.
- Database auditing (if available): review authentication and query activity against the Veeam configuration database around the alert time for evidence of credential table access, repeated extraction attempts, or unusual query volume.
- Assess potential impact:
  - Determine whether the script indicates bulk credential extraction versus targeted credential retrieval.
- Review for subsequent activity that could indicate use of obtained credentials to access or modify backup infrastructure, including actions that reduce recovery options.


### False positive analysis

- Approved Veeam administration, troubleshooting, or support workflows may reference the Veeam configuration database schema and credential storage routines; validate authorization, operator identity, and business justification.
- Maintenance activities such as upgrades, migrations, or recoveries may require credential-related queries or decryption logic; confirm timing, scope, and the designated administrators and hosts involved.
- Internal security testing may intentionally validate credential exposure paths; confirm test authorization and ensure results are handled and stored securely.
- Custom automation or reporting that interfaces with the Veeam database can trigger this alert; validate script ownership, change control approval, and that outputs do not expose secrets.


### Response and remediation

- If activity is not authorized, treat it as a credential access incident:
  - Contain the affected host to prevent additional credential access and potential follow-on actions against backup infrastructure.
- Restrict or disable the initiating account (`user.name` / `user.id`) as appropriate, and review recent activity for signs of compromise.
- Preserve evidence for incident response:
  - Retain the full reconstructed script content using `powershell.file.script_block_id` with `powershell.sequence` and `powershell.total`, along with `host.name`, `host.id`, `user.name`, `user.domain`, and `user.id`.
- If `file.path` is present, preserve the referenced script file and any related artifacts in the same directory for forensic review.
- Assume Veeam-stored credentials may be compromised:
  - Rotate credentials that could be accessed via the Veeam configuration database or decrypted via ProtectedStorage routines, and review where they are used across backup jobs and infrastructure integrations.
- Review privileged access to backup systems and database servers for unauthorized use after the alert time.
- Reduce future exposure:
  - Limit access to the Veeam configuration database to approved administrative hosts and accounts, and review permissions related to credential storage.
- Review Veeam administrative role assignments and access paths to ensure least privilege.
- Validate recovery readiness:
  - Review backup job, repository, and retention configurations for unauthorized changes.
- Confirm the availability of recent backups and perform integrity checks consistent with your recovery procedures.
- Continue monitoring and hunting:
  - Monitor for recurrence of the identified script patterns across hosts and users, and investigate any additional related PowerShell activity discovered during scoping.


## Rule Query

```kuery
event.category:process and host.os.type:windows and
  powershell.file.script_block_text : (
    (
      "[dbo].[Credentials]" and
      ("Veeam" or "VeeamBackup")
    ) or
    "ProtectedStorage]::GetLocalString"
  )
```

**Framework:** MITRE ATT&CK
- Tactic:
  - Name: Credential Access
- Id: TA0006
- Reference URL: [[https://attack.mitre.org/tactics/TA0006/](https://attack.mitre.org/tactics/TA0006/)](https://attack.mitre.org/tactics/TA0006/)
- Technique:
  - Name: OS Credential Dumping
- Id: T1003
- Reference URL: [[https://attack.mitre.org/techniques/T1003/](https://attack.mitre.org/techniques/T1003/)](https://attack.mitre.org/techniques/T1003/)
- Technique:
  - Name: Credentials from Password Stores
- Id: T1555
- Reference URL: [[https://attack.mitre.org/techniques/T1555/](https://attack.mitre.org/techniques/T1555/)](https://attack.mitre.org/techniques/T1555/)

**Framework:** MITRE ATT&CK
- Tactic:
  - Name: Execution
- Id: TA0002
- Reference URL: [[https://attack.mitre.org/tactics/TA0002/](https://attack.mitre.org/tactics/TA0002/)](https://attack.mitre.org/tactics/TA0002/)
- Technique:
  - Name: Command and Scripting Interpreter
- Id: T1059
- Reference URL: [[https://attack.mitre.org/techniques/T1059/](https://attack.mitre.org/techniques/T1059/)](https://attack.mitre.org/techniques/T1059/)
- Sub Technique:
  - Name: PowerShell
- Id: T1059.001
- Reference URL: [[https://attack.mitre.org/techniques/T1059/001/](https://attack.mitre.org/techniques/T1059/001/)](https://attack.mitre.org/techniques/T1059/001/)