﻿---
title: Potential PowerShell Pass-the-Hash/Relay Script
description: Detects PowerShell scripts associated with NTLM relay or pass-the-hash tooling and SMB/NTLM negotiation artifacts. Attackers use relay and PtH techniques...
url: https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/windows/credential_access_posh_relay_tools
products:
  - Elastic Security
---

# Potential PowerShell Pass-the-Hash/Relay Script
Detects PowerShell scripts associated with NTLM relay or pass-the-hash tooling and SMB/NTLM negotiation
artifacts. Attackers use relay and PtH techniques to authenticate without passwords and pivot to other systems.
**Rule type**: query
**Rule indices**:
- winlogbeat-*
- logs-windows.powershell*

**Rule Severity**: high
**Risk Score**: 73
**Runs every**: 
**Searches indices from**: `now-9m`
**Maximum alerts per execution**: 100
**References**:
- [[https://github.com/Kevin-Robertson/Invoke-TheHash/blob/master/Invoke-WMIExec.ps1](https://github.com/Kevin-Robertson/Invoke-TheHash/blob/master/Invoke-WMIExec.ps1)](https://github.com/Kevin-Robertson/Invoke-TheHash/blob/master/Invoke-WMIExec.ps1)
- [[https://github.com/Kevin-Robertson/Invoke-TheHash/blob/master/Invoke-SMBExec.ps1](https://github.com/Kevin-Robertson/Invoke-TheHash/blob/master/Invoke-SMBExec.ps1)](https://github.com/Kevin-Robertson/Invoke-TheHash/blob/master/Invoke-SMBExec.ps1)
- [[https://github.com/dafthack/Check-LocalAdminHash/blob/master/Check-LocalAdminHash.ps1](https://github.com/dafthack/Check-LocalAdminHash/blob/master/Check-LocalAdminHash.ps1)](https://github.com/dafthack/Check-LocalAdminHash/blob/master/Check-LocalAdminHash.ps1)
- [[https://github.com/nettitude/PoshC2/blob/master/resources/modules/Invoke-Tater.ps1](https://github.com/nettitude/PoshC2/blob/master/resources/modules/Invoke-Tater.ps1)](https://github.com/nettitude/PoshC2/blob/master/resources/modules/Invoke-Tater.ps1)
- [[https://github.com/Kevin-Robertson/Inveigh/blob/master/Inveigh.ps1](https://github.com/Kevin-Robertson/Inveigh/blob/master/Inveigh.ps1)](https://github.com/Kevin-Robertson/Inveigh/blob/master/Inveigh.ps1)

**Tags**:
- Domain: Endpoint
- OS: Windows
- Use Case: Threat Detection
- Tactic: Credential Access
- Resources: Investigation Guide
- Data Source: PowerShell Logs

**Version**: 108
**Rule authors**:
- Elastic

**Rule license**: Elastic License v2

## Setup

PowerShell Script Block Logging must be enabled to generate the events used by this rule (e.g., 4104).
Setup instructions: [https://ela.st/powershell-logging-setup](https://ela.st/powershell-logging-setup)

## Investigation guide


## Triage and analysis> **Disclaimer**:
This investigation guide was created using generative AI technology and has been reviewed to improve its accuracy and relevance. While every effort has been made to ensure its quality, we recommend validating the content and adapting it to suit your specific environment and operational needs.

### Investigating Potential PowerShell Pass-the-Hash/Relay Script

This alert indicates PowerShell script block content consistent with low-level NTLM and SMB/SMB2 negotiation handling. These artifacts are commonly embedded in credential relay and pass-the-hash tooling and can be associated with credential access and lateral movement activity.

#### Key alert fields to review

- `user.name`, `user.domain`, `user.id`: Account execution context for correlation, prioritization, and scoping.
- `host.name`, `host.id`: Host execution context for correlation, prioritization, and scoping.
- `powershell.file.script_block_text`: Script block content that matched the detection logic.
- `powershell.file.script_block_id`, `powershell.sequence`, `powershell.total`: Script block metadata to pivot to other fragments or reconstruct full script content when split across multiple events.
- `file.path`, `file.directory`, `file.name`: File-origin context when the script block is sourced from an on-disk file.
- `powershell.file.script_block_length`: Script block length (size) context.


#### Possible investigation steps

- Review `powershell.file.script_block_text` to understand capability and intent:
  - Identify whether the script is building, parsing, or transmitting NTLMSSP messages and SMB/SMB2 negotiation data (often represented as hex strings or byte arrays).
- Determine whether the logic aligns more closely with:
  - A capture/relay workflow (for example, listener-style components, authentication forwarding, or multiple inbound and outbound endpoints), or
- A pass-the-hash style workflow (for example, authentication material variables combined with remote access or remote execution logic).
- Note any tool identifiers, function names, or comments that resemble known PowerShell relay/PtH frameworks (for example, Inveigh, Invoke-TheHash, Invoke-SMBExec, Invoke-WMIExec, or Invoke-Tater).
- Extract any referenced remote targets or infrastructure (hostnames, IP addresses, UNC paths, share names, or URLs) and record them for scoping and downstream validation.
- Reconstruct the complete script when the content is split across multiple events:
  - Pivot on `powershell.file.script_block_id` and order fragments by `powershell.sequence`; use `powershell.total` to confirm the script is complete.
- Review other script blocks for the same host and user around the alert time to capture configuration values, embedded payloads, or follow-on actions not present in the matching fragment.
- Establish execution context and expectedness:
  - Validate the execution context using `host.name`, `host.id`, `user.name`, `user.domain`, and `user.id`.
- Prioritize investigation when the executing account is privileged, rarely uses PowerShell on the host, or when the host is a server or administrative jump system.
- Use `powershell.file.script_block_length` to help gauge whether this resembles embedded tooling (larger or highly structured blocks) versus incidental string handling.
- Identify script origin (when file context is available):
  - If `file.path`, `file.directory`, or `file.name` are present, determine whether the script originated from disk and whether the location and naming align with approved scripts and expected operators.
- Treat scripts sourced from user-writable or temporary locations as higher risk, especially when combined with protocol-crafting logic.
- Correlate with adjacent telemetry to understand how PowerShell was launched and what occurred afterward (if available in your environment):
  - Review process activity near `@timestamp` on the same host to identify the PowerShell host process and its parent process, and whether execution appears interactive, scheduled, or remotely initiated.
- Review network and authentication activity from the same host and user near the alert time for evidence of SMB or other NTLM-based authentication attempts to multiple targets, repeated failures, or unusual destination systems.
- Look for short-following activity consistent with lateral movement (for example, remote management actions, remote execution behaviors, or additional suspicious PowerShell script blocks).
- Expand the scope and hunt for related activity:
  - Search for additional occurrences of distinctive strings or byte patterns from `powershell.file.script_block_text` across other hosts to identify reuse of the same tooling or broader compromise.
- Review other alerts tied to the same `user.id` and `host.id` within a broader window to identify credential access precursors, staging behavior, or persistence attempts.


### False positive analysis

- False positives can occur during authorized security testing, incident response, or troubleshooting where scripts intentionally craft or parse NTLM/SMB protocol messages.
- Validate whether the activity is expected by confirming the script owner (when `file.path` is present), the approved operator, and whether the host and account match the intended scope for such work.
- Benign administrative automation rarely embeds raw NTLMSSP/SMB negotiation byte sequences; prioritize additional review when the script content implements low-level protocol logic or includes relay-style workflows.


### Response and remediation

- If malicious or unauthorized activity is suspected:
  - Contain the affected host to reduce the risk of credential interception and lateral movement.
- Preserve evidence, including the full reconstructed script content, relevant PowerShell log events, and any on-disk script files referenced by `file.path`.
- Identify potentially impacted accounts using `user.name`, `user.domain`, and `user.id`; take credential containment actions per policy (for example, password resets, revocation of exposed credentials, and review of privileged access).
- Investigate potential lateral movement by reviewing activity on any systems referenced in the script content and by hunting for the same script patterns across other hosts.
- If the activity is confirmed benign:
  - Document the business justification and expected host/account scope, and ensure appropriate approvals are in place.
- Apply targeted tuning using stable attributes such as known script paths, approved execution accounts, or consistent script content patterns.


## Rule Query

```kuery
event.category:process and host.os.type:windows and
  powershell.file.script_block_text : (
    ("NTLMSSPNegotiate" and ("NegotiateSMB" or "NegotiateSMB2")) or
    "4E544C4D53535000" or
    "0x4e,0x54,0x4c,0x4d,0x53,0x53,0x50" or
    "0x4e,0x54,0x20,0x4c,0x4d" or
    "0x53,0x4d,0x42,0x20,0x32" or
    "0x81,0xbb,0x7a,0x36,0x44,0x98,0xf1,0x35,0xad,0x32,0x98,0xf0,0x38"
  ) and
  not file.directory : "C:\ProgramData\Microsoft\Windows Defender Advanced Threat Protection\Downloads"
```

**Framework:** MITRE ATT&CK
- Tactic:
  - Name: Credential Access
- Id: TA0006
- Reference URL: [[https://attack.mitre.org/tactics/TA0006/](https://attack.mitre.org/tactics/TA0006/)](https://attack.mitre.org/tactics/TA0006/)
- Technique:
  - Name: Adversary-in-the-Middle
- Id: T1557
- Reference URL: [[https://attack.mitre.org/techniques/T1557/](https://attack.mitre.org/techniques/T1557/)](https://attack.mitre.org/techniques/T1557/)

**Framework:** MITRE ATT&CK
- Tactic:
  - Name: Execution
- Id: TA0002
- Reference URL: [[https://attack.mitre.org/tactics/TA0002/](https://attack.mitre.org/tactics/TA0002/)](https://attack.mitre.org/tactics/TA0002/)
- Technique:
  - Name: Command and Scripting Interpreter
- Id: T1059
- Reference URL: [[https://attack.mitre.org/techniques/T1059/](https://attack.mitre.org/techniques/T1059/)](https://attack.mitre.org/techniques/T1059/)
- Sub Technique:
  - Name: PowerShell
- Id: T1059.001
- Reference URL: [[https://attack.mitre.org/techniques/T1059/001/](https://attack.mitre.org/techniques/T1059/001/)](https://attack.mitre.org/techniques/T1059/001/)

**Framework:** MITRE ATT&CK
- Tactic:
  - Name: Lateral Movement
- Id: TA0008
- Reference URL: [[https://attack.mitre.org/tactics/TA0008/](https://attack.mitre.org/tactics/TA0008/)](https://attack.mitre.org/tactics/TA0008/)
- Technique:
  - Name: Use Alternate Authentication Material
- Id: T1550
- Reference URL: [[https://attack.mitre.org/techniques/T1550/](https://attack.mitre.org/techniques/T1550/)](https://attack.mitre.org/techniques/T1550/)
- Sub Technique:
  - Name: Pass the Hash
- Id: T1550.002
- Reference URL: [[https://attack.mitre.org/techniques/T1550/002/](https://attack.mitre.org/techniques/T1550/002/)](https://attack.mitre.org/techniques/T1550/002/)