﻿---
title: PowerShell MiniDump Script
description: Detects PowerShell scripts referencing MiniDumpWriteDump or full-memory minidump types, which can capture process memory. Attackers often use this technique...
url: https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/windows/credential_access_posh_minidump
products:
  - Elastic Security
---

# PowerShell MiniDump Script
Detects PowerShell scripts referencing MiniDumpWriteDump or full-memory minidump types, which can capture
process memory. Attackers often use this technique to dump credential-bearing processes like LSASS for credential theft.
**Rule type**: query
**Rule indices**:
- winlogbeat-*
- logs-windows.powershell*

**Rule Severity**: high
**Risk Score**: 73
**Runs every**: 
**Searches indices from**: `now-9m`
**Maximum alerts per execution**: 100
**References**:
- [[https://github.com/PowerShellMafia/PowerSploit/blob/master/Exfiltration/Out-Minidump.ps1](https://github.com/PowerShellMafia/PowerSploit/blob/master/Exfiltration/Out-Minidump.ps1)](https://github.com/PowerShellMafia/PowerSploit/blob/master/Exfiltration/Out-Minidump.ps1)
- [[https://github.com/FuzzySecurity/PowerShell-Suite/blob/master/Get-ProcessMiniDump.ps1](https://github.com/FuzzySecurity/PowerShell-Suite/blob/master/Get-ProcessMiniDump.ps1)](https://github.com/FuzzySecurity/PowerShell-Suite/blob/master/Get-ProcessMiniDump.ps1)
- [[https://github.com/atc-project/atc-data/blob/master/docs/Logging_Policies/LP_0109_windows_powershell_script_block_log.md](https://github.com/atc-project/atc-data/blob/master/docs/Logging_Policies/LP_0109_windows_powershell_script_block_log.md)](https://github.com/atc-project/atc-data/blob/master/docs/Logging_Policies/LP_0109_windows_powershell_script_block_log.md)

**Tags**:
- Domain: Endpoint
- OS: Windows
- Use Case: Threat Detection
- Tactic: Credential Access
- Resources: Investigation Guide
- Data Source: PowerShell Logs

**Version**: 213
**Rule authors**:
- Elastic

**Rule license**: Elastic License v2

## Setup

PowerShell Script Block Logging must be enabled to generate the events used by this rule (e.g., 4104).
Setup instructions: [https://ela.st/powershell-logging-setup](https://ela.st/powershell-logging-setup)

## Investigation guide


## Triage and analysis> **Disclaimer**:
This investigation guide was created using generative AI technology and has been reviewed to improve its accuracy and relevance. While every effort has been made to ensure its quality, we recommend validating the content and adapting it to suit your specific environment and operational needs.

### Investigating PowerShell MiniDump Script

This alert identifies PowerShell script block content that references MiniDumpWriteDump or a full-memory minidump type. This capability can be used to capture process memory and, if aimed at credential-bearing processes (for example, LSASS), may enable credential theft. The goal of the investigation is to determine intent, identify the target process and any dump artifacts, validate execution context, and scope related activity.

#### Key alert fields to review

- `user.name`, `user.domain`, `user.id`: Account execution context for correlation, prioritization, and scoping.
- `host.name`, `host.id`: Host execution context for correlation, prioritization, and scoping.
- `powershell.file.script_block_text`: Script block content that matched the detection logic.
- `powershell.file.script_block_id`, `powershell.sequence`, `powershell.total`: Script block metadata to pivot to other fragments or reconstruct full script content when split across multiple events.
- `file.path`, `file.directory`, `file.name`: File-origin context when the script block is sourced from an on-disk file.
- `powershell.file.script_block_length`: Script block length (size) context.


#### Possible investigation steps

- Validate alert context and exposure:
  - Review `host.name` and `host.id` to understand where the activity occurred and whether the host is expected to run administrative PowerShell workflows.
- Review `user.name`, `user.domain`, and `user.id` to determine whether the account is expected to perform troubleshooting or diagnostic actions that could include memory dumps.
- Analyze the script block for intent and capability:
  - Review `powershell.file.script_block_text` to identify how the script invokes memory dumping functionality:
  - Look for direct references to `MiniDumpWriteDump` or full-memory minidump flags, including simple obfuscation (for example, reversed strings such as `pmuDetirWpmuDiniM`).
- Identify how the function is loaded or called (for example, dynamic invocation patterns, embedded code, or calls into Windows components referenced in the script content).
- Identify target selection logic (process name, PID, handle acquisition, or enumeration) and whether the intended target appears sensitive (for example, LSASS).
- Identify any dump artifact handling in the script content, such as output path/filename patterns, compression or encoding steps, cleanup (delete/move), or staging behavior.
- Use `powershell.file.script_block_length` as a quick signal for unusually large or complex content that may indicate embedded code, obfuscation, or multi-stage logic.
- Reconstruct complete script content when split across events:
  - If the script appears incomplete or segmented, pivot using `powershell.file.script_block_id` and order fragments by `powershell.sequence` up to `powershell.total`.
- Re-review the reconstructed content to ensure the suspected dump logic is not part of a larger workflow (for example, download, execution, artifact handling, or cleanup steps).
- Determine execution source and assess legitimacy:
  - If `file.path`, `file.directory`, or `file.name` are present, treat them as the source script context and determine whether the script location and naming align with approved administrative tooling in your environment.
- If file-origin fields are absent, treat the activity as potentially interactive or dynamically generated and prioritize understanding how the content was introduced (for example, ad-hoc execution, copied code, or a scripted task).
- Scope and correlate related PowerShell activity:
  - On the same `host.id` and `user.id`, review adjacent PowerShell script block activity around the alert time to identify:
  - Additional dumping attempts (different minidump types or alternate invocation patterns).
- Follow-on handling of dump output (archiving, encoding, or transfer logic referenced in script text).
- Attempts to reduce visibility or rapidly clean up artifacts (explicit deletion or overwrite logic referenced in script text).
- Look for evidence of a dump artifact and potential data movement (as available in your environment):
  - Investigate whether a memory dump file was created shortly after the alert on the same host, and whether it was renamed, moved, archived, or deleted soon after creation.
- Review any available network telemetry for the host around the alert time for unusual outbound activity that could indicate transfer of a dump artifact (for example, large uploads or new external destinations).
- Assess potential impact:
  - If the script content indicates a credential-bearing process was targeted, treat local credentials on the host as potentially exposed and increase priority for containment and credential hygiene actions.
- Use the key strings and patterns identified in `powershell.file.script_block_text` to search for additional occurrences across hosts and users to identify broader exposure.


### False positive analysis

- Legitimate diagnostic workflows may use process dumps for troubleshooting, crash analysis, or vendor support. These cases often have clear ownership, approved scripts, and controlled storage locations for dump artifacts.
- Internal security or IT teams may collect memory dumps for authorized incident response or forensic collection. Validate whether the activity aligns with a documented procedure and an expected operator and host scope.
- Suspicion should increase when the script targets credential-bearing processes, uses basic obfuscation, writes artifacts to unusual or user-writable locations, rapidly stages or removes artifacts, or appears on hosts/users that do not typically perform diagnostic dumping.


### Response and remediation

- If the activity is suspicious or unauthorized:
  - Contain the host to reduce the risk of credential theft and lateral movement.
- Preserve evidence:
  - Retain the full `powershell.file.script_block_text` content (including any reconstructed fragments via `powershell.file.script_block_id`, `powershell.sequence`, and `powershell.total`).
- Preserve any identified on-disk source script referenced by `file.path` / `file.name`, and collect any dump artifacts discovered during scoping.
- Record the associated `host.id` / `host.name` and `user.id` / `user.name` / `user.domain` for incident tracking and scoping.
- Determine credential exposure and take appropriate action:
  - Prioritize credential resets/rotation for accounts that may have been exposed if a credential-bearing process was targeted.
- Review for signs of credential misuse originating from the affected host or account following the alert.
- Hunt for related activity:
  - Search for additional occurrences of the same dumping strings and function patterns across the environment.
- Identify other hosts where the same user executed similar script content.
- If the activity is authorized but unexpected:
  - Document the owner, business justification, and expected operating scope (hosts, users, and timeframe).
- Ensure dump artifacts are stored securely, access is restricted, and retention is minimized to reduce credential exposure risk.
- Preventive and hardening actions:
  - Restrict who can perform diagnostic dumping and where dumps can be written.
- Maintain and monitor PowerShell script block logging coverage and retention to support script reconstruction and scoping during investigations.


## Rule Query

```kuery
event.category:process and host.os.type:windows and powershell.file.script_block_text:(MiniDumpWriteDump or MiniDumpWithFullMemory or pmuDetirWpmuDiniM) and not user.id : "S-1-5-18"
```

**Framework:** MITRE ATT&CK
- Tactic:
  - Name: Credential Access
- Id: TA0006
- Reference URL: [[https://attack.mitre.org/tactics/TA0006/](https://attack.mitre.org/tactics/TA0006/)](https://attack.mitre.org/tactics/TA0006/)
- Technique:
  - Name: OS Credential Dumping
- Id: T1003
- Reference URL: [[https://attack.mitre.org/techniques/T1003/](https://attack.mitre.org/techniques/T1003/)](https://attack.mitre.org/techniques/T1003/)
- Sub Technique:
  - Name: LSASS Memory
- Id: T1003.001
- Reference URL: [[https://attack.mitre.org/techniques/T1003/001/](https://attack.mitre.org/techniques/T1003/001/)](https://attack.mitre.org/techniques/T1003/001/)

**Framework:** MITRE ATT&CK
- Tactic:
  - Name: Execution
- Id: TA0002
- Reference URL: [[https://attack.mitre.org/tactics/TA0002/](https://attack.mitre.org/tactics/TA0002/)](https://attack.mitre.org/tactics/TA0002/)
- Technique:
  - Name: Command and Scripting Interpreter
- Id: T1059
- Reference URL: [[https://attack.mitre.org/techniques/T1059/](https://attack.mitre.org/techniques/T1059/)](https://attack.mitre.org/techniques/T1059/)
- Sub Technique:
  - Name: PowerShell
- Id: T1059.001
- Reference URL: [[https://attack.mitre.org/techniques/T1059/001/](https://attack.mitre.org/techniques/T1059/001/)](https://attack.mitre.org/techniques/T1059/001/)