﻿---
title: PowerShell Kerberos Ticket Dump
description: Detects PowerShell script block content that references LSA Kerberos ticket retrieval APIs and Kerb* message types. Attackers dump Kerberos tickets from...
url: https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/windows/credential_access_posh_kerb_ticket_dump
products:
  - Elastic Security
---

# PowerShell Kerberos Ticket Dump
Detects PowerShell script block content that references LSA Kerberos ticket retrieval APIs and Kerb* message types.
Attackers dump Kerberos tickets from memory to reuse credentials and move laterally.
**Rule type**: query
**Rule indices**:
- winlogbeat-*
- logs-windows.powershell*

**Rule Severity**: high
**Risk Score**: 73
**Runs every**: 
**Searches indices from**: `now-9m`
**Maximum alerts per execution**: 100
**References**:
- [[https://github.com/MzHmO/PowershellKerberos/blob/main/dumper.ps1](https://github.com/MzHmO/PowershellKerberos/blob/main/dumper.ps1)](https://github.com/MzHmO/PowershellKerberos/blob/main/dumper.ps1)

**Tags**:
- Domain: Endpoint
- OS: Windows
- Use Case: Threat Detection
- Tactic: Credential Access
- Data Source: PowerShell Logs
- Resources: Investigation Guide

**Version**: 111
**Rule authors**:
- Elastic

**Rule license**: Elastic License v2

## Setup

PowerShell Script Block Logging must be enabled to generate the events used by this rule (e.g., 4104).
Setup instructions: [https://ela.st/powershell-logging-setup](https://ela.st/powershell-logging-setup)

## Investigation guide


## Triage and analysis> **Disclaimer**:
This investigation guide was created using generative AI technology and has been reviewed to improve its accuracy and relevance. While every effort has been made to ensure its quality, we recommend validating the content and adapting it to suit your specific environment and operational needs.

### Investigating PowerShell Kerberos Ticket Dump

This alert identifies PowerShell script block content referencing the LSA Kerberos authentication package API `LsaCallAuthenticationPackage` along with Kerberos ticket cache query and ticket retrieval message types. This pattern is consistent with tooling that enumerates, extracts, or manipulates Kerberos tickets from memory, which can enable credential reuse and lateral movement.

#### Key alert fields to review

- `user.name`, `user.domain`, `user.id`: Account execution context for correlation, prioritization, and scoping.
- `host.name`, `host.id`: Host execution context for correlation, prioritization, and scoping.
- `powershell.file.script_block_text`: Script block content that matched the detection logic.
- `powershell.file.script_block_id`, `powershell.sequence`, `powershell.total`: Script block metadata to pivot to other fragments or reconstruct full script content when split across multiple events.
- `file.path`, `file.directory`, `file.name`: File-origin context when the script block is sourced from an on-disk file.
- `powershell.file.script_block_length`: Script block length (size) context.


#### Possible investigation steps

- Reconstruct and preserve the full script content:
  - Use `powershell.file.script_block_id` to gather all related fragments and order them by `powershell.sequence` up to `powershell.total`.
- Preserve the reconstructed content from `powershell.file.script_block_text` for case notes and to support environment-wide scoping.
- Use `powershell.file.script_block_length` to understand whether the content is a full implementation, a loader/stager, or a small inline snippet that may be part of a larger sequence of script blocks.
- Identify the specific Kerberos capability referenced:
  - Review `powershell.file.script_block_text` and note which message types are present. Use this to prioritize severity and intent:
  - Cache enumeration indicators: `KerbQueryTicketCacheMessage`, `KerbQueryTicketCacheExMessage`, `KerbQueryTicketCacheEx2Message`
- Ticket retrieval/export indicators: `KerbRetrieveTicketMessage`, `KerbRetrieveEncodedTicketMessage`
- Ticket-related decryption indicators: `KerbDecryptDataMessage`
- Determine whether the script only defines interop types/functions or includes invocation logic that executes ticket operations and processes results.
- Look for signs that output is being prepared for reuse or transfer (e.g., structured serialization, encoding, or explicit output handling). If `file.path` is populated, assess whether the script is associated with a specific on-disk source.
- Validate execution context and plausibility:
  - Review `@timestamp`, `host.name`/`host.id`, and `user.name`/`user.domain`/`user.id` to confirm where and under which identity the activity occurred.
- Assess whether the user and host context align with expected administrative or troubleshooting activity in your environment. Unexpected use by standard users, or on endpoints where administrative scripting is uncommon, should be treated as higher risk.
- If `file.path`/`file.name` (and `file.directory`, if present) indicate an on-disk origin, evaluate whether the location is consistent with approved scripts. Treat user-writable and temporary locations as higher risk, especially when combined with ticket retrieval/decryption indicators.
- Scope for additional PowerShell activity on the same host and user:
  - Pivot on `host.id` and `user.id` to review other script block activity near `@timestamp` to identify precursors (staging, discovery) and follow-on actions (additional credential access attempts, lateral movement preparation).
- Check for repeated execution patterns: multiple script blocks with similar content, repeated `powershell.file.script_block_id` occurrences, or the same `file.name` appearing multiple times in a short window.
- Assess prevalence across the environment:
  - Search for the same or highly similar `powershell.file.script_block_text` content (or distinctive substrings) across hosts to determine whether this is isolated or widespread.
- If `file.name` is present, look for the same script name used across multiple hosts. Consistent, predictable use may indicate managed tooling; sporadic or single-host use may indicate targeted activity.
- Correlate with adjacent telemetry (when available):
  - Process telemetry: identify the PowerShell execution instance that produced the script block and determine the initiating process to establish whether execution was interactive, scheduled, or launched by another application.
- File telemetry: review for newly created or modified artifacts near `@timestamp` that could store extracted ticket material or related output.
- Network and authentication telemetry: review subsequent outbound activity and authentication attempts associated with the same host and/or user to identify potential ticket reuse and rapid lateral movement following the script execution.


### False positive analysis

- Some legitimate Kerberos troubleshooting and diagnostics workflows can reference LSA Kerberos APIs to query ticket cache state. Validate whether the script source (`file.path`/`file.name`), execution context (`user.id`, `host.id`), and timing align with an approved operational process.
- Administrative automation or security tooling may include Kerberos interop code for visibility or health checks. Benign usage is typically repeatable (consistent script content, consistent script origin, predictable execution patterns) and tied to known administrative accounts.
- Prioritize deeper investigation when the activity is one-off, appears only on a single host, is executed by unexpected users, or includes retrieval/decryption indicators rather than simple cache query logic.


### Response and remediation

- If the activity is unexpected or cannot be validated as authorized:
  - Isolate the affected host to reduce the risk of credential theft and lateral movement.
- Preserve evidence for scoping: retain the reconstructed `powershell.file.script_block_text`, `powershell.file.script_block_id`, host identifiers, user identifiers, and any on-disk script context (`file.path`, `file.name`).
- Treat as a potential credential access incident and initiate environment-wide scoping for similar script content and related activity from the same user and host.
- If Kerberos ticket theft or export is confirmed:
  - Remove the script source (as identified by `file.path`/`file.name`) and any related artifacts identified during triage.
- Reset or rotate credentials for impacted accounts and review privileged access paths associated with the affected host and user.
- Investigate for lateral movement following `@timestamp`, identify affected systems, and remediate access pathways used.
- Post-incident hardening:
  - Ensure PowerShell script block logging coverage and retention support reconstruction and historical scoping.
- Review administrative scripting controls and monitoring for unauthorized use of authentication-package APIs in PowerShell, and align execution permissions with least-privilege practices.


## Rule Query

```kuery
event.category:process and host.os.type:windows and
  powershell.file.script_block_text : (
    "LsaCallAuthenticationPackage" and
    (
      "KerbRetrieveEncodedTicketMessage" or
      "KerbQueryTicketCacheMessage" or
      "KerbQueryTicketCacheExMessage" or
      "KerbQueryTicketCacheEx2Message" or
      "KerbRetrieveTicketMessage" or
      "KerbDecryptDataMessage"
    )
  )
```

**Framework:** MITRE ATT&CK
- Tactic:
  - Name: Credential Access
- Id: TA0006
- Reference URL: [[https://attack.mitre.org/tactics/TA0006/](https://attack.mitre.org/tactics/TA0006/)](https://attack.mitre.org/tactics/TA0006/)
- Technique:
  - Name: OS Credential Dumping
- Id: T1003
- Reference URL: [[https://attack.mitre.org/techniques/T1003/](https://attack.mitre.org/techniques/T1003/)](https://attack.mitre.org/techniques/T1003/)
- Technique:
  - Name: Steal or Forge Kerberos Tickets
- Id: T1558
- Reference URL: [[https://attack.mitre.org/techniques/T1558/](https://attack.mitre.org/techniques/T1558/)](https://attack.mitre.org/techniques/T1558/)

**Framework:** MITRE ATT&CK
- Tactic:
  - Name: Execution
- Id: TA0002
- Reference URL: [[https://attack.mitre.org/tactics/TA0002/](https://attack.mitre.org/tactics/TA0002/)](https://attack.mitre.org/tactics/TA0002/)
- Technique:
  - Name: Command and Scripting Interpreter
- Id: T1059
- Reference URL: [[https://attack.mitre.org/techniques/T1059/](https://attack.mitre.org/techniques/T1059/)](https://attack.mitre.org/techniques/T1059/)
- Sub Technique:
  - Name: PowerShell
- Id: T1059.001
- Reference URL: [[https://attack.mitre.org/techniques/T1059/001/](https://attack.mitre.org/techniques/T1059/001/)](https://attack.mitre.org/techniques/T1059/001/)