﻿---
title: PowerShell Invoke-NinjaCopy script
description: Detects PowerShell script block content containing Invoke-NinjaCopy or related Stealth* functions used for direct volume file access. Attackers use NinjaCopy...
url: https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/windows/credential_access_posh_invoke_ninjacopy
products:
  - Elastic Security
---

# PowerShell Invoke-NinjaCopy script
Detects PowerShell script block content containing Invoke-NinjaCopy or related Stealth* functions used for direct volume
file access. Attackers use NinjaCopy to read locked system files such as NTDS.dit or registry hives for credential
dumping.
**Rule type**: query
**Rule indices**:
- winlogbeat-*
- logs-windows.powershell*

**Rule Severity**: high
**Risk Score**: 73
**Runs every**: 
**Searches indices from**: `now-9m`
**Maximum alerts per execution**: 100
**References**:
- [[https://github.com/BC-SECURITY/Empire/blob/main/empire/server/data/module_source/collection/Invoke-NinjaCopy.ps1](https://github.com/BC-SECURITY/Empire/blob/main/empire/server/data/module_source/collection/Invoke-NinjaCopy.ps1)](https://github.com/BC-SECURITY/Empire/blob/main/empire/server/data/module_source/collection/Invoke-NinjaCopy.ps1)

**Tags**:
- Domain: Endpoint
- OS: Windows
- Use Case: Threat Detection
- Tactic: Credential Access
- Data Source: PowerShell Logs
- Resources: Investigation Guide

**Version**: 111
**Rule authors**:
- Elastic

**Rule license**: Elastic License v2

## Investigation guide


## Triage and analysis> **Disclaimer**:
This investigation guide was created using generative AI technology and has been reviewed to improve its accuracy and relevance. While every effort has been made to ensure its quality, we recommend validating the content and adapting it to suit your specific environment and operational needs.

### Investigating PowerShell Invoke-NinjaCopy script

This rule identifies PowerShell script block content referencing `Invoke-NinjaCopy` or related `Stealth*` helper functions. These functions are commonly used to perform direct volume file reads that can bypass normal file locking and access controls, enabling copies of sensitive credential stores (for example, `NTDS.dit` or registry hives like `SAM`, `SYSTEM`, and `SECURITY`). The presence of these strings can represent tool staging (definition/import) or active execution, so focus on determining intent, targeted artifacts, output locations, and surrounding activity.

#### Key alert fields to review

- `user.name`, `user.domain`, `user.id`: Account execution context for correlation, prioritization, and scoping.
- `host.name`, `host.id`: Host execution context for correlation, prioritization, and scoping.
- `powershell.file.script_block_text`: Script block content that matched the detection logic.
- `powershell.file.script_block_id`, `powershell.sequence`, `powershell.total`: Script block metadata to pivot to other fragments or reconstruct full script content when split across multiple events.
- `file.path`, `file.directory`, `file.name`: File-origin context when the script block is sourced from an on-disk file.
- `powershell.file.script_block_length`: Script block length (size) context.


#### Possible investigation steps

- Triage the alert context:
  - Identify the affected `host.name` / `host.id` and the account (`user.name`, `user.domain`, `user.id`).
- Determine whether the host is expected to store credential material (for example, a directory services server) and whether the user is expected to perform privileged maintenance on it.
- Use the alert time (`@timestamp`) to define an initial correlation window and expand as needed.
- Analyze `powershell.file.script_block_text` to understand what was staged or executed:
  - Determine whether the content is primarily function definitions/module code (tool load) or includes direct invocation of `Invoke-NinjaCopy` and `Stealth*` functions.
- Extract any referenced source artifacts (for example, `NTDS.dit` or registry hives) and any destination/output file names, directories, or remote paths.
- Look for indicators of direct volume access, such as device/volume path handling, low-level file handle usage, delegates, or logic intended to bypass normal file locking.
- Identify follow-on logic that would support collection and handling (copy loops, chunking, archiving, encoding, renaming, or cleanup).
- Use script block metadata to reconstruct full content when logged in multiple parts:
  - Pivot on `powershell.file.script_block_id` for the same `host.id`.
- Order fragments by `powershell.sequence` and confirm the final part count matches `powershell.total`.
- If parts are missing, treat the content as incomplete and continue scoping for additional fragments.
- Preserve the reconstructed content and the original fragment events for case evidence.
- Determine script provenance when file context is present:
  - Review `file.path` / `file.name` (and `file.directory` if populated) to identify where the script was executed from.
- Treat execution from user-writable or temporary locations as higher risk, and scope for other executions originating from the same path or directory on the host.
- If file context is not present, consider interactive execution or remote delivery and expand scoping to other script blocks from the same `host.id` and `user.id` around the alert time.
- Scope for related PowerShell activity on the endpoint:
  - Review additional Script Block Logging events for the same `host.id` and `user.id` around the alert time to identify staging, retries, and post-collection actions.
- Use `powershell.file.script_block_length` to prioritize larger blocks that may contain full tooling, embedded functions, or post-processing logic.
- Prioritize script blocks that reference the same artifact names or output locations observed in the matched content.
- Assess prevalence across the environment:
  - Search for the same keywords within `powershell.file.script_block_text` (for example, `Invoke-NinjaCopy` and `StealthOpenFile`) across other hosts to identify broader deployment.
- If `file.path` or `file.name` is present, use it to identify reuse of the same script file across multiple hosts or users.
- Correlate with adjacent telemetry (if available) using `host.name`, `host.id`, `user.id`, and the alert time:
  - Process activity to identify the PowerShell host process and the parent/source that initiated it, and whether execution aligns with expected administrative workflows.
- File activity to confirm whether copies of targeted artifacts were created, where they were written, and whether they were later archived or moved.
- Network activity to identify outbound transfers or remote access shortly after script execution.
- Authentication activity to identify suspicious logons, privilege use, or lateral movement following potential credential material collection.
- Determine impact:
  - If the script indicates attempted access to directory services database files or registry hives, treat this as potential credential exposure until corroborating telemetry shows otherwise and respond accordingly.


### False positive analysis

- Approved security testing, adversary emulation, or controlled red team activity that includes NinjaCopy-derived code.
- Authorized incident response, forensic acquisition, or recovery workflows that require copying locked system files.
- Administrative tooling that embeds similar helper functions for troubleshooting or backup operations (uncommon); validate ownership, expected hosts, and change control.


### Response and remediation

- If the activity is not expected or cannot be attributed to an approved task:
  - Isolate the affected host to prevent additional collection, staging, or lateral movement.
- Take immediate steps to prevent further use of the implicated account (`user.id`) until legitimacy is confirmed.
- Preserve and collect evidence:
  - Save the full `powershell.file.script_block_text` and reconstruct missing fragments using `powershell.file.script_block_id`, `powershell.sequence`, and `powershell.total` where applicable.
- Record `@timestamp`, `host.name`, `host.id`, `user.name`, `user.domain`, `user.id`, and any available `file.path` / `file.name` context.
- Identify any destination/output locations referenced in the script content and preserve related artifacts (copied files, archives, temporary staging).
- Assess credential exposure and potential follow-on activity:
  - Use available endpoint telemetry to determine whether credential stores were successfully copied or staged.
- If credential stores may have been accessed or copied, follow your credential containment process and prioritize rotation of impacted and privileged credentials.
- Eradicate and scope:
  - Remove unauthorized scripts and supporting artifacts identified from `file.path` / `file.name` and from any output locations referenced in the script.
- Hunt for additional NinjaCopy-related script blocks across endpoints and for subsequent suspicious authentication activity associated with the same user and host context.
- Recover and harden:
  - Restore affected systems as needed and validate that no persistence remains.
- Reduce recurrence by tightening administrative scripting governance for PowerShell (least privilege, controlled script deployment locations, and application control where feasible) and by restricting access to systems that store credential material.


## Rule Query

```kuery
event.category:process and host.os.type:windows and
  powershell.file.script_block_text : (
    "StealthReadFile" or
    "StealthReadFileAddr" or
    "StealthCloseFileDelegate" or
    "StealthOpenFile" or
    "StealthCloseFile" or
    "StealthReadFile" or
    "Invoke-NinjaCopy"
   )
  and not user.id : "S-1-5-18"
  and not powershell.file.script_block_text : (
    "sentinelbreakpoints" and "Set-PSBreakpoint" and "PowerSploitIndicators"
  )
```

**Framework:** MITRE ATT&CK
- Tactic:
  - Name: Credential Access
- Id: TA0006
- Reference URL: [[https://attack.mitre.org/tactics/TA0006/](https://attack.mitre.org/tactics/TA0006/)](https://attack.mitre.org/tactics/TA0006/)
- Technique:
  - Name: OS Credential Dumping
- Id: T1003
- Reference URL: [[https://attack.mitre.org/techniques/T1003/](https://attack.mitre.org/techniques/T1003/)](https://attack.mitre.org/techniques/T1003/)
- Sub Technique:
  - Name: Security Account Manager
- Id: T1003.002
- Reference URL: [[https://attack.mitre.org/techniques/T1003/002/](https://attack.mitre.org/techniques/T1003/002/)](https://attack.mitre.org/techniques/T1003/002/)
- Sub Technique:
  - Name: NTDS
- Id: T1003.003
- Reference URL: [[https://attack.mitre.org/techniques/T1003/003/](https://attack.mitre.org/techniques/T1003/003/)](https://attack.mitre.org/techniques/T1003/003/)

**Framework:** MITRE ATT&CK
- Tactic:
  - Name: Execution
- Id: TA0002
- Reference URL: [[https://attack.mitre.org/tactics/TA0002/](https://attack.mitre.org/tactics/TA0002/)](https://attack.mitre.org/tactics/TA0002/)
- Technique:
  - Name: Command and Scripting Interpreter
- Id: T1059
- Reference URL: [[https://attack.mitre.org/techniques/T1059/](https://attack.mitre.org/techniques/T1059/)](https://attack.mitre.org/techniques/T1059/)
- Sub Technique:
  - Name: PowerShell
- Id: T1059.001
- Reference URL: [[https://attack.mitre.org/techniques/T1059/001/](https://attack.mitre.org/techniques/T1059/001/)](https://attack.mitre.org/techniques/T1059/001/)

**Framework:** MITRE ATT&CK
- Tactic:
  - Name: Defense Evasion
- Id: TA0005
- Reference URL: [[https://attack.mitre.org/tactics/TA0005/](https://attack.mitre.org/tactics/TA0005/)](https://attack.mitre.org/tactics/TA0005/)
- Technique:
  - Name: Direct Volume Access
- Id: T1006
- Reference URL: [[https://attack.mitre.org/techniques/T1006/](https://attack.mitre.org/techniques/T1006/)](https://attack.mitre.org/techniques/T1006/)