﻿---
title: Mimikatz Memssp Log File Detected
description: Identifies the password log file from the default Mimikatz memssp module. Rule type: eql Rule indices: winlogbeat-*, logs-endpoint.events.file-*, logs-windows.sysmon_operational-*,...
url: https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/windows/credential_access_mimikatz_memssp_default_logs
products:
  - Elastic Security
---

# Mimikatz Memssp Log File Detected
Identifies the password log file from the default Mimikatz memssp module.
**Rule type**: eql
**Rule indices**:
- winlogbeat-*
- logs-endpoint.events.file-*
- logs-windows.sysmon_operational-*
- endgame-*
- logs-sentinel_one_cloud_funnel.*
- logs-m365_defender.event-*
- logs-crowdstrike.fdr*

**Rule Severity**: high
**Risk Score**: 73
**Runs every**: 
**Searches indices from**: `now-9m`
**Maximum alerts per execution**: 100
**References**:
- [[https://www.elastic.co/security-labs/detect-credential-access](https://www.elastic.co/security-labs/detect-credential-access)](https://www.elastic.co/security-labs/detect-credential-access)

**Tags**:
- Domain: Endpoint
- OS: Windows
- Use Case: Threat Detection
- Tactic: Credential Access
- Resources: Investigation Guide
- Data Source: Elastic Endgame
- Data Source: Elastic Defend
- Data Source: Sysmon
- Data Source: SentinelOne
- Data Source: Microsoft Defender for Endpoint
- Data Source: Crowdstrike

**Version**: 415
**Rule authors**:
- Elastic

**Rule license**: Elastic License v2

## Setup

If enabling an EQL rule on a non-elastic-agent index (such as beats) for versions <8.2,
events will not define `event.ingested` and default fallback for EQL rules was not added until version 8.2.
Hence for this rule to work effectively, users will need to add a custom ingest pipeline to populate
`event.ingested` to @timestamp.
For more details on adding a custom ingest pipeline refer - [https://www.elastic.co/guide/en/fleet/current/data-streams-pipeline-tutorial.html](https://www.elastic.co/guide/en/fleet/current/data-streams-pipeline-tutorial.html)

## Investigation guide


## Triage and analysis


### Investigating Mimikatz Memssp Log File Detected

[Mimikatz](https://github.com/gentilkiwi/mimikatz) is an open-source tool used to collect, decrypt, and/or use cached credentials. This tool is commonly abused by adversaries during the post-compromise stage where adversaries have gained an initial foothold on an endpoint and are looking to elevate privileges and seek out additional authentication objects such as tokens/hashes/credentials that can then be used to laterally move and pivot across a network.
This rule looks for the creation of a file named `mimilsa.log`, which is generated when using the Mimikatz misc::memssp module, which injects a malicious Windows SSP to collect locally authenticated credentials, which includes the computer account password, running service credentials, and any accounts that logon.

#### Possible investigation steps

- Investigate the script execution chain (parent process tree) for unknown processes. Examine their executable files for prevalence, whether they are located in expected locations, and if they are signed with valid digital signatures.
- Investigate other alerts associated with the user/host during the past 48 hours.
- Investigate potentially compromised accounts. Analysts can do this by searching for login events (e.g., 4624) to the target host.
- Retrieve and inspect the log file contents.
- Search for DLL files created in the same location as the log file, and retrieve unsigned DLLs.
  - Use the PowerShell Get-FileHash cmdlet to get the SHA-256 hash value of these files.
  - Search for the existence of these files in resources like VirusTotal, Hybrid-Analysis, CISCO Talos, Any.run, etc.
- Identify the process that created the DLL using file creation events.


### False positive analysis

- This file name `mimilsa.log` should not legitimately be created.


### Related rules

- Mimikatz Powershell Module Activity - ac96ceb8-4399-4191-af1d-4feeac1f1f46


### Response and remediation

- Initiate the incident response process based on the outcome of the triage.
- Isolate the involved hosts to prevent further post-compromise behavior.
- If the host is a Domain Controller (DC):
  - Activate your incident response plan for total Active Directory compromise.
- Review the privileges assigned to users that can access the DCs to ensure that the least privilege principle is being followed and reduce the attack surface.
- Investigate credential exposure on systems compromised or used by the attacker to ensure all compromised accounts are identified. Reset passwords for these accounts and other potentially compromised credentials, such as email, business systems, and web services.
- Reboot the host to remove the injected SSP from memory.
- Reimage the host operating system or restore compromised files to clean versions.
- Run a full antimalware scan. This may reveal additional artifacts left in the system, persistence mechanisms, and malware components.
- Determine the initial vector abused by the attacker and take action to prevent reinfection through the same vector.
- Using the incident response data, update logging and audit policies to improve the mean time to detect (MTTD) and the mean time to respond (MTTR).


## Rule Query

```eql
file where host.os.type == "windows" and file.name : "mimilsa.log" and process.name : "lsass.exe"
```

**Framework:** MITRE ATT&CK
- Tactic:
  - Name: Credential Access
- Id: TA0006
- Reference URL: [[https://attack.mitre.org/tactics/TA0006/](https://attack.mitre.org/tactics/TA0006/)](https://attack.mitre.org/tactics/TA0006/)
- Technique:
  - Name: OS Credential Dumping
- Id: T1003
- Reference URL: [[https://attack.mitre.org/techniques/T1003/](https://attack.mitre.org/techniques/T1003/)](https://attack.mitre.org/techniques/T1003/)