﻿---
title: Potential Machine Account Relay Attack via SMB
description: Identifies potential relay attacks against a machine account by identifying network share access events coming from a remote source.ip but using the target...
url: https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/windows/credential_access_machine_account_smb_relay
products:
  - Elastic Security
---

# Potential Machine Account Relay Attack via SMB
Identifies potential relay attacks against a machine account by identifying network share access events coming from a
remote source.ip but using the target server computer account. This may indicate a successful SMB relay attack.
**Rule type**: eql
**Rule indices**:
- logs-system.security*
- logs-windows.forwarded*
- winlogbeat-*

**Rule Severity**: high
**Risk Score**: 73
**Runs every**: 
**Searches indices from**: `now-9m`
**Maximum alerts per execution**: 100
**References**:
- [[https://github.com/p0dalirius/windows-coerced-authentication-methods](https://github.com/p0dalirius/windows-coerced-authentication-methods)](https://github.com/p0dalirius/windows-coerced-authentication-methods)
- [[https://www.thehacker.recipes/a-d/movement/mitm-and-coerced-authentications](https://www.thehacker.recipes/a-d/movement/mitm-and-coerced-authentications)](https://www.thehacker.recipes/a-d/movement/mitm-and-coerced-authentications)
- [[https://attack.mitre.org/techniques/T1187/](https://attack.mitre.org/techniques/T1187/)](https://attack.mitre.org/techniques/T1187/)

**Tags**:
- Domain: Endpoint
- OS: Windows
- Use Case: Threat Detection
- Tactic: Credential Access
- Data Source: Elastic Defend
- Data Source: Active Directory
- Use Case: Active Directory Monitoring
- Data Source: Windows Security Event Logs
- Resources: Investigation Guide

**Version**: 2
**Rule authors**:
- Elastic

**Rule license**: Elastic License v2

## Investigation guide


## Triage and analysis


### Investigating Potential Machine Account Relay Attack via SMB


### Possible investigation steps

- Compare the source.ip to the target server host.ip addresses to make sure it's indeed a remote use of the machine account.
- Examine the source.ip activities as this is the attacker IP address used to relay.
- Review all relevant activities such as services creation, file and process events on the target server within the same period.
- Verify the machine account names that end with a dollar sign ($) to ensure they match the expected hostnames, and investigate any discrepancies.
- Check the network logon types to confirm if they align with typical usage patterns for the identified machine accounts.
- Investigate the context of the source IP addresses that do not match the host IP, looking for any signs of unauthorized access or unusual network activity.
- Correlate the findings with other security logs and alerts to identify any patterns or additional indicators of compromise related to the potential relay attack.


### False positive analysis

- Machine accounts performing legitimate network logons from different IP addresses can trigger false positives. To manage this, identify and whitelist known IP addresses associated with legitimate administrative tasks or automated processes.
- Scheduled tasks or automated scripts that use machine accounts for network operations may be flagged. Review and document these tasks, then create exceptions for their associated IP addresses and hostnames.
- Load balancers or proxy servers that alter the source IP address of legitimate authentication requests can cause false alerts. Ensure these devices are accounted for in the network architecture and exclude their IP addresses from the rule.
- Temporary network reconfigurations or migrations might result in machine accounts appearing to log in from unexpected hosts. During such events, temporarily adjust the rule parameters or disable the rule to prevent unnecessary alerts.
- Regularly review and update the list of exceptions to ensure they reflect current network configurations and operational practices, minimizing the risk of overlooking genuine threats.


### Response and remediation

- Coordinate isolation of the affected domain controller with infrastructure and identity teams to contain the threat while preserving service availability and forensic evidence. Prioritize this step if active compromise or attacker persistence is confirmed.
- Reset the domain controller's machine account password, along with any accounts suspected to be compromised or exposed. Ensure strong, unique credentials are used and apply tiered credential hygiene where applicable.
- Analyze recent authentication logs, event logs, and network traffic, focusing on suspicious activity and the source IPs referenced in the alert. Correlate findings to identify any lateral movement or additional compromised systems.
- Strengthen network segmentation, especially between domain controllers, administrative workstations, and critical infrastructure. This limits the attack surface and impedes credential relay or reuse across systems.
- Escalate the incident to the SOC or incident response team to coordinate a full investigation, containment, and recovery plan. Ensure stakeholders are kept informed throughout the response.
- Enhance detection mechanisms by tuning alerts and deploying additional telemetry focused on credential relay patterns, anomalous authentication, and NTLM-related activity.
- Conduct a structured post-incident review, documenting findings, identifying control gaps, and updating playbooks, configurations, or security policies to reduce the likelihood of similar incidents in the future.


## Rule Query

```eql
file where host.os.type == "windows" and event.code == "5145" and endswith(user.name, "$") and

 /* compare computername with user.name and make sure they match */
 startswith~(winlog.computer_name, substring(user.name, 0, -1)) and

 /* exclude local access */
 not endswith(string(source.ip), string(host.ip)) and
 source.ip != "::" and source.ip != null and source.ip != "::1" and source.ip != "127.0.0.1"
```

**Framework:** MITRE ATT&CK
- Tactic:
  - Name: Credential Access
- Id: TA0006
- Reference URL: [[https://attack.mitre.org/tactics/TA0006/](https://attack.mitre.org/tactics/TA0006/)](https://attack.mitre.org/tactics/TA0006/)
- Technique:
  - Name: Forced Authentication
- Id: T1187
- Reference URL: [[https://attack.mitre.org/techniques/T1187/](https://attack.mitre.org/techniques/T1187/)](https://attack.mitre.org/techniques/T1187/)
- Technique:
  - Name: Adversary-in-the-Middle
- Id: T1557
- Reference URL: [[https://attack.mitre.org/techniques/T1557/](https://attack.mitre.org/techniques/T1557/)](https://attack.mitre.org/techniques/T1557/)
- Sub Technique:
  - Name: LLMNR/NBT-NS Poisoning and SMB Relay
- Id: T1557.001
- Reference URL: [[https://attack.mitre.org/techniques/T1557/001/](https://attack.mitre.org/techniques/T1557/001/)](https://attack.mitre.org/techniques/T1557/001/)