﻿---
title: Suspicious Module Loaded by LSASS
description: Identifies LSASS loading an unsigned or untrusted DLL. Windows Security Support Provider (SSP) DLLs are loaded into LSSAS process at system start. Once...
url: https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/windows/credential_access_lsass_loaded_susp_dll
products:
  - Elastic Security
---

# Suspicious Module Loaded by LSASS
Identifies LSASS loading an unsigned or untrusted DLL. Windows Security Support Provider (SSP) DLLs are loaded into
LSSAS process at system start. Once loaded into the LSA, SSP DLLs have access to encrypted and plaintext passwords that
are stored in Windows, such as any logged-on user's Domain password or smart card PINs.
**Rule type**: eql
**Rule indices**:
- logs-endpoint.events.library-*
- endgame-*

**Rule Severity**: medium
**Risk Score**: 47
**Runs every**: 
**Searches indices from**: `now-9m`
**Maximum alerts per execution**: 100
**References**:
- [[https://blog.xpnsec.com/exploring-mimikatz-part-2/](https://blog.xpnsec.com/exploring-mimikatz-part-2/)](https://blog.xpnsec.com/exploring-mimikatz-part-2/)
- [[https://github.com/jas502n/mimikat_ssp](https://github.com/jas502n/mimikat_ssp)](https://github.com/jas502n/mimikat_ssp)

**Tags**:
- Domain: Endpoint
- OS: Windows
- Use Case: Threat Detection
- Tactic: Credential Access
- Data Source: Elastic Defend
- Data Source: Elastic Endgame
- Resources: Investigation Guide

**Version**: 12
**Rule authors**:
- Elastic

**Rule license**: Elastic License v2

## Investigation guide


## Triage and analysis> **Disclaimer**:
This investigation guide was created using generative AI technology and has been reviewed to improve its accuracy and relevance. While every effort has been made to ensure its quality, we recommend validating the content and adapting it to suit your specific environment and operational needs.

### Investigating Suspicious Module Loaded by LSASS

The Local Security Authority Subsystem Service (LSASS) is crucial for managing security policies and handling user authentication in Windows environments. Adversaries exploit LSASS by loading malicious or untrusted DLLs to access sensitive credentials. The detection rule identifies such threats by monitoring LSASS for unsigned or untrusted DLLs, excluding known safe signatures and hashes, thus flagging potential credential dumping activities.

### Possible investigation steps

- Review the process details for lsass.exe to confirm the presence of any unsigned or untrusted DLLs loaded into the process. Pay particular attention to the DLL's code signature status and hash values.
- Cross-reference the identified DLL's hash against known malicious hashes in threat intelligence databases to determine if it is associated with any known threats.
- Investigate the source and path of the suspicious DLL to understand how it was introduced into the system. This may involve checking recent file creation or modification events in the system directories.
- Analyze the system's event logs for any related activities or anomalies around the time the suspicious DLL was loaded, such as unusual user logins or privilege escalation attempts.
- Check for any recent changes in the system's security settings or policies that might have allowed the loading of untrusted DLLs into LSASS.
- If the DLL is confirmed to be malicious, isolate the affected system to prevent further credential access or lateral movement within the network.


### False positive analysis

- Legitimate software from trusted vendors not included in the exclusion list may trigger false positives. Users can update the exclusion list with additional trusted signatures or hashes from verified vendors to prevent these alerts.
- Custom or in-house developed DLLs used within the organization might be flagged as suspicious. Organizations should ensure these DLLs are signed with a trusted certificate and add their signatures to the exclusion list if necessary.
- Security software updates or patches from vendors not currently listed may cause false positives. Regularly review and update the exclusion list to include new trusted signatures from security software providers.
- Temporary or expired certificates for legitimate DLLs can result in false positives. Users should verify the legitimacy of these DLLs and update the exclusion list with their signatures if they are confirmed safe.
- DLLs from newly installed software that are not yet recognized as trusted may be flagged. Users should validate the software's source and add its signatures to the exclusion list if it is deemed secure.


### Response and remediation

- Isolate the affected system from the network to prevent further unauthorized access or data exfiltration.
- Terminate the LSASS process if it is confirmed to be running a malicious or untrusted DLL, ensuring that this action does not disrupt critical services.
- Conduct a thorough scan of the affected system using updated antivirus or endpoint detection and response (EDR) tools to identify and remove any malicious files or remnants.
- Review and reset credentials for any accounts that may have been compromised, focusing on those with elevated privileges.
- Implement application whitelisting to prevent unauthorized DLLs from being loaded into critical processes like LSASS in the future.
- Escalate the incident to the security operations center (SOC) or incident response team for further investigation and to determine if additional systems are affected.
- Update security monitoring tools to enhance detection capabilities for similar threats, ensuring that alerts are generated for any future attempts to load untrusted DLLs into LSASS.


## Rule Query

```eql
any where event.category in ("library", "driver") and host.os.type == "windows" and
  process.executable : "?:\\Windows\\System32\\lsass.exe" and
  not (dll.code_signature.subject_name :
               ("Microsoft Windows",
                "Microsoft Corporation",
                "Microsoft Windows Publisher",
                "Microsoft Windows Software Compatibility Publisher",
                "Microsoft Windows Hardware Compatibility Publisher",
                "McAfee, Inc.",
                "SecMaker AB",
                "HID Global Corporation",
                "HID Global",
                "Apple Inc.",
                "Citrix Systems, Inc.",
                "Dell Inc",
                "Hewlett-Packard Company",
                "Symantec Corporation",
                "National Instruments Corporation",
                "DigitalPersona, Inc.",
                "Novell, Inc.",
                "gemalto",
                "EasyAntiCheat Oy",
                "Entrust Datacard Corporation",
                "AuriStor, Inc.",
                "LogMeIn, Inc.",
                "VMware, Inc.",
                "Istituto Poligrafico e Zecca dello Stato S.p.A.",
                "Nubeva Technologies Ltd",
                "Micro Focus (US), Inc.",
                "Yubico AB",
                "GEMALTO SA",
                "Secure Endpoints, Inc.",
                "Sophos Ltd",
                "Morphisec Information Security 2014 Ltd",
                "Entrust, Inc.",
                "Nubeva Technologies Ltd",
                "Micro Focus (US), Inc.",
                "F5 Networks Inc",
                "Bit4id",
                "Thales DIS CPL USA, Inc.",
                "Micro Focus International plc",
                "HYPR Corp",
                "Intel(R) Software Development Products",
                "PGP Corporation",
                "Parallels International GmbH",
                "FrontRange Solutions Deutschland GmbH",
                "SecureLink, Inc.",
                "Tidexa OU",
                "Amazon Web Services, Inc.",
                "SentryBay Limited",
                "Audinate Pty Ltd",
                "CyberArk Software Ltd.",
                "McAfeeSysPrep",
                "NVIDIA Corporation PE Sign v2016",
                "Trend Micro, Inc.",
                "Fortinet Technologies (Canada) Inc.",
                "Carbon Black, Inc.") and
       dll.code_signature.status : ("trusted", "errorExpired", "errorCode_endpoint*", "errorChaining")) and

     not dll.hash.sha256 :
                ("811a03a5d7c03802676d2613d741be690b3461022ea925eb6b2651a5be740a4c",
                 "1181542d9cfd63fb00c76242567446513e6773ea37db6211545629ba2ecf26a1",
                 "ed6e735aa6233ed262f50f67585949712f1622751035db256811b4088c214ce3",
                 "26be2e4383728eebe191c0ab19706188f0e9592add2e0bf86b37442083ae5e12",
                 "9367e78b84ef30cf38ab27776605f2645e52e3f6e93369c674972b668a444faa",
                 "d46cc934765c5ecd53867070f540e8d6f7701e834831c51c2b0552aba871921b",
                 "0f77a3826d7a5cd0533990be0269d951a88a5c277bc47cff94553330b715ec61",
                 "4aca034d3d85a9e9127b5d7a10882c2ef4c3e0daa3329ae2ac1d0797398695fb",
                 "86031e69914d9d33c34c2f4ac4ae523cef855254d411f88ac26684265c981d95")
```

**Framework:** MITRE ATT&CK
- Tactic:
  - Name: Credential Access
- Id: TA0006
- Reference URL: [[https://attack.mitre.org/tactics/TA0006/](https://attack.mitre.org/tactics/TA0006/)](https://attack.mitre.org/tactics/TA0006/)
- Technique:
  - Name: OS Credential Dumping
- Id: T1003
- Reference URL: [[https://attack.mitre.org/techniques/T1003/](https://attack.mitre.org/techniques/T1003/)](https://attack.mitre.org/techniques/T1003/)
- Sub Technique:
  - Name: LSASS Memory
- Id: T1003.001
- Reference URL: [[https://attack.mitre.org/techniques/T1003/001/](https://attack.mitre.org/techniques/T1003/001/)](https://attack.mitre.org/techniques/T1003/001/)