﻿---
title: Potential Kerberos SPN Spoofing via Suspicious DNS Query
description: Identifies queries to a DNS record containing a base64-encoded blob matching the pattern "UWhRCA...BAAAA". This pattern corresponds to a marshaled CREDENTIAL_TARGET_INFORMATION...
url: https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/windows/credential_access_kerberos_coerce_dns
products:
  - Elastic Security
---

# Potential Kerberos SPN Spoofing via Suspicious DNS Query
Identifies queries to a DNS record containing a base64-encoded blob matching the pattern "UWhRCA...BAAAA". This pattern
corresponds to a marshaled CREDENTIAL_TARGET_INFORMATION structure, commonly used in Kerberos coercion attacks. It is
associated with tools and techniques that exploit SPN spoofing via DNS. Adversaries may abuse this to coerce victim
systems into authenticating to attacker-controlled hosts while requesting Kerberos tickets for legitimate services
(often the victim's own identity), enabling attacks such as NTLM reflection.
**Rule type**: eql
**Rule indices**:
- endgame-*
- logs-crowdstrike.fdr*
- logs-endpoint.events.network-*
- logs-sentinel_one_cloud_funnel.*
- logs-windows.sysmon_operational-*

**Rule Severity**: high
**Risk Score**: 73
**Runs every**: 
**Searches indices from**: `now-9m`
**Maximum alerts per execution**: 100
**References**:
- [[https://www.synacktiv.com/publications/ntlm-reflection-is-dead-long-live-ntlm-reflection-an-in-depth-analysis-of-cve-2025](https://www.synacktiv.com/publications/ntlm-reflection-is-dead-long-live-ntlm-reflection-an-in-depth-analysis-of-cve-2025)](https://www.synacktiv.com/publications/ntlm-reflection-is-dead-long-live-ntlm-reflection-an-in-depth-analysis-of-cve-2025)
- [[https://blog.redteam-pentesting.de/2025/reflective-kerberos-relay-attack/](https://blog.redteam-pentesting.de/2025/reflective-kerberos-relay-attack/)](https://blog.redteam-pentesting.de/2025/reflective-kerberos-relay-attack/)
- [[https://googleprojectzero.blogspot.com/2021/10/using-kerberos-for-authentication-relay.html](https://googleprojectzero.blogspot.com/2021/10/using-kerberos-for-authentication-relay.html)](https://googleprojectzero.blogspot.com/2021/10/using-kerberos-for-authentication-relay.html)
- [[https://github.com/CICADA8-Research/RemoteKrbRelay/blob/main/README.md](https://github.com/CICADA8-Research/RemoteKrbRelay/blob/main/README.md)](https://github.com/CICADA8-Research/RemoteKrbRelay/blob/main/README.md)
- [[https://github.com/Orange-Cyberdefense/ocd-mindmaps/blob/main/excalimap/mindmap/ad/authenticated.md](https://github.com/Orange-Cyberdefense/ocd-mindmaps/blob/main/excalimap/mindmap/ad/authenticated.md)](https://github.com/Orange-Cyberdefense/ocd-mindmaps/blob/main/excalimap/mindmap/ad/authenticated.md)

**Tags**:
- Domain: Endpoint
- OS: Windows
- Use Case: Threat Detection
- Tactic: Credential Access
- Data Source: Elastic Defend
- Data Source: Elastic Endgame
- Data Source: Crowdstrike
- Data Source: SentinelOne
- Data Source: Sysmon
- Resources: Investigation Guide

**Version**: 1
**Rule authors**:
- Elastic

**Rule license**: Elastic License v2

## Investigation guide


## Triage and analysis


### Investigating Potential Kerberos SPN Spoofing via Suspicious DNS Query> **Note**:
This investigation guide uses the [Investigate Markdown Plugin](https://www.elastic.co/guide/en/security/current/interactive-investigation-guides.html) introduced in Elastic Stack version 8.8.0. Older Elastic Stack versions will display unrendered Markdown in this guide.

### Possible investigation steps

- Identify the system that issued the DNS query for the suspicious hostname. Determine whether it is a server or an end user device. This technique is typically only relevant against server systems, but queries originating from workstations may indicate compromise or misuse.
- Identify attacker-controlled system by getting the IP addresses (`dns.resolved_ip`) that this DNS query resolved to by looking for the related `lookup_result` events.
  - $investigate_0
- If this alert was triggered on a domain controller, escalate the investigation to involve the incident response team to determine the full scope of the breach as soon as possible.


### False positive analysis

- This activity is unlikely to happen legitimately.


### Response and remediation

- Review and remove malicious DNS records containing the embedded CREDENTIAL_TARGET_INFORMATION Base64 payload (UWhRCA...BAAAA). Ensure that no additional coercion records exist in the same DNS zone.
- Isolate involved systems if signs of compromise or lateral movement are detected, especially if the record was successfully resolved and used for coercion.
- Monitor network traffic for signs of Man-in-the-Middle activity, focusing on unusual DNS queries or redirections.
- Escalate the incident to the security operations center (SOC) for further investigation and to assess the potential impact on other systems.
- Investigate credential exposure on systems compromised or used by the attacker to ensure all compromised accounts are identified. Reset passwords for these accounts and other potentially compromised credentials, such as email, business systems, and web services.
- Determine the initial vector abused by the attacker and take action to prevent reinfection through the same vector.
- Using the incident response data, update logging and audit policies to improve the mean time to detect (MTTD) and the mean time to respond (MTTR).


## Rule Query

```eql
network where host.os.type == "windows" and dns.question.name : "*UWhRC*BAAAA*"
```

**Framework:** MITRE ATT&CK
- Tactic:
  - Name: Credential Access
- Id: TA0006
- Reference URL: [[https://attack.mitre.org/tactics/TA0006/](https://attack.mitre.org/tactics/TA0006/)](https://attack.mitre.org/tactics/TA0006/)
- Technique:
  - Name: Adversary-in-the-Middle
- Id: T1557
- Reference URL: [[https://attack.mitre.org/techniques/T1557/](https://attack.mitre.org/techniques/T1557/)](https://attack.mitre.org/techniques/T1557/)
- Sub Technique:
  - Name: LLMNR/NBT-NS Poisoning and SMB Relay
- Id: T1557.001
- Reference URL: [[https://attack.mitre.org/techniques/T1557/001/](https://attack.mitre.org/techniques/T1557/001/)](https://attack.mitre.org/techniques/T1557/001/)
- Technique:
  - Name: Forced Authentication
- Id: T1187
- Reference URL: [[https://attack.mitre.org/techniques/T1187/](https://attack.mitre.org/techniques/T1187/)](https://attack.mitre.org/techniques/T1187/)