﻿---
title: Potential Kerberos Coercion via DNS-Based SPN Spoofing
description: Identifies the creation of a DNS record containing a base64-encoded blob matching the pattern "UWhRCA...BAAAA". This pattern corresponds to a marshaled...
url: https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/windows/credential_access_kerberos_coerce
products:
  - Elastic Security
---

# Potential Kerberos Coercion via DNS-Based SPN Spoofing
Identifies the creation of a DNS record containing a base64-encoded blob matching the pattern "UWhRCA...BAAAA". This
pattern corresponds to a marshaled CREDENTIAL_TARGET_INFORMATION structure, commonly used in Kerberos coercion attacks.
It is associated with tools and techniques that exploit SPN spoofing via DNS. Adversaries may abuse this to coerce
victim systems into authenticating to attacker-controlled hosts while requesting Kerberos tickets for legitimate
services (often the victim's own identity). This enables reflective Kerberos relay attacks, potentially resulting in
privileged access such as NT AUTHORITY\SYSTEM, without relying on NTLM fallback.
**Rule type**: query
**Rule indices**:
- logs-system.security*
- logs-windows.forwarded*
- winlogbeat-*

**Rule Severity**: high
**Risk Score**: 73
**Runs every**: 
**Searches indices from**: `now-9m`
**Maximum alerts per execution**: 100
**References**:
- [[https://www.synacktiv.com/publications/ntlm-reflection-is-dead-long-live-ntlm-reflection-an-in-depth-analysis-of-cve-2025](https://www.synacktiv.com/publications/ntlm-reflection-is-dead-long-live-ntlm-reflection-an-in-depth-analysis-of-cve-2025)](https://www.synacktiv.com/publications/ntlm-reflection-is-dead-long-live-ntlm-reflection-an-in-depth-analysis-of-cve-2025)
- [[https://blog.redteam-pentesting.de/2025/reflective-kerberos-relay-attack/](https://blog.redteam-pentesting.de/2025/reflective-kerberos-relay-attack/)](https://blog.redteam-pentesting.de/2025/reflective-kerberos-relay-attack/)
- [[https://googleprojectzero.blogspot.com/2021/10/using-kerberos-for-authentication-relay.html](https://googleprojectzero.blogspot.com/2021/10/using-kerberos-for-authentication-relay.html)](https://googleprojectzero.blogspot.com/2021/10/using-kerberos-for-authentication-relay.html)
- [[https://github.com/CICADA8-Research/RemoteKrbRelay/blob/main/README.md](https://github.com/CICADA8-Research/RemoteKrbRelay/blob/main/README.md)](https://github.com/CICADA8-Research/RemoteKrbRelay/blob/main/README.md)
- [[https://github.com/Orange-Cyberdefense/ocd-mindmaps/blob/main/excalimap/mindmap/ad/authenticated.md](https://github.com/Orange-Cyberdefense/ocd-mindmaps/blob/main/excalimap/mindmap/ad/authenticated.md)](https://github.com/Orange-Cyberdefense/ocd-mindmaps/blob/main/excalimap/mindmap/ad/authenticated.md)

**Tags**:
- Domain: Endpoint
- OS: Windows
- Use Case: Threat Detection
- Tactic: Credential Access
- Data Source: Active Directory
- Use Case: Active Directory Monitoring
- Data Source: Windows Security Event Logs
- Resources: Investigation Guide

**Version**: 2
**Rule authors**:
- Elastic

**Rule license**: Elastic License v2

## Setup

The 'Audit Directory Service Changes' logging policy must be configured for (Success, Failure).
Steps to implement the logging policy with Advanced Audit Configuration:
```
Computer Configuration >
Policies >
Windows Settings >
Security Settings >
Advanced Audit Policies Configuration >
Audit Policies >
DS Access >
Audit Directory Service Changes (Success,Failure)
```

The above policy does not cover the target object by default (we still need it to be configured to generate events), so we need to set up an AuditRule using [https://github.com/OTRF/Set-AuditRule](https://github.com/OTRF/Set-AuditRule).
```
Set-AuditRule -AdObjectPath 'AD:\CN=MicrosoftDNS,DC=DomainDNSZones,DC=Domain,DC=com' -WellKnownSidType WorldSid -Rights CreateChild -InheritanceFlags Descendents -AttributeGUID e0fa1e8c-9b45-11d0-afdd-00c04fd930c9 -AuditFlags Success
```


## Investigation guide


## Triage and analysis> **Disclaimer**:
This investigation guide was created using generative AI technology and has been reviewed to improve its accuracy and relevance. While every effort has been made to ensure its quality, we recommend validating the content and adapting it to suit your specific environment and operational needs.

### Investigating Potential Kerberos Coercion via DNS-Based SPN Spoofing


### Possible investigation steps

- Review the event logs on the affected Windows host to confirm the presence of event code 5137, which indicates a directory service object modification.
- Inspect the ObjectDN field to identify the full distinguished name of the created DNS record. Look for entries containing Base64-encoded segments matching UWhRCA...BAAAA, which are indicative of an embedded CREDENTIAL_TARGET_INFORMATION payload used in SPN spoofing.
- Validate the associated user or computer account responsible for the DNS record creation. Investigate whether the account has legitimate administrative access to modify DNS zones or whether it may have been compromised.
- Correlate with DNS query logs and network telemetry to determine if the suspicious DNS hostname was later queried or resolved by other hosts on the network. A match suggests the attacker moved forward with the coercion attempt.
- Assess the permissions and access controls on the DNS zones to ensure they are appropriately configured and restrict unnecessary modifications by authenticated users.


### False positive analysis

- This activity is unlikely to happen legitimately.


### Response and remediation

- Review and remove the malicious DNS record containing the embedded CREDENTIAL_TARGET_INFORMATION Base64 payload (UWhRCA...BAAAA). Ensure that no additional coercion records exist in the same DNS zone.
- Identify the source of the DNS modification by correlating the event with user context and host activity. Investigate whether the account used was compromised or misused.
- Audit Kerberos ticket activity following the DNS record creation. Look for suspicious service ticket requests (Event ID 4769) or authentication attempts that could indicate a relay or privilege escalation attempt.
- Temporarily isolate involved systems if signs of compromise or lateral movement are detected, especially if the record was successfully resolved and used for coercion.
- Monitor network traffic for signs of Man-in-the-Middle activity, focusing on unusual DNS queries or redirections.
- Escalate the incident to the security operations center (SOC) for further investigation and to assess the potential impact on other systems.


## Rule Query

```kuery
host.os.type:"windows" and
(
  (event.code:4662 and winlog.event_data.AdditionalInfo: *UWhRC*BAAAA*MicrosoftDNS*) or 
  (event.code:5137 and winlog.event_data.ObjectDN: *UWhRC*BAAAA*MicrosoftDNS*)
)
```

**Framework:** MITRE ATT&CK
- Tactic:
  - Name: Credential Access
- Id: TA0006
- Reference URL: [[https://attack.mitre.org/tactics/TA0006/](https://attack.mitre.org/tactics/TA0006/)](https://attack.mitre.org/tactics/TA0006/)
- Technique:
  - Name: Adversary-in-the-Middle
- Id: T1557
- Reference URL: [[https://attack.mitre.org/techniques/T1557/](https://attack.mitre.org/techniques/T1557/)](https://attack.mitre.org/techniques/T1557/)
- Sub Technique:
  - Name: LLMNR/NBT-NS Poisoning and SMB Relay
- Id: T1557.001
- Reference URL: [[https://attack.mitre.org/techniques/T1557/001/](https://attack.mitre.org/techniques/T1557/001/)](https://attack.mitre.org/techniques/T1557/001/)
- Technique:
  - Name: Forced Authentication
- Id: T1187
- Reference URL: [[https://attack.mitre.org/techniques/T1187/](https://attack.mitre.org/techniques/T1187/)](https://attack.mitre.org/techniques/T1187/)