﻿---
title: Creation of a DNS-Named Record
description: Active Directory Integrated DNS (ADIDNS) is one of the core components of AD DS, leveraging AD's access control and replication to maintain domain consistency...
url: https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/windows/credential_access_dnsnode_creation
products:
  - Elastic Security
---

# Creation of a DNS-Named Record
Active Directory Integrated DNS (ADIDNS) is one of the core components of AD DS, leveraging AD's access control and
replication to maintain domain consistency. It stores DNS zones as AD objects, a feature that, while robust, introduces
some security issues because of the default permission (Any authenticated users) to create DNS-named records. Attackers
can perform Dynamic Spoofing attacks, where they monitor LLMNR/NBT-NS requests and create DNS-named records to target
systems that are requested from multiple systems. They can also create specific records to target specific services,
such as wpad, for spoofing attacks.
**Rule type**: eql
**Rule indices**:
- logs-system.security*
- logs-windows.forwarded*
- winlogbeat-*

**Rule Severity**: low
**Risk Score**: 21
**Runs every**: 
**Searches indices from**: `now-9m`
**Maximum alerts per execution**: 100
**References**:
- [[https://www.netspi.com/blog/technical/network-penetration-testing/adidns-revisited/](https://www.netspi.com/blog/technical/network-penetration-testing/adidns-revisited/)](https://www.netspi.com/blog/technical/network-penetration-testing/adidns-revisited/)
- [[https://www.thehacker.recipes/a-d/movement/mitm-and-coerced-authentications/wpad-spoofing](https://www.thehacker.recipes/a-d/movement/mitm-and-coerced-authentications/wpad-spoofing)](https://www.thehacker.recipes/a-d/movement/mitm-and-coerced-authentications/wpad-spoofing)

**Tags**:
- Domain: Endpoint
- OS: Windows
- Use Case: Threat Detection
- Tactic: Credential Access
- Data Source: Active Directory
- Use Case: Active Directory Monitoring
- Data Source: Windows Security Event Logs
- Resources: Investigation Guide

**Version**: 107
**Rule authors**:
- Elastic

**Rule license**: Elastic License v2

## Setup

The 'Audit Directory Service Changes' logging policy must be configured for (Success, Failure).
Steps to implement the logging policy with Advanced Audit Configuration:
```
Computer Configuration >
Policies >
Windows Settings >
Security Settings >
Advanced Audit Policies Configuration >
Audit Policies >
DS Access >
Audit Directory Service Changes (Success,Failure)
```

The above policy does not cover the target object by default (we still need it to be configured to generate events), so we need to set up an AuditRule using [https://github.com/OTRF/Set-AuditRule](https://github.com/OTRF/Set-AuditRule).
```
Set-AuditRule -AdObjectPath 'AD:\CN=MicrosoftDNS,DC=DomainDNSZones,DC=Domain,DC=com' -WellKnownSidType WorldSid -Rights CreateChild -InheritanceFlags Descendents -AttributeGUID e0fa1e8c-9b45-11d0-afdd-00c04fd930c9 -AuditFlags Success
```


## Investigation guide


## Triage and analysis> **Disclaimer**:
This investigation guide was created using generative AI technology and has been reviewed to improve its accuracy and relevance. While every effort has been made to ensure its quality, we recommend validating the content and adapting it to suit your specific environment and operational needs.

### Investigating Creation of a DNS-Named Record

Active Directory Integrated DNS (ADIDNS) is crucial for maintaining domain consistency by storing DNS zones as AD objects. However, its default permissions can be exploited by attackers to create DNS records for spoofing attacks, targeting services like WPAD. The detection rule identifies such abuse by monitoring specific Windows events related to DNS record creation, filtering out legitimate system accounts to highlight potential threats.

### Possible investigation steps

- Review the event logs for event code 5137 to identify the specific DNS-named record that was created and the associated timestamp.
- Examine the winlog.event_data.SubjectUserName field to determine the user account that initiated the DNS record creation, ensuring it is not a system account.
- Investigate the context around the winlog.event_data.ObjectClass field to confirm the object class is "dnsNode" and assess if the DNS record creation aligns with expected administrative activities.
- Check for any recent LLMNR/NBT-NS requests or network traffic that might indicate an attempt to exploit the newly created DNS record for spoofing purposes.
- Correlate the alert with other security events or logs to identify any patterns or anomalies that might suggest malicious intent or unauthorized access attempts.
- Assess the risk and impact of the DNS record creation by determining if it targets critical services like WPAD or other sensitive systems within the network.


### False positive analysis

- Legitimate administrative actions may trigger the rule when DNS records are created or modified by IT staff. To manage this, create exceptions for known administrative accounts that regularly perform these tasks.
- Automated system processes or scripts that update DNS records can also cause false positives. Identify these processes and exclude their associated accounts from the rule to prevent unnecessary alerts.
- Service accounts used by legitimate applications to dynamically update DNS records might be flagged. Review these accounts and add them to an exception list if they are verified as non-threatening.
- Temporary network changes or testing environments where DNS records are frequently modified can lead to false positives. Consider excluding these environments or specific IP ranges from the rule to reduce noise.
- Regularly review and update the exception list to ensure it reflects current network and administrative practices, minimizing the risk of overlooking genuine threats.


### Response and remediation

- Immediately isolate the affected system from the network to prevent further malicious DNS record creation and potential spoofing attacks.
- Review and remove any unauthorized DNS records created by non-system accounts, focusing on those targeting services like WPAD.
- Reset credentials for any accounts that were potentially compromised or used in the attack to prevent further unauthorized access.
- Implement stricter access controls on DNS record creation within Active Directory to limit permissions to only necessary and trusted accounts.
- Monitor for any further suspicious DNS record creation events, particularly those involving non-system accounts, to detect and respond to potential follow-up attacks.
- Escalate the incident to the security operations center (SOC) or incident response team for further investigation and to determine if additional systems or services were affected.
- Conduct a post-incident review to identify gaps in detection and response, and update security policies and procedures to prevent similar incidents in the future.


## Rule Query

```eql
any where host.os.type == "windows" and event.code == "5137" and winlog.event_data.ObjectClass == "dnsNode" and
    not winlog.event_data.SubjectUserName : "*$"
```

**Framework:** MITRE ATT&CK
- Tactic:
  - Name: Credential Access
- Id: TA0006
- Reference URL: [[https://attack.mitre.org/tactics/TA0006/](https://attack.mitre.org/tactics/TA0006/)](https://attack.mitre.org/tactics/TA0006/)
- Technique:
  - Name: Adversary-in-the-Middle
- Id: T1557
- Reference URL: [[https://attack.mitre.org/techniques/T1557/](https://attack.mitre.org/techniques/T1557/)](https://attack.mitre.org/techniques/T1557/)