﻿---
title: Kerberos Pre-authentication Disabled for User
description: Identifies the modification of an account's Kerberos pre-authentication options. An adversary with GenericWrite/GenericAll rights over the account can...
url: https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/windows/credential_access_disable_kerberos_preauth
products:
  - Elastic Security
---

# Kerberos Pre-authentication Disabled for User
Identifies the modification of an account's Kerberos pre-authentication options. An adversary with
GenericWrite/GenericAll rights over the account can maliciously modify these settings to perform offline password
cracking attacks such as AS-REP roasting.
**Rule type**: eql
**Rule indices**:
- logs-system.security*
- logs-windows.forwarded*
- winlogbeat-*

**Rule Severity**: medium
**Risk Score**: 47
**Runs every**: 
**Searches indices from**: `now-9m`
**Maximum alerts per execution**: 100
**References**:
- [[https://harmj0y.medium.com/roasting-as-reps-e6179a65216b](https://harmj0y.medium.com/roasting-as-reps-e6179a65216b)](https://harmj0y.medium.com/roasting-as-reps-e6179a65216b)
- [[https://docs.microsoft.com/en-us/windows/security/threat-protection/auditing/event-4738](https://docs.microsoft.com/en-us/windows/security/threat-protection/auditing/event-4738)](https://docs.microsoft.com/en-us/windows/security/threat-protection/auditing/event-4738)
- [[https://github.com/atc-project/atomic-threat-coverage/blob/master/Atomic_Threat_Coverage/Logging_Policies/LP_0026_windows_audit_user_account_management.md](https://github.com/atc-project/atomic-threat-coverage/blob/master/Atomic_Threat_Coverage/Logging_Policies/LP_0026_windows_audit_user_account_management.md)](https://github.com/atc-project/atomic-threat-coverage/blob/master/Atomic_Threat_Coverage/Logging_Policies/LP_0026_windows_audit_user_account_management.md)

**Tags**:
- Domain: Endpoint
- OS: Windows
- Use Case: Threat Detection
- Tactic: Credential Access
- Tactic: Defense Evasion
- Tactic: Privilege Escalation
- Resources: Investigation Guide
- Use Case: Active Directory Monitoring
- Data Source: Active Directory
- Data Source: Windows Security Event Logs

**Version**: 217
**Rule authors**:
- Elastic

**Rule license**: Elastic License v2

## Setup

The 'Audit User Account Management' logging policy must be configured for (Success, Failure).
Steps to implement the logging policy with Advanced Audit Configuration:
```
Computer Configuration >
Policies >
Windows Settings >
Security Settings >
Advanced Audit Policies Configuration >
Audit Policies >
Account Management >
Audit User Account Management (Success,Failure)
```


## Investigation guide


## Triage and analysis


### Investigating Kerberos Pre-authentication Disabled for User

Kerberos pre-authentication is an account protection against offline password cracking. When enabled, a user requesting access to a resource initiates communication with the Domain Controller (DC) by sending an Authentication Server Request (AS-REQ) message with a timestamp that is encrypted with the hash of their password. If and only if the DC is able to successfully decrypt the timestamp with the hash of the user’s password, it will then send an Authentication Server Response (AS-REP) message that contains the Ticket Granting Ticket (TGT) to the user. Part of the AS-REP message is signed with the user’s password. Microsoft's security monitoring [recommendations](https://docs.microsoft.com/en-us/windows/security/threat-protection/auditing/event-4738) state that `'Don't Require Preauth' – Enabled` should not be enabled for user accounts because it weakens security for the account’s Kerberos authentication.
AS-REP roasting is an attack against Kerberos for user accounts that do not require pre-authentication, which means that if the target user has pre-authentication disabled, an attacker can request authentication data for it and get a TGT that can be brute-forced offline, similarly to Kerberoasting.

#### Possible investigation steps

- Identify the user account that performed the action and whether it should perform this kind of action.
- Contact the account owner and confirm whether they are aware of this activity.
- Determine if the target account is sensitive or privileged.
- Inspect the account activities for suspicious or abnormal behaviors in the alert timeframe.


### False positive analysis

- Disabling pre-authentication is a bad security practice and should not be allowed in the domain. The security team should map and monitor any potential benign true positives (B-TPs), especially if the target account is privileged.


### Response and remediation

- Initiate the incident response process based on the outcome of the triage.
- Reset the target account's password if there is any risk of TGTs having been retrieved.
- Re-enable the preauthentication option or disable the target account.
- Review the privileges assigned to the involved users to ensure that the least privilege principle is being followed.
- Investigate credential exposure on systems compromised or used by the attacker to ensure all compromised accounts are identified. Reset passwords for these accounts and other potentially compromised credentials, such as email, business systems, and web services.
- Using the incident response data, update logging and audit policies to improve the mean time to detect (MTTD) and the mean time to respond (MTTR).


## Rule Query

```eql
any where host.os.type == "windows" and event.code == "4738" and
  winlog.event_data.NewUACList == "USER_DONT_REQUIRE_PREAUTH"
```

**Framework:** MITRE ATT&CK
- Tactic:
  - Name: Credential Access
- Id: TA0006
- Reference URL: [[https://attack.mitre.org/tactics/TA0006/](https://attack.mitre.org/tactics/TA0006/)](https://attack.mitre.org/tactics/TA0006/)
- Technique:
  - Name: Steal or Forge Kerberos Tickets
- Id: T1558
- Reference URL: [[https://attack.mitre.org/techniques/T1558/](https://attack.mitre.org/techniques/T1558/)](https://attack.mitre.org/techniques/T1558/)
- Sub Technique:
  - Name: AS-REP Roasting
- Id: T1558.004
- Reference URL: [[https://attack.mitre.org/techniques/T1558/004/](https://attack.mitre.org/techniques/T1558/004/)](https://attack.mitre.org/techniques/T1558/004/)

**Framework:** MITRE ATT&CK
- Tactic:
  - Name: Defense Evasion
- Id: TA0005
- Reference URL: [[https://attack.mitre.org/tactics/TA0005/](https://attack.mitre.org/tactics/TA0005/)](https://attack.mitre.org/tactics/TA0005/)
- Technique:
  - Name: Impair Defenses
- Id: T1562
- Reference URL: [[https://attack.mitre.org/techniques/T1562/](https://attack.mitre.org/techniques/T1562/)](https://attack.mitre.org/techniques/T1562/)

**Framework:** MITRE ATT&CK
- Tactic:
  - Name: Privilege Escalation
- Id: TA0004
- Reference URL: [[https://attack.mitre.org/tactics/TA0004/](https://attack.mitre.org/tactics/TA0004/)](https://attack.mitre.org/tactics/TA0004/)
- Technique:
  - Name: Valid Accounts
- Id: T1078
- Reference URL: [[https://attack.mitre.org/techniques/T1078/](https://attack.mitre.org/techniques/T1078/)](https://attack.mitre.org/techniques/T1078/)
- Sub Technique:
  - Name: Domain Accounts
- Id: T1078.002
- Reference URL: [[https://attack.mitre.org/techniques/T1078/002/](https://attack.mitre.org/techniques/T1078/002/)](https://attack.mitre.org/techniques/T1078/002/)