﻿---
title: Potential Credential Access via DCSync
description: This rule identifies when a User Account starts the Active Directory Replication Process. Attackers can use the DCSync technique to get credential information...
url: https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/windows/credential_access_dcsync_replication_rights
products:
  - Elastic Security
---

# Potential Credential Access via DCSync
This rule identifies when a User Account starts the Active Directory Replication Process. Attackers can use the DCSync
technique to get credential information of individual accounts or the entire domain, thus compromising the entire
domain.
**Rule type**: new_terms
**Rule indices**:
- logs-system.security*
- logs-windows.forwarded*
- winlogbeat-*

**Rule Severity**: medium
**Risk Score**: 47
**Runs every**: 
**Searches indices from**: `now-9m`
**Maximum alerts per execution**: 100
**References**:
- [[https://threathunterplaybook.com/notebooks/windows/06_credential_access/WIN-180815210510.html](https://threathunterplaybook.com/notebooks/windows/06_credential_access/WIN-180815210510.html)](https://threathunterplaybook.com/notebooks/windows/06_credential_access/WIN-180815210510.html)
- [[https://threathunterplaybook.com/library/windows/active_directory_replication.html?highlight=dcsync#directory-replication-services-auditing](https://threathunterplaybook.com/library/windows/active_directory_replication.html?highlight=dcsync#directory-replication-services-auditing)](https://threathunterplaybook.com/library/windows/active_directory_replication.html?highlight=dcsync#directory-replication-services-auditing)
- [[https://github.com/SigmaHQ/sigma/blob/master/rules/windows/builtin/security/win_ad_replication_non_machine_account.yml](https://github.com/SigmaHQ/sigma/blob/master/rules/windows/builtin/security/win_ad_replication_non_machine_account.yml)](https://github.com/SigmaHQ/sigma/blob/master/rules/windows/builtin/security/win_ad_replication_non_machine_account.yml)
- [[https://github.com/atc-project/atomic-threat-coverage/blob/master/Atomic_Threat_Coverage/Logging_Policies/LP_0027_windows_audit_directory_service_access.md](https://github.com/atc-project/atomic-threat-coverage/blob/master/Atomic_Threat_Coverage/Logging_Policies/LP_0027_windows_audit_directory_service_access.md)](https://github.com/atc-project/atomic-threat-coverage/blob/master/Atomic_Threat_Coverage/Logging_Policies/LP_0027_windows_audit_directory_service_access.md)
- [[https://attack.stealthbits.com/privilege-escalation-using-mimikatz-dcsync](https://attack.stealthbits.com/privilege-escalation-using-mimikatz-dcsync)](https://attack.stealthbits.com/privilege-escalation-using-mimikatz-dcsync)
- [[https://www.thehacker.recipes/ad/movement/credentials/dumping/dcsync](https://www.thehacker.recipes/ad/movement/credentials/dumping/dcsync)](https://www.thehacker.recipes/ad/movement/credentials/dumping/dcsync)
- [[https://www.elastic.co/security-labs/siestagraph-new-implant-uncovered-in-asean-member-foreign-ministry](https://www.elastic.co/security-labs/siestagraph-new-implant-uncovered-in-asean-member-foreign-ministry)](https://www.elastic.co/security-labs/siestagraph-new-implant-uncovered-in-asean-member-foreign-ministry)

**Tags**:
- Domain: Endpoint
- OS: Windows
- Use Case: Threat Detection
- Tactic: Credential Access
- Tactic: Privilege Escalation
- Data Source: Active Directory
- Resources: Investigation Guide
- Use Case: Active Directory Monitoring
- Data Source: Windows Security Event Logs

**Version**: 220
**Rule authors**:
- Elastic

**Rule license**: Elastic License v2

## Setup

The 'Audit Directory Service Access' logging policy must be configured for (Success, Failure).
Steps to implement the logging policy with Advanced Audit Configuration:
```
Computer Configuration >
Policies >
Windows Settings >
Security Settings >
Advanced Audit Policies Configuration >
Audit Policies >
DS Access >
Audit Directory Service Access (Success,Failure)
```


## Investigation guide


## Triage and analysis


### Investigating Potential Credential Access via DCSync

Active Directory replication is the process by which the changes that originate on one domain controller are automatically transferred to other domain controllers that store the same data.
Active Directory data consists of objects that have properties, or attributes. Each object is an instance of an object class, and object classes and their respective attributes are defined in the Active Directory schema. Objects are defined by the values of their attributes, and changes to attribute values must be transferred from the domain controller on which they occur to every other domain controller that stores a replica of an affected object.
Adversaries can use the DCSync technique that uses Windows Domain Controller's API to simulate the replication process from a remote domain controller, compromising major credential material such as the Kerberos krbtgt keys used legitimately for tickets creation, but also tickets forging by attackers. This attack requires some extended privileges to succeed (DS-Replication-Get-Changes and DS-Replication-Get-Changes-All), which are granted by default to members of the Administrators, Domain Admins, Enterprise Admins, and Domain Controllers groups. Privileged accounts can be abused to grant controlled objects the right to DCsync/Replicate.
More details can be found on [Threat Hunter Playbook](https://threathunterplaybook.com/library/windows/active_directory_replication.html?highlight=dcsync#directory-replication-services-auditing) and [The Hacker Recipes](https://www.thehacker.recipes/ad/movement/credentials/dumping/dcsync).
This rule monitors for Event ID 4662 (Operation was performed on an Active Directory object) and identifies events that use the access mask 0x100 (Control Access) and properties that contain at least one of the following or their equivalent Schema-Id-GUID (DS-Replication-Get-Changes, DS-Replication-Get-Changes-All, DS-Replication-Get-Changes-In-Filtered-Set). It also filters out events that use computer accounts and also Azure AD Connect MSOL accounts (more details [here](https://techcommunity.microsoft.com/t5/microsoft-defender-for-identity/ad-connect-msol-user-suspected-dcsync-attack/m-p/788028)).

#### Possible investigation steps

- Identify the user account that performed the action and whether it should perform this kind of action.
- Contact the account and system owners and confirm whether they are aware of this activity.
- Investigate other alerts associated with the user/host during the past 48 hours.
- Correlate security events 4662 and 4624 (Logon Type 3) by their Logon ID (`winlog.logon.id`) on the Domain Controller (DC) that received the replication request. This will tell you where the AD replication request came from, and if it came from another DC or not.
- Scope which credentials were compromised (for example, whether all accounts were replicated or specific ones).


### False positive analysis

- Administrators may use custom accounts on Azure AD Connect, investigate if it is the case, and if it is properly secured. If noisy in your environment due to expected activity, consider adding the corresponding account as a exception.
- Although replicating Active Directory (AD) data to non-Domain Controllers is not a common practice and is generally not recommended from a security perspective, some software vendors may require it for their products to function correctly. If this rule is noisy in your environment due to expected activity, consider adding the corresponding account as a exception.


### Response and remediation

- Initiate the incident response process based on the outcome of the triage.
- Investigate credential exposure on systems compromised or used by the attacker to ensure all compromised accounts are identified. Reset passwords for these accounts and other potentially compromised credentials, such as email, business systems, and web services.
- If the entire domain or the `krbtgt` user was compromised:
  - Activate your incident response plan for total Active Directory compromise which should include, but not be limited to, a password reset (twice) of the `krbtgt` user.
- Investigate how the attacker escalated privileges and identify systems they used to conduct lateral movement. Use this information to determine ways the attacker could regain access to the environment.
- Determine the initial vector abused by the attacker and take action to prevent reinfection through the same vector.
- Using the incident response data, update logging and audit policies to improve the mean time to detect (MTTD) and the mean time to respond (MTTR).


## Rule Query

```kuery
host.os.type:"windows" and event.code:"4662" and
  winlog.event_data.Properties:(
    *DS-Replication-Get-Changes* or *DS-Replication-Get-Changes-All* or
    *DS-Replication-Get-Changes-In-Filtered-Set* or *1131f6ad-9c07-11d1-f79f-00c04fc2dcd2* or
    *1131f6aa-9c07-11d1-f79f-00c04fc2dcd2* or *89e95b76-444d-4c62-991a-0facbeda640c*
  ) and winlog.event_data.AccessMask : "0x100" and
  not winlog.event_data.SubjectUserName:(*$ or MSOL_*)
```

**Framework:** MITRE ATT&CK
- Tactic:
  - Name: Credential Access
- Id: TA0006
- Reference URL: [[https://attack.mitre.org/tactics/TA0006/](https://attack.mitre.org/tactics/TA0006/)](https://attack.mitre.org/tactics/TA0006/)
- Technique:
  - Name: OS Credential Dumping
- Id: T1003
- Reference URL: [[https://attack.mitre.org/techniques/T1003/](https://attack.mitre.org/techniques/T1003/)](https://attack.mitre.org/techniques/T1003/)
- Sub Technique:
  - Name: DCSync
- Id: T1003.006
- Reference URL: [[https://attack.mitre.org/techniques/T1003/006/](https://attack.mitre.org/techniques/T1003/006/)](https://attack.mitre.org/techniques/T1003/006/)

**Framework:** MITRE ATT&CK
- Tactic:
  - Name: Privilege Escalation
- Id: TA0004
- Reference URL: [[https://attack.mitre.org/tactics/TA0004/](https://attack.mitre.org/tactics/TA0004/)](https://attack.mitre.org/tactics/TA0004/)
- Technique:
  - Name: Valid Accounts
- Id: T1078
- Reference URL: [[https://attack.mitre.org/techniques/T1078/](https://attack.mitre.org/techniques/T1078/)](https://attack.mitre.org/techniques/T1078/)
- Sub Technique:
  - Name: Domain Accounts
- Id: T1078.002
- Reference URL: [[https://attack.mitre.org/techniques/T1078/002/](https://attack.mitre.org/techniques/T1078/002/)](https://attack.mitre.org/techniques/T1078/002/)