﻿---
title: Potential Credential Access via Windows Utilities
description: Identifies the execution of known Windows utilities often abused to dump LSASS memory or the Active Directory database (NTDS.dit) in preparation for credential...
url: https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/windows/credential_access_cmdline_dump_tool
products:
  - Elastic Security
---

# Potential Credential Access via Windows Utilities
Identifies the execution of known Windows utilities often abused to dump LSASS memory or the Active Directory database
(NTDS.dit) in preparation for credential access.
**Rule type**: eql
**Rule indices**:
- endgame-*
- logs-endpoint.events.process-*
- logs-m365_defender.event-*
- logs-sentinel_one_cloud_funnel.*
- logs-system.security*
- logs-windows.forwarded*
- logs-windows.sysmon_operational-*
- winlogbeat-*

**Rule Severity**: high
**Risk Score**: 73
**Runs every**: 
**Searches indices from**: `now-9m`
**Maximum alerts per execution**: 100
**References**:
- [[https://lolbas-project.github.io/](https://lolbas-project.github.io/)](https://lolbas-project.github.io/)
- [[https://www.elastic.co/security-labs/elastic-protects-against-data-wiper-malware-targeting-ukraine-hermeticwiper](https://www.elastic.co/security-labs/elastic-protects-against-data-wiper-malware-targeting-ukraine-hermeticwiper)](https://www.elastic.co/security-labs/elastic-protects-against-data-wiper-malware-targeting-ukraine-hermeticwiper)

**Tags**:
- Domain: Endpoint
- OS: Windows
- Use Case: Threat Detection
- Tactic: Credential Access
- Tactic: Defense Evasion
- Resources: Investigation Guide
- Data Source: Elastic Endgame
- Data Source: Elastic Defend
- Data Source: Windows Security Event Logs
- Data Source: Microsoft Defender for Endpoint
- Data Source: SentinelOne
- Data Source: Sysmon

**Version**: 319
**Rule authors**:
- Elastic

**Rule license**: Elastic License v2

## Investigation guide


## Triage and analysis


### Investigating Potential Credential Access via Windows Utilities

Local Security Authority Server Service (LSASS) is a process in Microsoft Windows operating systems that is responsible for enforcing security policy on the system. It verifies users logging on to a Windows computer or server, handles password changes, and creates access tokens.
The `Ntds.dit` file is a database that stores Active Directory data, including information about user objects, groups, and group membership.
This rule looks for the execution of utilities that can extract credential data from the LSASS memory and Active Directory `Ntds.dit` file.

#### Possible investigation steps

- Investigate the process execution chain (parent process tree) for unknown processes. Examine their executable files for prevalence, whether they are located in expected locations, and if they are signed with valid digital signatures.
- Investigate abnormal behaviors observed by the subject process, such as network connections, registry or file modifications, and any spawned child processes.
- Investigate other alerts associated with the user/host during the past 48 hours.
- Examine the command line to identify what information was targeted.
- Identify the target computer and its role in the IT environment.


### False positive analysis

- This activity is unlikely to happen legitimately. Any activity that triggered the alert and is not inherently malicious must be monitored by the security team.


### Response and remediation

- Initiate the incident response process based on the outcome of the triage.
- If the host is a domain controller (DC):
  - Activate your incident response plan for total Active Directory compromise.
- Review the privileges assigned to users that can access the DCs, to ensure that the least privilege principle is being followed and to reduce the attack surface.
- Isolate the involved hosts to prevent further post-compromise behavior.
- Investigate credential exposure on systems compromised or used by the attacker to ensure all compromised accounts are identified. Reset passwords for these accounts and other potentially compromised credentials, such as email, business systems, and web services.
- Run a full antimalware scan. This may reveal additional artifacts left in the system, persistence mechanisms, and malware components.
- Determine the initial vector abused by the attacker and take action to prevent reinfection through the same vector.
- Using the incident response data, update logging and audit policies to improve the mean time to detect (MTTD) and the mean time to respond (MTTR).


## Rule Query

```eql
process where host.os.type == "windows" and event.type == "start" and
(
  (
    (?process.pe.original_file_name : "procdump" or process.name : "procdump.exe") and process.args : "-ma"
  ) or
  (
    process.name : "ProcessDump.exe" and not process.parent.executable regex~ """C:\\Program Files( \(x86\))?\\Cisco Systems\\.*"""
  ) or
  (
    (?process.pe.original_file_name : "WriteMiniDump.exe" or process.name : "WriteMiniDump.exe") and
      not process.parent.executable regex~ """C:\\Program Files( \(x86\))?\\Steam\\.*"""
  ) or
  (
    (?process.pe.original_file_name : "RUNDLL32.EXE" or process.name : "RUNDLL32.exe") and
      (process.args : "*MiniDump*" or process.command_line : "*comsvcs*#*24*")
  ) or
  (
    (?process.pe.original_file_name : "RdrLeakDiag.exe" or process.name : "RdrLeakDiag.exe") and
      process.args : "/fullmemdmp"
  ) or
  (
    (?process.pe.original_file_name : "SqlDumper.exe" or process.name : "SqlDumper.exe") and
      process.args : "0x01100*") or
  (
    (?process.pe.original_file_name : "TTTracer.exe" or process.name : "TTTracer.exe") and
      process.args : "-dumpFull" and process.args : "-attach") or
  (
    (?process.pe.original_file_name : "ntdsutil.exe" or process.name : "ntdsutil.exe") and
      process.args : "cr*fu*") or
  (
    (?process.pe.original_file_name : "diskshadow.exe" or process.name : "diskshadow.exe") and process.args : "/s")
)
```

**Framework:** MITRE ATT&CK
- Tactic:
  - Name: Credential Access
- Id: TA0006
- Reference URL: [[https://attack.mitre.org/tactics/TA0006/](https://attack.mitre.org/tactics/TA0006/)](https://attack.mitre.org/tactics/TA0006/)
- Technique:
  - Name: OS Credential Dumping
- Id: T1003
- Reference URL: [[https://attack.mitre.org/techniques/T1003/](https://attack.mitre.org/techniques/T1003/)](https://attack.mitre.org/techniques/T1003/)
- Sub Technique:
  - Name: LSASS Memory
- Id: T1003.001
- Reference URL: [[https://attack.mitre.org/techniques/T1003/001/](https://attack.mitre.org/techniques/T1003/001/)](https://attack.mitre.org/techniques/T1003/001/)
- Sub Technique:
  - Name: NTDS
- Id: T1003.003
- Reference URL: [[https://attack.mitre.org/techniques/T1003/003/](https://attack.mitre.org/techniques/T1003/003/)](https://attack.mitre.org/techniques/T1003/003/)

**Framework:** MITRE ATT&CK
- Tactic:
  - Name: Defense Evasion
- Id: TA0005
- Reference URL: [[https://attack.mitre.org/tactics/TA0005/](https://attack.mitre.org/tactics/TA0005/)](https://attack.mitre.org/tactics/TA0005/)
- Technique:
  - Name: System Binary Proxy Execution
- Id: T1218
- Reference URL: [[https://attack.mitre.org/techniques/T1218/](https://attack.mitre.org/techniques/T1218/)](https://attack.mitre.org/techniques/T1218/)
- Sub Technique:
  - Name: Rundll32
- Id: T1218.011
- Reference URL: [[https://attack.mitre.org/techniques/T1218/011/](https://attack.mitre.org/techniques/T1218/011/)](https://attack.mitre.org/techniques/T1218/011/)