﻿---
title: Multiple Logon Failure Followed by Logon Success
description: Identifies multiple logon failures followed by a successful one from the same source address. Adversaries will often brute force login attempts across...
url: https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/windows/credential_access_bruteforce_multiple_logon_failure_followed_by_success
products:
  - Elastic Security
---

# Multiple Logon Failure Followed by Logon Success
Identifies multiple logon failures followed by a successful one from the same source address. Adversaries will often
brute force login attempts across multiple users with a common or known password, in an attempt to gain access to
accounts.
**Rule type**: eql
**Rule indices**:
- logs-system.security*
- logs-windows.forwarded*
- winlogbeat-*

**Rule Severity**: medium
**Risk Score**: 47
**Runs every**: 
**Searches indices from**: `now-9m`
**Maximum alerts per execution**: 100
**References**:
- [[https://docs.microsoft.com/en-us/windows/security/threat-protection/auditing/event-4625](https://docs.microsoft.com/en-us/windows/security/threat-protection/auditing/event-4625)](https://docs.microsoft.com/en-us/windows/security/threat-protection/auditing/event-4625)

**Tags**:
- Domain: Endpoint
- OS: Windows
- Use Case: Threat Detection
- Tactic: Credential Access
- Resources: Investigation Guide
- Data Source: Windows Security Event Logs

**Version**: 116
**Rule authors**:
- Elastic

**Rule license**: Elastic License v2

## Investigation guide


## Triage and analysis


### Investigating Multiple Logon Failure Followed by Logon Success

Adversaries with no prior knowledge of legitimate credentials within the system or environment may guess passwords to attempt access to accounts. Without knowledge of the password for an account, an adversary may opt to guess the password using a repetitive or iterative mechanism systematically. More details can be found [here](https://attack.mitre.org/techniques/T1110/001/).
This rule identifies potential password guessing/brute force activity from a single address, followed by a successful logon, indicating that an attacker potentially successfully compromised the account.> **Note**:
This investigation guide uses the [Osquery Markdown Plugin](https://www.elastic.co/guide/en/security/current/invest-guide-run-osquery.html) introduced in Elastic Stack version 8.5.0. Older Elastic Stack versions will display unrendered Markdown in this guide.

#### Possible investigation steps

- Investigate the logon failure reason code and the targeted user name.
  - Prioritize the investigation if the account is critical or has administrative privileges over the domain.
- Investigate the source IP address of the failed Network Logon attempts.
  - Identify whether these attempts are coming from the internet or are internal.
- Investigate other alerts associated with the involved users and source host during the past 48 hours.
- Identify the source and the target computer and their roles in the IT environment.
- Check whether the involved credentials are used in automation or scheduled tasks.
- If this activity is suspicious, contact the account owner and confirm whether they are aware of it.
- Examine the source host for derived artifacts that indicate compromise:
  - Observe and collect information about the following activities in the alert source host:
  - Attempts to contact external domains and addresses.
  - Examine the DNS cache for suspicious or anomalous entries.
  - $osquery_0
- Examine the host services for suspicious or anomalous entries.
  - $osquery_1
- $osquery_2
- $osquery_3
- Investigate potentially compromised accounts. Analysts can do this by searching for login events (for example, 4624) to the host which is the source of this activity.


### False positive analysis

- Authentication misconfiguration or obsolete credentials.
- Service account password expired.
- Domain trust relationship issues.
- Infrastructure or availability issues.


### Related rules

- Multiple Logon Failure from the same Source Address - 48b6edfc-079d-4907-b43c-baffa243270d


### Response and remediation

- Initiate the incident response process based on the outcome of the triage.
- Isolate the source host to prevent further post-compromise behavior.
- If the asset is exposed to the internet with RDP or other remote services available, take the necessary measures to restrict access to the asset. If not possible, limit the access via the firewall to only the needed IP addresses. Also, ensure the system uses robust authentication mechanisms and is patched regularly.
- Investigate credential exposure on systems compromised or used by the attacker to ensure all compromised accounts are identified. Reset passwords for these accounts and other potentially compromised credentials, such as email, business systems, and web services.
- Run a full antimalware scan. This may reveal additional artifacts left in the system, persistence mechanisms, and malware components.
- Determine the initial vector abused by the attacker and take action to prevent reinfection through the same vector.
- Using the incident response data, update logging and audit policies to improve the mean time to detect (MTTD) and the mean time to respond (MTTR).


## Rule Query

```eql
sequence by winlog.computer_name, source.ip with maxspan=5s
  [authentication where host.os.type == "windows" and event.action == "logon-failed" and
    /* event 4625 need to be logged */
    winlog.logon.type : "Network" and user.id != null and 
    source.ip != null and source.ip != "127.0.0.1" and source.ip != "::1" and 
    not winlog.event_data.TargetUserSid : "S-1-0-0" and not user.id : "S-1-0-0" and 
    not user.name : ("ANONYMOUS LOGON", "-", "*$") and not user.domain == "NT AUTHORITY" and

    /* noisy failure status codes often associated to authentication misconfiguration */
    not winlog.event_data.Status : ("0xC000015B", "0XC000005E", "0XC0000133", "0XC0000192")] with runs=5
  [authentication where host.os.type == "windows" and event.action == "logged-in" and
    /* event 4624 need to be logged */
    winlog.logon.type : "Network" and
    source.ip != null and source.ip != "127.0.0.1" and source.ip != "::1" and
    not user.name : ("ANONYMOUS LOGON", "-", "*$") and not user.domain == "NT AUTHORITY"]
```

**Framework:** MITRE ATT&CK
- Tactic:
  - Name: Credential Access
- Id: TA0006
- Reference URL: [[https://attack.mitre.org/tactics/TA0006/](https://attack.mitre.org/tactics/TA0006/)](https://attack.mitre.org/tactics/TA0006/)
- Technique:
  - Name: Brute Force
- Id: T1110
- Reference URL: [[https://attack.mitre.org/techniques/T1110/](https://attack.mitre.org/techniques/T1110/)](https://attack.mitre.org/techniques/T1110/)
- Sub Technique:
  - Name: Password Guessing
- Id: T1110.001
- Reference URL: [[https://attack.mitre.org/techniques/T1110/001/](https://attack.mitre.org/techniques/T1110/001/)](https://attack.mitre.org/techniques/T1110/001/)
- Sub Technique:
  - Name: Password Spraying
- Id: T1110.003
- Reference URL: [[https://attack.mitre.org/techniques/T1110/003/](https://attack.mitre.org/techniques/T1110/003/)](https://attack.mitre.org/techniques/T1110/003/)