﻿---
title: Browser Process Spawned from an Unusual Parent
description: Identifies instances where an unusual process spawns a chrome browser child process. This behavior could be related to malware stealing browser information...
url: https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/windows/credential_access_browsers_unusual_parent
products:
  - Elastic Security
---

# Browser Process Spawned from an Unusual Parent
Identifies instances where an unusual process spawns a chrome browser child process. This behavior could be related to malware
stealing browser information.
**Rule type**: eql
**Rule indices**:
- endgame-*
- logs-endpoint.events.process-*
- logs-m365_defender.event-*
- logs-sentinel_one_cloud_funnel.*
- logs-system.security*
- logs-windows.forwarded*
- logs-windows.sysmon_operational-*
- winlogbeat-*

**Rule Severity**: high
**Risk Score**: 73
**Runs every**: 
**Searches indices from**: `now-9m`
**Maximum alerts per execution**: 100
**References**:
- [[https://www.elastic.co/security-labs/katz-and-mouse-game](https://www.elastic.co/security-labs/katz-and-mouse-game)](https://www.elastic.co/security-labs/katz-and-mouse-game)

**Tags**:
- Domain: Endpoint
- OS: Windows
- Use Case: Threat Detection
- Tactic: Credential Access
- Data Source: Elastic Endgame
- Data Source: Elastic Defend
- Data Source: Windows Security Event Logs
- Data Source: Microsoft Defender for Endpoint
- Data Source: Sysmon
- Data Source: SentinelOne
- Resources: Investigation Guide

**Version**: 1
**Rule authors**:
- Elastic

**Rule license**: Elastic License v2

## Investigation guide


## Triage and analysis> **Disclaimer**:
This investigation guide was created using generative AI technology and has been reviewed to improve its accuracy and relevance. While every effort has been made to ensure its quality, we recommend validating the content and adapting it to suit your specific environment and operational needs.

### Investigating Browser Process Spawned from an Unusual Parent


### Possible investigation steps

- Review the process execution details to confirm that a web browser process (e.g., chrome.exe, msedge.exe, firefox.exe) has an unusual or suspicious parent process. Focus on the process.parent.name, process.name, and process.args fields.
- Examine the command line arguments for signs of remote debugging flags (e.g., --remote-debugging-port, --remote-debugging-pipe) or injected DLLs that could indicate attempts to hijack browser sessions.
- Check whether the parent process is a scripting host (e.g., wscript.exe, cscript.exe), system utility, or unexpected binary (e.g., cmd.exe, rundll32.exe, powershell.exe) rather than the legitimate browser updater or system launcher.
- Investigate if the suspicious parent process has a known reputation or hash linked to malware or credential-stealing tools by correlating with threat intelligence sources.
- Look for additional related processes spawned by the browser that might indicate malicious activity, such as network connections to unusual external IPs or data exfiltration attempts.
- Review authentication logs to identify if any credential theft attempts occurred shortly after the suspicious browser activity, focusing on abnormal logins, failed authentications, or credential access patterns.
- Cross-reference with endpoint telemetry (e.g., Defender for Endpoint, Sysmon) to identify whether this event is part of a broader intrusion attempt involving code injection or persistence mechanisms.


### False positive analysis

- Certain enterprise management or testing tools may launch browsers with remote debugging enabled for automation purposes. Identify and document such legitimate tools and processes.
- Development environments may use browser remote debugging features during legitimate software testing. Exclude known dev/test machines or users from triggering alerts in production environments.
- Security testing frameworks or internal red team activities may use similar techniques. Coordinate with authorized security teams to whitelist scheduled exercises.
- Browser extensions or third-party plugins could sometimes spawn processes that appear unusual. Validate if the behavior aligns with known, legitimate extensions.
- Automated IT scripts or orchestration tools might start browsers in debugging mode for monitoring purposes. Whitelist these cases based on process path, signature, or command-line arguments.


### Response and remediation

- Isolate the affected endpoint from the network to prevent potential credential theft or data exfiltration.
- Terminate any suspicious processes identified in the alert, including both the browser and its anomalous parent process.
- Collect forensic artifacts (process memory, browser profiles, injected modules) for further investigation and potential IOCs.
- Reset credentials for accounts that may have been exposed through the compromised browser session.
- Deploy updated endpoint protection signatures and enable stricter application control policies to prevent browsers from being launched by untrusted processes.
- Enhance monitoring for browser processes launched with debugging flags or code injection indicators across the environment.
- Escalate to the SOC or IR team to determine whether this event is part of a larger credential theft campaign or linked to other lateral movement activity.


## Rule Query

```eql
process where host.os.type == "windows" and event.type == "start" and
  process.name : ("chrome.exe", "msedge.exe") and
  process.parent.executable != null and process.command_line != null and
  (
  process.command_line :
           ("\"C:\\Program Files (x86)\\Microsoft\\Edge\\Application\\msedge.exe\"",
            "\"C:\\Program Files\\Google\\Chrome\\Application\\chrome.exe\"",
            "\"C:\\Program Files\\Google\\Chrome\\Application\\chrome.exe\" --headless --disable-logging --log-level=3 --v=0",
            "\"C:\\Program Files\\Google\\Chrome\\Application\\chrome.exe\" --headless --log-level=3",
            "\"C:\\Program Files\\Google\\Chrome\\Application\\chrome.exe\" --headless",
            "\"C:\\Program Files\\Google\\Chrome\\Application\\chrome.exe\" --remote-debugging-port=922? --profile-directory=\"Default\"*",
            "\"C:\\Program Files\\Google\\Chrome\\Application\\chrome.exe\" --headless --restore-last-session --remote-debugging-port=45452*") or

  (process.args : "--remote-debugging-port=922?" and process.args : "--window-position=-*,-*")
   ) and
  not process.parent.executable :
                         ("C:\\Windows\\explorer.exe",
                          "C:\\Program Files (x86)\\*.exe",
                          "C:\\Program Files\\*.exe",
                          "C:\\Windows\\System32\\rdpinit.exe",
                          "C:\\Windows\\System32\\sihost.exe",
                          "C:\\Windows\\System32\\RuntimeBroker.exe",
                          "C:\\Windows\\System32\\SECOCL64.exe")
```

**Framework:** MITRE ATT&CK
- Tactic:
  - Name: Credential Access
- Id: TA0006
- Reference URL: [[https://attack.mitre.org/tactics/TA0006/](https://attack.mitre.org/tactics/TA0006/)](https://attack.mitre.org/tactics/TA0006/)
- Technique:
  - Name: Credentials from Password Stores
- Id: T1555
- Reference URL: [[https://attack.mitre.org/techniques/T1555/](https://attack.mitre.org/techniques/T1555/)](https://attack.mitre.org/techniques/T1555/)
- Sub Technique:
  - Name: Credentials from Web Browsers
- Id: T1555.003
- Reference URL: [[https://attack.mitre.org/techniques/T1555/003/](https://attack.mitre.org/techniques/T1555/003/)](https://attack.mitre.org/techniques/T1555/003/)