﻿---
title: Potential WPAD Spoofing via DNS Record Creation
description: Identifies the creation of a DNS record that is potentially meant to enable WPAD spoofing. Attackers can disable the Global Query Block List (GQBL) and...
url: https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/windows/credential_access_adidns_wpad_record
products:
  - Elastic Security
---

# Potential WPAD Spoofing via DNS Record Creation
Identifies the creation of a DNS record that is potentially meant to enable WPAD spoofing. Attackers can disable the
Global Query Block List (GQBL) and create a "wpad" record to exploit hosts running WPAD with default settings for
privilege escalation and lateral movement.
**Rule type**: eql
**Rule indices**:
- logs-system.security*
- logs-windows.forwarded*
- winlogbeat-*

**Rule Severity**: medium
**Risk Score**: 47
**Runs every**: 
**Searches indices from**: `now-9m`
**Maximum alerts per execution**: 100
**References**:
- [[https://www.thehacker.recipes/ad/movement/mitm-and-coerced-authentications/wpad-spoofing#through-adidns-spoofing](https://www.thehacker.recipes/ad/movement/mitm-and-coerced-authentications/wpad-spoofing#through-adidns-spoofing)](https://www.thehacker.recipes/ad/movement/mitm-and-coerced-authentications/wpad-spoofing#through-adidns-spoofing)
- [[https://cube0x0.github.io/Pocing-Beyond-DA/](https://cube0x0.github.io/Pocing-Beyond-DA/)](https://cube0x0.github.io/Pocing-Beyond-DA/)

**Tags**:
- Domain: Endpoint
- OS: Windows
- Use Case: Threat Detection
- Tactic: Credential Access
- Data Source: Active Directory
- Use Case: Active Directory Monitoring
- Data Source: Windows Security Event Logs
- Resources: Investigation Guide

**Version**: 107
**Rule authors**:
- Elastic

**Rule license**: Elastic License v2

## Setup

The 'Audit Directory Service Changes' logging policy must be configured for (Success, Failure).
Steps to implement the logging policy with Advanced Audit Configuration:
```
Computer Configuration >
Policies >
Windows Settings >
Security Settings >
Advanced Audit Policies Configuration >
Audit Policies >
DS Access >
Audit Directory Service Changes (Success,Failure)
```

The above policy does not cover the target object by default (we still need it to be configured to generate events), so we need to set up an AuditRule using [https://github.com/OTRF/Set-AuditRule](https://github.com/OTRF/Set-AuditRule).
```
Set-AuditRule -AdObjectPath 'AD:\CN=MicrosoftDNS,DC=DomainDNSZones,DC=Domain,DC=com' -WellKnownSidType WorldSid -Rights CreateChild -InheritanceFlags Descendents -AttributeGUID e0fa1e8c-9b45-11d0-afdd-00c04fd930c9 -AuditFlags Success
```


## Investigation guide


## Triage and analysis> **Disclaimer**:
This investigation guide was created using generative AI technology and has been reviewed to improve its accuracy and relevance. While every effort has been made to ensure its quality, we recommend validating the content and adapting it to suit your specific environment and operational needs.

### Investigating Potential WPAD Spoofing via DNS Record Creation

Web Proxy Auto-Discovery (WPAD) helps devices automatically detect proxy settings, crucial for network efficiency. However, attackers can exploit WPAD by creating malicious DNS records, tricking systems into using rogue proxies for data interception. The detection rule identifies suspicious DNS record changes, specifically targeting WPAD entries, to flag potential spoofing attempts, aiding in early threat detection and mitigation.

### Possible investigation steps

- Review the event logs for the specific event code "5137" to identify the creation or modification of the "wpad" DNS record. Focus on the details provided in the winlog.event_data.ObjectDN field to confirm the presence of "DC=wpad,*".
- Check the Active Directory change history to determine who made the changes to the DNS records and whether these changes were authorized.
- Investigate the user account associated with the directory service change event to assess if it has been compromised or if there are any signs of unauthorized access.
- Analyze network traffic to and from the "wpad" DNS record to identify any suspicious activity or connections to rogue proxy servers.
- Verify the configuration of the Global Query Block List (GQBL) to ensure it has not been disabled or altered, which could allow unauthorized WPAD entries.
- Cross-reference the alert with other security logs and alerts to identify any related suspicious activities or patterns that could indicate a broader attack campaign.


### False positive analysis

- Legitimate network changes may trigger alerts if a new WPAD DNS record is created intentionally for network configuration. Verify with network administrators if such changes were planned.
- Automated scripts or software updates that modify DNS records can cause false positives. Review the source of the change and consider excluding known benign scripts or update processes.
- Test environments often simulate DNS changes, including WPAD entries, for development purposes. Exclude these environments from monitoring if they are known to generate non-threatening alerts.
- Some organizations may have legacy systems that rely on WPAD configurations. Document these systems and create exceptions for their DNS changes to avoid unnecessary alerts.
- Regular audits of the Global Query Block List settings can help identify and exclude expected changes, reducing false positives related to WPAD record creation.


### Response and remediation

- Immediately isolate the affected system from the network to prevent further data interception or lateral movement by the rogue proxy.
- Verify and restore the integrity of the DNS records by removing any unauthorized "wpad" entries and re-enabling the Global Query Block List (GQBL) if it was disabled.
- Conduct a thorough review of Active Directory logs to identify any unauthorized changes or suspicious activities related to directory service modifications.
- Reset credentials for any accounts that may have been compromised or accessed during the incident to prevent unauthorized access.
- Implement network segmentation to limit the exposure of critical systems to potential WPAD spoofing attacks.
- Escalate the incident to the security operations center (SOC) for further investigation and to determine if additional systems or data were affected.
- Update and enhance monitoring rules to detect similar WPAD spoofing attempts in the future, ensuring timely alerts and responses.


## Rule Query

```eql
any where host.os.type == "windows" and event.code == "5137" and winlog.event_data.ObjectDN : "DC=wpad,*"
```

**Framework:** MITRE ATT&CK
- Tactic:
  - Name: Credential Access
- Id: TA0006
- Reference URL: [[https://attack.mitre.org/tactics/TA0006/](https://attack.mitre.org/tactics/TA0006/)](https://attack.mitre.org/tactics/TA0006/)
- Technique:
  - Name: Adversary-in-the-Middle
- Id: T1557
- Reference URL: [[https://attack.mitre.org/techniques/T1557/](https://attack.mitre.org/techniques/T1557/)](https://attack.mitre.org/techniques/T1557/)