﻿---
title: NetSupport Manager Execution from an Unusual Path
description: Identifies execution of the NetSupport remote access software from non-default paths. Adversaries may abuse NetSupport Manager to control a target victim...
url: https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/windows/command_and_control_rmm_netsupport_susp_path
products:
  - Elastic Security
---

# NetSupport Manager Execution from an Unusual Path
Identifies execution of the NetSupport remote access software from non-default paths. Adversaries may abuse NetSupport
Manager to control a target victim machine.
**Rule type**: eql
**Rule indices**:
- endgame-*
- logs-crowdstrike.fdr*
- logs-endpoint.events.process-*
- logs-m365_defender.event-*
- logs-sentinel_one_cloud_funnel.*
- logs-system.security*
- logs-windows.sysmon_operational-*
- winlogbeat-*

**Rule Severity**: high
**Risk Score**: 73
**Runs every**: 
**Searches indices from**: `now-9m`
**Maximum alerts per execution**: 100
**References**:
- [[https://www.netsupportsoftware.com/](https://www.netsupportsoftware.com/)](https://www.netsupportsoftware.com/)

**Tags**:
- Domain: Endpoint
- OS: Windows
- Use Case: Threat Detection
- Tactic: Command and Control
- Resources: Investigation Guide
- Data Source: Elastic Endgame
- Data Source: Elastic Defend
- Data Source: Sysmon
- Data Source: SentinelOne
- Data Source: Microsoft Defender for Endpoint
- Data Source: Windows Security Event Logs
- Data Source: Crowdstrike

**Version**: 1
**Rule authors**:
- Elastic

**Rule license**: Elastic License v2

## Investigation guide


## Triage and analysis


### Investigating NetSupport Manager Execution from an Unusual Path

NetSupport Manager, is a remote access tool, facilitates legitimate remote support but can be exploited by adversaries to execute unauthorized commands.

### Possible investigation steps

- Review the origin of the NetSupport file and if it's related to an authorized IT Support case.
- Examine if the NetSupport process is set to persist in the affected system via scheduled task, Startup folder or Run key.
- Check the network, files and child processes activity associated with the NetSupport client32.exe process.
- Correlate the event with other security alerts or logs from data sources like Elastic Defend or Microsoft Defender for Endpoint to gather additional context and identify any related malicious activities.


### False positive analysis

- Legitimate IT support activities using NetSupport by IT support accounts.


### Response and remediation

- Immediately isolate the affected system from the network to prevent further unauthorized access or lateral movement by the attacker.
- Terminate any suspicious processes identified in the alert, such as PowerShell, cmd.exe, or other flagged executables, to halt any ongoing malicious activity.
- Review and revoke any unauthorized user accounts or privileges that may have been created or modified using tools like net.exe or schtasks.exe.
- Conduct a thorough scan of the affected system using endpoint protection tools to identify and remove any malware or unauthorized software installed by the attacker.
- Restore the system from a known good backup if any critical system files or configurations have been altered or compromised.
- Escalate the incident to the security operations center (SOC) or incident response team for further investigation and to determine if additional systems are affected.
- Implement enhanced monitoring and logging for ScreenConnect and other remote access tools to detect similar activities in the future, ensuring that alerts are promptly reviewed and acted upon.


## Rule Query

```eql
process where host.os.type == "windows" and event.type == "start" and
 (process.name : "client32.exe" or ?process.pe.original_file_name == "client32.exe" or process.parent.name : "client32.exe") and
 (
  process.executable :
               ("?:\\Users\\*.exe",
                "?:\\ProgramData\\*.exe",
                "\\Device\\HarddiskVolume?\\Users\\*.exe",
                "\\Device\\HarddiskVolume?\\ProgramData\\*.exe") or
  ?process.parent.executable : ("?:\\Users\\*\\client32.exe", "?:\\ProgramData\\*\\client32.exe")
  )
```

**Framework:** MITRE ATT&CK
- Tactic:
  - Name: Command and Control
- Id: TA0011
- Reference URL: [[https://attack.mitre.org/tactics/TA0011/](https://attack.mitre.org/tactics/TA0011/)](https://attack.mitre.org/tactics/TA0011/)
- Technique:
  - Name: Remote Access Tools
- Id: T1219
- Reference URL: [[https://attack.mitre.org/techniques/T1219/](https://attack.mitre.org/techniques/T1219/)](https://attack.mitre.org/techniques/T1219/)