﻿---
title: Remote File Download via PowerShell
description: Identifies powershell.exe being used to download an executable file from an untrusted remote destination. Rule type: eql Rule indices: logs-endpoint.events.network-*,...
url: https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/windows/command_and_control_remote_file_copy_powershell
products:
  - Elastic Security
---

# Remote File Download via PowerShell
Identifies powershell.exe being used to download an executable file from an untrusted remote destination.
**Rule type**: eql
**Rule indices**:
- logs-endpoint.events.network-*
- logs-endpoint.events.file-*

**Rule Severity**: medium
**Risk Score**: 47
**Runs every**: 
**Searches indices from**: `now-9m`
**Maximum alerts per execution**: 100
**References**:
**Tags**:
- Domain: Endpoint
- OS: Windows
- Use Case: Threat Detection
- Tactic: Command and Control
- Resources: Investigation Guide
- Data Source: Elastic Defend

**Version**: 114
**Rule authors**:
- Elastic

**Rule license**: Elastic License v2

## Investigation guide


## Triage and analysis


### Investigating Remote File Download via PowerShell

Attackers commonly transfer tooling or malware from external systems into a compromised environment using the command and control channel. However, they can also abuse signed utilities to drop these files.
PowerShell is one of system administrators' main tools for automation, report routines, and other tasks. This makes it available for use in various environments and creates an attractive way for attackers to execute code and perform actions. This rule correlates network and file events to detect downloads of executable and script files performed using PowerShell.> **Note**:
This investigation guide uses the [Osquery Markdown Plugin](https://www.elastic.co/guide/en/security/current/invest-guide-run-osquery.html) introduced in Elastic Stack version 8.5.0. Older Elastic Stack versions will display unrendered Markdown in this guide.
This investigation guide uses the [Investigate Markdown Plugin](https://www.elastic.co/guide/en/security/current/interactive-investigation-guides.html) introduced in Elastic Stack version 8.8.0. Older Elastic Stack versions will display unrendered Markdown in this guide.

#### Possible investigation steps

- Investigate the process execution chain (parent process tree) for unknown processes. Examine their executable files for prevalence, whether they are located in expected locations, and if they are signed with valid digital signatures.
- Identify the user account that performed the action and whether it should perform this kind of action.
- Evaluate whether the user needs to use PowerShell to complete tasks.
- Investigate other alerts associated with the user/host during the past 48 hours.
  - $investigate_0
- $investigate_1
- Check the reputation of the domain or IP address used to host the downloaded file.
- Examine the host for derived artifacts that indicate suspicious activities:
  - Analyze the file using a private sandboxed analysis system.
- Observe and collect information about the following activities in both the sandbox and the alert subject host:
  - Attempts to contact external domains and addresses.
  - Use the Elastic Defend network events to determine domains and addresses contacted by the subject process by filtering by the process' `process.entity_id`.
  - $investigate_2
- Examine the DNS cache for suspicious or anomalous entries.
  - $osquery_0
- Use the Elastic Defend registry events to examine registry keys accessed, modified, or created by the related processes in the process tree.
- Examine the host services for suspicious or anomalous entries.
  - $osquery_1
- $osquery_2
- $osquery_3
- Retrieve the files' SHA-256 hash values using the PowerShell `Get-FileHash` cmdlet and search for the existence and reputation of the hashes in resources like VirusTotal, Hybrid-Analysis, CISCO Talos, Any.run, etc.
- Investigate potentially compromised accounts. Analysts can do this by searching for login events (for example, 4624) to the target host after the registry modification.


### False positive analysis

- Administrators can use PowerShell legitimately to download executable and script files. Analysts can dismiss the alert if the Administrator is aware of the activity and the triage has not identified suspicious or malicious files.


### Response and remediation

- Initiate the incident response process based on the outcome of the triage.
- Isolate the involved host to prevent further post-compromise behavior.
- If the triage identified malware, search the environment for additional compromised hosts.
  - Implement temporary network rules, procedures, and segmentation to contain the malware.
- Stop suspicious processes.
- Immediately block the identified indicators of compromise (IoCs).
- Inspect the affected systems for additional malware backdoors like reverse shells, reverse proxies, or droppers that attackers could use to reinfect the system.
- Remove and block malicious artifacts identified during triage.
- Run a full antimalware scan. This may reveal additional artifacts left in the system, persistence mechanisms, and malware components.
- Investigate credential exposure on systems compromised or used by the attacker to ensure all compromised accounts are identified. Reset passwords for these accounts and other potentially compromised credentials, such as email, business systems, and web services.
- Determine the initial vector abused by the attacker and take action to prevent reinfection through the same vector.
- Using the incident response data, update logging and audit policies to improve the mean time to detect (MTTD) and the mean time to respond (MTTR).


## Rule Query

```eql
sequence by process.entity_id with maxspan=30s
[network where host.os.type == "windows" and 
  process.name : ("powershell.exe", "pwsh.exe", "powershell_ise.exe") and
  network.protocol == "dns" and
  not dns.question.name : (
        "*.microsoft.com", "*.azureedge.net", "*.powershellgallery.com", "*.windowsupdate.com",
        "metadata.google.internal", "dist.nuget.org", "artifacts.elastic.co", "*.digicert.com",
        "*.chocolatey.org", "outlook.office365.com", "cdn.oneget.org", "ci.dot.net",
        "packages.icinga.com", "login.microsoftonline.com", "*.gov", "*.azure.com", "*.python.org",
        "dl.google.com", "sensor.cloud.tenable.com", "*.azurefd.net", "*.office.net", "*.anac*",
        "aka.ms", "dot.net", "*.visualstudio.com", "*.local") and
  not user.id == "S-1-5-18" and
  /* Filter out NetBIOS/LLMNR-style names (e.g. host, localhost, etc.) */
  dns.question.name regex """.*\.[a-zA-Z]{2,5}"""]
[file where host.os.type == "windows" and event.type == "creation" and
  process.name : "powershell.exe" and 
  (file.extension : ("exe", "dll", "ps1", "bat") or file.Ext.header_bytes : "4d5a*") and
  not file.name : "__PSScriptPolicy*.ps1" and
  not file.path : (
        "?:\\Users\\*\\AppData\\Local\\Temp\\????????.dll",
        "?:\\Users\\*\\AppData\\Local\\Temp\\*\\????????.dll",
        "?:\\Windows\\TEMP\\ansible-tmp-*\\AnsiballZ*.ps1"
  ) and
  not user.id == "S-1-5-18"]
```

**Framework:** MITRE ATT&CK
- Tactic:
  - Name: Command and Control
- Id: TA0011
- Reference URL: [[https://attack.mitre.org/tactics/TA0011/](https://attack.mitre.org/tactics/TA0011/)](https://attack.mitre.org/tactics/TA0011/)
- Technique:
  - Name: Ingress Tool Transfer
- Id: T1105
- Reference URL: [[https://attack.mitre.org/techniques/T1105/](https://attack.mitre.org/techniques/T1105/)](https://attack.mitre.org/techniques/T1105/)

**Framework:** MITRE ATT&CK
- Tactic:
  - Name: Execution
- Id: TA0002
- Reference URL: [[https://attack.mitre.org/tactics/TA0002/](https://attack.mitre.org/tactics/TA0002/)](https://attack.mitre.org/tactics/TA0002/)
- Technique:
  - Name: Command and Scripting Interpreter
- Id: T1059
- Reference URL: [[https://attack.mitre.org/techniques/T1059/](https://attack.mitre.org/techniques/T1059/)](https://attack.mitre.org/techniques/T1059/)
- Sub Technique:
  - Name: PowerShell
- Id: T1059.001
- Reference URL: [[https://attack.mitre.org/techniques/T1059/001/](https://attack.mitre.org/techniques/T1059/001/)](https://attack.mitre.org/techniques/T1059/001/)