﻿---
title: Potential REMCOS Trojan Execution
description: Identifies known execution traces of the REMCOS Remote Access Trojan. Remcos RAT is used by attackers to perform actions on infected machines remotely...
url: https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/windows/command_and_control_remcos_rat_iocs
products:
  - Elastic Security
---

# Potential REMCOS Trojan Execution
Identifies known execution traces of the REMCOS Remote Access Trojan. Remcos RAT is used by attackers to perform actions on infected machines remotely.
**Rule type**: eql
**Rule indices**:
- endgame-*
- logs-endpoint.events.registry-*
- logs-endpoint.events.file-*
- logs-m365_defender.event-*
- logs-sentinel_one_cloud_funnel.*
- logs-system.security*
- logs-windows.sysmon_operational-*
- winlogbeat-*

**Rule Severity**: high
**Risk Score**: 73
**Runs every**: 
**Searches indices from**: `now-9m`
**Maximum alerts per execution**: 100
**References**:
- [[https://any.run/malware-trends/remcos](https://any.run/malware-trends/remcos)](https://any.run/malware-trends/remcos)
- [[https://attack.mitre.org/software/S0332/](https://attack.mitre.org/software/S0332/)](https://attack.mitre.org/software/S0332/)
- [[https://www.elastic.co/security-labs/exploring-the-ref2731-intrusion-set](https://www.elastic.co/security-labs/exploring-the-ref2731-intrusion-set)](https://www.elastic.co/security-labs/exploring-the-ref2731-intrusion-set)

**Tags**:
- Domain: Endpoint
- OS: Windows
- Use Case: Threat Detection
- Tactic: Command and Control
- Resources: Investigation Guide
- Data Source: Elastic Endgame
- Data Source: Elastic Defend
- Data Source: Sysmon
- Data Source: SentinelOne
- Data Source: Microsoft Defender for Endpoint
- Data Source: Windows Security Event Logs

**Version**: 1
**Rule authors**:
- Elastic

**Rule license**: Elastic License v2

## Investigation guide


## Triage and analysis


### Investigating Potential REMCOS Trojan Execution

Remcos RAT is used by attackers to perform actions on infected machines remotely.

### Possible investigation steps

- Review the origin of the REMCOS file and the execution chain to identify the initial vector..
- Examine if the process is set to persist in the affected system via scheduled task, Startup folder or Run key.
- Check the network, files and child processes activity associated with the every suspicious process in the execution chain of REMCOS.
- Correlate the event with other security alerts or logs from data sources like Elastic Defend or Microsoft Defender for Endpoint to gather additional context and identify any related malicious activities.


### Response and remediation

- Immediately isolate the affected system from the network to prevent further unauthorized access or lateral movement by the attacker.
- Terminate any suspicious processes identified in the alert, such as PowerShell, cmd.exe, or other flagged executables, to halt any ongoing malicious activity.
- Review and revoke any unauthorized user accounts or privileges that may have been created or modified using tools like net.exe or schtasks.exe.
- Conduct a thorough scan of the affected system using endpoint protection tools to identify and remove any malware or unauthorized software installed by the attacker.
- Restore the system from a known good backup if any critical system files or configurations have been altered or compromised.
- Escalate the incident to the security operations center (SOC) or incident response team for further investigation and to determine if additional systems are affected.
- Implement enhanced monitoring and logging for ScreenConnect and other remote access tools to detect similar activities in the future, ensuring that alerts are promptly reviewed and acted upon.


## Rule Query

```eql
any where host.os.type == "windows" and
(
 (event.category == "file" and event.type == "deletion" and file.path like "C:\\Users\\*\\AppData\\Local\\Temp\\TH????.tmp") or

 (event.category == "file" and file.path : "?:\\Users\\*\\AppData\\Roaming\\remcos\\logs.dat") or

 (event.category == "registry" and
  registry.value : ("Remcos", "Rmc-??????", "licence") and
  registry.path : (
      "*\\Windows\\CurrentVersion\\Run\\Remcos",
      "*\\Windows\\CurrentVersion\\Run\\Rmc-??????",
      "*\\SOFTWARE\\Remcos-*\\licence",
      "*\\Software\\Rmc-??????\\licence"
  )
 )
)
```

**Framework:** MITRE ATT&CK
- Tactic:
  - Name: Command and Control
- Id: TA0011
- Reference URL: [[https://attack.mitre.org/tactics/TA0011/](https://attack.mitre.org/tactics/TA0011/)](https://attack.mitre.org/tactics/TA0011/)
- Technique:
  - Name: Remote Access Tools
- Id: T1219
- Reference URL: [[https://attack.mitre.org/techniques/T1219/](https://attack.mitre.org/techniques/T1219/)](https://attack.mitre.org/techniques/T1219/)