﻿---
title: First Time Seen Commonly Abused Remote Access Tool Execution
description: Adversaries may install legitimate remote access tools (RAT) to compromised endpoints for further command-and-control (C2). Adversaries can rely on installed...
url: https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/windows/command_and_control_new_terms_commonly_abused_rat_execution
products:
  - Elastic Security
---

# First Time Seen Commonly Abused Remote Access Tool Execution
Adversaries may install legitimate remote access tools (RAT) to compromised endpoints for further command-and-control
(C2). Adversaries can rely on installed RATs for persistence, execution of native commands and more. This rule detects
when a process is started whose name or code signature resembles commonly abused RATs. This is a New Terms rule type
indicating the host has not seen this RAT process started before within the last 30 days.
**Rule type**: new_terms
**Rule indices**:
- logs-endpoint.events.process-*
- endgame-*
- winlogbeat-*
- logs-windows.forwarded*
- logs-windows.sysmon_operational-*
- logs-system.security*

**Rule Severity**: medium
**Risk Score**: 47
**Runs every**: 
**Searches indices from**: `now-9m`
**Maximum alerts per execution**: 100
**References**:
- [[https://thedfirreport.com/2023/04/03/malicious-iso-file-leads-to-domain-wide-ransomware/](https://thedfirreport.com/2023/04/03/malicious-iso-file-leads-to-domain-wide-ransomware/)](https://thedfirreport.com/2023/04/03/malicious-iso-file-leads-to-domain-wide-ransomware/)
- [[https://attack.mitre.org/techniques/T1219/](https://attack.mitre.org/techniques/T1219/)](https://attack.mitre.org/techniques/T1219/)
- [[https://github.com/redcanaryco/surveyor/blob/master/definitions/remote-admin.json](https://github.com/redcanaryco/surveyor/blob/master/definitions/remote-admin.json)](https://github.com/redcanaryco/surveyor/blob/master/definitions/remote-admin.json)

**Tags**:
- Domain: Endpoint
- OS: Windows
- Use Case: Threat Detection
- Tactic: Command and Control
- Resources: Investigation Guide
- Data Source: Elastic Defend
- Data Source: Elastic Endgame
- Data Source: Windows Security Event Logs
- Data Source: Sysmon

**Version**: 114
**Rule authors**:
- Elastic

**Rule license**: Elastic License v2

## Investigation guide


## Triage and analysis


### Investigating First Time Seen Commonly Abused Remote Access Tool Execution

Remote access software is a class of tools commonly used by IT departments to provide support by connecting securely to users' computers. Remote access is an ever-growing market where new companies constantly offer new ways of quickly accessing remote systems.
At the same pace as IT departments adopt these tools, the attackers also adopt them as part of their workflow to connect into an interactive session, maintain access with legitimate software as a persistence mechanism, drop malicious software, etc.
This rule detects when a remote access tool is seen in the environment for the first time in the last 15 days, enabling analysts to investigate and enforce the correct usage of such tools.

#### Possible investigation steps

- Investigate the process execution chain (parent process tree) for unknown processes. Examine their executable files for prevalence, whether they are located in expected locations, and if they are signed with valid digital signatures.
- Check if the execution of the remote access tool is approved by the organization's IT department.
- Investigate other alerts associated with the user/host during the past 48 hours.
- Contact the account owner and confirm whether they are aware of this activity.
  - If the tool is not approved for use in the organization, the employee could have been tricked into installing it and providing access to a malicious third party. Investigate whether this third party could be attempting to scam the end-user or gain access to the environment through social engineering.
- Investigate any abnormal behavior by the subject process, such as network connections, registry or file modifications, and any spawned child processes.


### False positive analysis

- If an authorized support person or administrator used the tool to conduct legitimate support or remote access, consider reinforcing that only tooling approved by the IT policy should be used. The analyst can dismiss the alert if no other suspicious behavior is observed involving the host or users.


### Response and remediation

- Initiate the incident response process based on the outcome of the triage.
- Isolate the involved host to prevent further post-compromise behavior.
- Run a full scan using the antimalware tool in place. This scan can reveal additional artifacts left in the system, persistence mechanisms, and malware components.
- Investigate credential exposure on systems compromised or used by the attacker to ensure all compromised accounts are identified. Reset passwords for these accounts and other potentially compromised credentials, such as email, business systems, and web services.
- If an unauthorized third party did the access via social engineering, consider improvements to the security awareness program.
- Enforce that only tooling approved by the IT policy should be used for remote access purposes and only by authorized staff.
- Using the incident response data, update logging and audit policies to improve the mean time to detect (MTTD) and the mean time to respond (MTTR).


## Rule Query

```kuery
host.os.type: "windows" and

   event.category: "process" and event.type : "start" and

    (
        process.code_signature.subject_name : (
            "Action1 Corporation" or
            "AeroAdmin LLC" or
            "Ammyy LLC" or
            "Atera Networks Ltd" or
            "AWERAY PTE. LTD." or
            "BeamYourScreen GmbH" or
            "Bomgar Corporation" or
            "DUC FABULOUS CO.,LTD" or
            "DOMOTZ INC." or
            "DWSNET OÜ" or
            "FleetDeck Inc" or
            "GlavSoft LLC" or
            "GlavSoft LLC." or
            "Hefei Pingbo Network Technology Co. Ltd" or
            "IDrive, Inc." or
            "IMPERO SOLUTIONS LIMITED" or
            "Instant Housecall" or
            "ISL Online Ltd." or
            "LogMeIn, Inc." or
            "Monitoring Client" or
            "MMSOFT Design Ltd." or
            "Nanosystems S.r.l." or
            "NetSupport Ltd" or
            "NetSupport Ltd." or
            "NETSUPPORT LTD." or
            "NinjaRMM, LLC" or
            "Parallels International GmbH" or
            "philandro Software GmbH" or
            "Pro Softnet Corporation" or
            "RealVNC" or
            "RealVNC Limited" or
            "BreakingSecurity.net" or
            "Remote Utilities LLC" or
            "Rocket Software, Inc." or
            "SAFIB" or
            "Servably, Inc." or
            "ShowMyPC INC" or
            "Splashtop Inc." or
            "Superops Inc." or
            "TeamViewer" or
            "TeamViewer GmbH" or
            "TeamViewer Germany GmbH" or
            "Techinline Limited" or
            "uvnc bvba" or
            "Yakhnovets Denis Aleksandrovich IP" or
            "Zhou Huabing" or
            "ZOHO Corporation Private Limited"
        ) or

        process.name.caseless : (
            AA_v*.exe or
            "AeroAdmin.exe" or
            "AnyDesk.exe" or
            "apc_Admin.exe" or
            "apc_host.exe" or
            "AteraAgent.exe" or
            aweray_remote*.exe or
            "AweSun.exe" or
            "B4-Service.exe" or
            "BASupSrvc.exe" or
            "bomgar-scc.exe" or
            "domotzagent.exe" or
            "domotz-windows-x64-10.exe" or
            "dwagsvc.exe" or
            "DWRCC.exe" or
            "ImperoClientSVC.exe" or
            "ImperoServerSVC.exe" or
            "ISLLight.exe" or
            "ISLLightClient.exe" or
            fleetdeck_commander*.exe or
            "getscreen.exe" or
            "LMIIgnition.exe" or
            "LogMeIn.exe" or
            "ManageEngine_Remote_Access_Plus.exe" or
            "Mikogo-Service.exe" or
            "NinjaRMMAgent.exe" or
            "NinjaRMMAgenPatcher.exe" or
            "ninjarmm-cli.exe" or
            "r_server.exe" or
            "radmin.exe" or
            "radmin3.exe" or
            "RCClient.exe" or
            "RCService.exe" or
            "RemoteDesktopManager.exe" or
            "RemotePC.exe" or
            "RemotePCDesktop.exe" or
            "RemotePCService.exe" or
            "rfusclient.exe" or
            "ROMServer.exe" or
            "ROMViewer.exe" or
            "RPCSuite.exe" or
            "rserver3.exe" or
            "rustdesk.exe" or
            "rutserv.exe" or
            "rutview.exe" or
            "saazapsc.exe" or
            ScreenConnect*.exe or
            "smpcview.exe" or
            "spclink.exe" or
            "Splashtop-streamer.exe" or
            "SRService.exe" or
            "strwinclt.exe" or
            "Supremo.exe" or
            "SupremoService.exe" or
            "teamviewer.exe" or
            "TiClientCore.exe" or
            "TSClient.exe" or
            "tvn.exe" or
            "tvnserver.exe" or
            "tvnviewer.exe" or
            UltraVNC*.exe or
            UltraViewer*.exe or
            "vncserver.exe" or
            "vncviewer.exe" or
            "winvnc.exe" or
            "winwvc.exe" or
            "Zaservice.exe" or
            "ZohoURS.exe" or
            "Velociraptor.exe" or
            "ToolsIQ.exe"
        ) or
        process.name : (
            AA_v*.exe or
            "AeroAdmin.exe" or
            "AnyDesk.exe" or
            "apc_Admin.exe" or
            "apc_host.exe" or
            "AteraAgent.exe" or
            aweray_remote*.exe or
            "AweSun.exe" or
            "B4-Service.exe" or
            "BASupSrvc.exe" or
            "bomgar-scc.exe" or
            "domotzagent.exe" or
            "domotz-windows-x64-10.exe" or
            "dwagsvc.exe" or
            "DWRCC.exe" or
            "ImperoClientSVC.exe" or
            "ImperoServerSVC.exe" or
            "ISLLight.exe" or
            "ISLLightClient.exe" or
            fleetdeck_commander*.exe or
            "getscreen.exe" or
            "LMIIgnition.exe" or
            "LogMeIn.exe" or
            "ManageEngine_Remote_Access_Plus.exe" or
            "Mikogo-Service.exe" or
            "NinjaRMMAgent.exe" or
            "NinjaRMMAgenPatcher.exe" or
            "ninjarmm-cli.exe" or
            "r_server.exe" or
            "radmin.exe" or
            "radmin3.exe" or
            "RCClient.exe" or
            "RCService.exe" or
            "RemoteDesktopManager.exe" or
            "RemotePC.exe" or
            "RemotePCDesktop.exe" or
            "RemotePCService.exe" or
            "rfusclient.exe" or
            "ROMServer.exe" or
            "ROMViewer.exe" or
            "RPCSuite.exe" or
            "rserver3.exe" or
            "rustdesk.exe" or
            "rutserv.exe" or
            "rutview.exe" or
            "saazapsc.exe" or
            ScreenConnect*.exe or
            "smpcview.exe" or
            "spclink.exe" or
            "Splashtop-streamer.exe" or
            "SRService.exe" or
            "strwinclt.exe" or
            "Supremo.exe" or
            "SupremoService.exe" or
            "teamviewer.exe" or
            "TiClientCore.exe" or
            "TSClient.exe" or
            "tvn.exe" or
            "tvnserver.exe" or
            "tvnviewer.exe" or
            UltraVNC*.exe or
            UltraViewer*.exe or
            "vncserver.exe" or
            "vncviewer.exe" or
            "winvnc.exe" or
            "winwvc.exe" or
            "Zaservice.exe" or
            "ZohoURS.exe" or
            "Velociraptor.exe" or
            "ToolsIQ.exe"
        )
	) and

	not (process.pe.original_file_name : ("G2M.exe" or "Updater.exe" or "powershell.exe") and process.code_signature.subject_name : "LogMeIn, Inc.")
```

**Framework:** MITRE ATT&CK
- Tactic:
  - Name: Command and Control
- Id: TA0011
- Reference URL: [[https://attack.mitre.org/tactics/TA0011/](https://attack.mitre.org/tactics/TA0011/)](https://attack.mitre.org/tactics/TA0011/)
- Technique:
  - Name: Remote Access Tools
- Id: T1219
- Reference URL: [[https://attack.mitre.org/techniques/T1219/](https://attack.mitre.org/techniques/T1219/)](https://attack.mitre.org/techniques/T1219/)