﻿---
title: Potential Command and Control via Internet Explorer
description: Identifies instances of Internet Explorer (iexplore.exe) being started via the Component Object Model (COM) making unusual network connections. Adversaries...
url: https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/windows/command_and_control_iexplore_via_com
products:
  - Elastic Security
---

# Potential Command and Control via Internet Explorer
Identifies instances of Internet Explorer (iexplore.exe) being started via the Component Object Model (COM) making
unusual network connections. Adversaries could abuse Internet Explorer via COM to avoid suspicious processes making
network connections and bypass host-based firewall restrictions.
**Rule type**: eql
**Rule indices**:
- logs-endpoint.events.library-*
- logs-endpoint.events.process-*
- logs-endpoint.events.network-*

**Rule Severity**: medium
**Risk Score**: 47
**Runs every**: 
**Searches indices from**: `now-9m`
**Maximum alerts per execution**: 100
**References**:
**Tags**:
- Domain: Endpoint
- OS: Windows
- Use Case: Threat Detection
- Tactic: Command and Control
- Data Source: Elastic Defend
- Resources: Investigation Guide

**Version**: 109
**Rule authors**:
- Elastic

**Rule license**: Elastic License v2

## Investigation guide


## Triage and analysis> **Disclaimer**:
This investigation guide was created using generative AI technology and has been reviewed to improve its accuracy and relevance. While every effort has been made to ensure its quality, we recommend validating the content and adapting it to suit your specific environment and operational needs.

### Investigating Potential Command and Control via Internet Explorer

Internet Explorer can be manipulated via the Component Object Model (COM) to initiate network connections, potentially bypassing security measures. Adversaries exploit this by embedding IE in processes like rundll32.exe, making it appear benign. The detection rule identifies unusual DNS queries from IE, excluding common Microsoft domains, to flag suspicious activity indicative of command and control attempts.

### Possible investigation steps

- Review the alert details to identify the specific host and user associated with the suspicious activity, focusing on the host.id and user.name fields.
- Examine the process tree on the affected host to confirm if Internet Explorer (iexplore.exe) was indeed started via COM, specifically looking for the parent process rundll32.exe or regsvr32.exe with IEProxy.dll loaded.
- Analyze the DNS queries made by Internet Explorer to identify any unusual or suspicious domains that are not part of the common Microsoft or OCSP-related domains listed in the exclusion list.
- Check the network connections initiated by Internet Explorer to determine if there are any unexpected or unauthorized external IP addresses or domains being contacted.
- Investigate the context and timing of the alert by correlating it with other security events or logs from the same host or user to identify any patterns or additional indicators of compromise.
- Assess the risk and potential impact of the detected activity by considering the severity of the alert and any additional findings from the investigation steps above.


### False positive analysis

- Internet Explorer may make legitimate DNS queries to domains not listed in the exclusion list, such as those related to third-party services or internal company resources. Users should monitor and identify these domains and consider adding them to the exclusion list if they are verified as non-threatening.
- Some enterprise environments may use custom applications that leverage Internet Explorer via COM for legitimate purposes. In such cases, users should identify these applications and create exceptions for their associated processes to prevent false positives.
- Regular updates or patches from non-Microsoft sources might trigger alerts if they use Internet Explorer for network connections. Users should verify the legitimacy of these updates and adjust the exclusion list accordingly.
- Internal network monitoring tools or scripts that use Internet Explorer for testing or monitoring purposes could be flagged. Users should document these tools and exclude their associated network activities from the detection rule.
- If a specific user or department frequently triggers alerts due to legitimate use of Internet Explorer, consider creating user or department-specific exceptions to reduce noise while maintaining security oversight.


### Response and remediation

- Isolate the affected host from the network immediately to prevent further command and control communication and potential data exfiltration.
- Terminate the Internet Explorer process (iexplore.exe) and any associated processes like rundll32.exe or regsvr32.exe that are identified as suspicious.
- Conduct a thorough scan of the isolated host using updated antivirus and anti-malware tools to identify and remove any malicious software or scripts.
- Review and analyze the DNS query logs to identify any other potentially compromised hosts within the network that may have communicated with the same suspicious domains.
- Restore the affected system from a known good backup if malware is confirmed and cannot be fully removed, ensuring that the backup is free from compromise.
- Implement network-level controls to block the identified suspicious domains and IP addresses to prevent future communication attempts.
- Escalate the incident to the security operations center (SOC) or incident response team for further investigation and to determine if additional systems are affected.


## Rule Query

```eql
sequence by host.id, user.name with maxspan = 5s
  [library where host.os.type == "windows" and dll.name : "IEProxy.dll" and process.name : ("rundll32.exe", "regsvr32.exe")]
  [process where host.os.type == "windows" and event.type == "start" and process.parent.name : "iexplore.exe" and process.parent.args : "-Embedding"]
  /* IE started via COM in normal conditions makes few connections, mainly to Microsoft and OCSP related domains, add FPs here */
  [network where host.os.type == "windows" and network.protocol == "dns" and process.name : "iexplore.exe" and
   not dns.question.name :
   (
    "*.microsoft.com",
    "*.digicert.com",
    "*.msocsp.com",
    "*.windowsupdate.com",
    "*.bing.com",
    "*.identrust.com",
    "*.sharepoint.com",
    "*.office365.com",
    "*.office.com"
    )
  ] /* with runs=5 */
```

**Framework:** MITRE ATT&CK
- Tactic:
  - Name: Command and Control
- Id: TA0011
- Reference URL: [[https://attack.mitre.org/tactics/TA0011/](https://attack.mitre.org/tactics/TA0011/)](https://attack.mitre.org/tactics/TA0011/)
- Technique:
  - Name: Application Layer Protocol
- Id: T1071
- Reference URL: [[https://attack.mitre.org/techniques/T1071/](https://attack.mitre.org/techniques/T1071/)](https://attack.mitre.org/techniques/T1071/)

**Framework:** MITRE ATT&CK
- Tactic:
  - Name: Execution
- Id: TA0002
- Reference URL: [[https://attack.mitre.org/tactics/TA0002/](https://attack.mitre.org/tactics/TA0002/)](https://attack.mitre.org/tactics/TA0002/)
- Technique:
  - Name: Inter-Process Communication
- Id: T1559
- Reference URL: [[https://attack.mitre.org/techniques/T1559/](https://attack.mitre.org/techniques/T1559/)](https://attack.mitre.org/techniques/T1559/)
- Sub Technique:
  - Name: Component Object Model
- Id: T1559.001
- Reference URL: [[https://attack.mitre.org/techniques/T1559/001/](https://attack.mitre.org/techniques/T1559/001/)](https://attack.mitre.org/techniques/T1559/001/)