﻿---
title: Connection to Commonly Abused Free SSL Certificate Providers
description: Identifies unusual processes connecting to domains using known free SSL certificates. Adversaries may employ a known encryption algorithm to conceal command...
url: https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/windows/command_and_control_encrypted_channel_freesslcert
products:
  - Elastic Security
---

# Connection to Commonly Abused Free SSL Certificate Providers
Identifies unusual processes connecting to domains using known free SSL certificates. Adversaries may employ a known
encryption algorithm to conceal command and control traffic.
**Rule type**: eql
**Rule indices**:
- winlogbeat-*
- logs-endpoint.events.network-*
- logs-windows.sysmon_operational-*

**Rule Severity**: low
**Risk Score**: 21
**Runs every**: 
**Searches indices from**: `now-9m`
**Maximum alerts per execution**: 100
**References**:
**Tags**:
- Domain: Endpoint
- OS: Windows
- Use Case: Threat Detection
- Tactic: Command and Control
- Data Source: Elastic Defend
- Data Source: Sysmon
- Resources: Investigation Guide

**Version**: 210
**Rule authors**:
- Elastic

**Rule license**: Elastic License v2

## Setup

If enabling an EQL rule on a non-elastic-agent index (such as beats) for versions <8.2,
events will not define `event.ingested` and default fallback for EQL rules was not added until version 8.2.
Hence for this rule to work effectively, users will need to add a custom ingest pipeline to populate
`event.ingested` to @timestamp.
For more details on adding a custom ingest pipeline refer - [https://www.elastic.co/guide/en/fleet/current/data-streams-pipeline-tutorial.html](https://www.elastic.co/guide/en/fleet/current/data-streams-pipeline-tutorial.html)

## Investigation guide


## Triage and analysis> **Disclaimer**:
This investigation guide was created using generative AI technology and has been reviewed to improve its accuracy and relevance. While every effort has been made to ensure its quality, we recommend validating the content and adapting it to suit your specific environment and operational needs.

### Investigating Connection to Commonly Abused Free SSL Certificate Providers

Free SSL certificates, like those from Let's Encrypt, enable secure web traffic encryption. Adversaries exploit these to mask malicious command and control (C2) communications. The detection rule identifies unusual Windows processes accessing domains with such certificates, excluding common false positives, to flag potential misuse of encrypted channels for C2 activities.

### Possible investigation steps

- Review the process executable path to confirm if it is a native Windows process and assess the legitimacy of its network activity. Focus on paths like "C:\Windows\System32*.exe" and "C:\Windows\SysWOW64*.exe".
- Investigate the specific domain accessed by the process, such as those ending in "*.letsencrypt.org" or "*.sslforfree.com", to determine if it is associated with known malicious activity or if it is a legitimate service.
- Check the process name against the list of excluded false positives, ensuring it is not "svchost.exe", "MicrosoftEdge*.exe", or "msedge.exe", which are common and typically benign.
- Analyze the network traffic associated with the process to identify any unusual patterns or anomalies that could indicate command and control activity.
- Correlate the alert with other security events or logs from the same host to identify any additional indicators of compromise or related suspicious activities.


### False positive analysis

- Windows system processes like svchost.exe and MicrosoftEdge.exe are common false positives due to their legitimate network activities. These can be excluded from the detection rule to reduce noise.
- Regularly update the list of excluded processes to include any new system processes that are verified to have legitimate reasons for accessing domains with free SSL certificates.
- Monitor and analyze network traffic patterns to identify any additional processes that consistently generate false positives, and consider adding them to the exclusion list if they are deemed non-threatening.
- Use process whitelisting to allow known safe applications that frequently access these domains, ensuring they do not trigger alerts unnecessarily.
- Implement a review process to periodically reassess the exclusion list, ensuring it remains relevant and does not inadvertently allow malicious activities to go undetected.


### Response and remediation

- Isolate the affected system from the network to prevent further malicious communication and potential lateral movement.
- Terminate any suspicious processes identified in the alert that are not typically associated with network activity, such as those running from unusual paths or with unexpected network connections.
- Conduct a thorough review of the system's recent activity logs to identify any unauthorized changes or additional indicators of compromise.
- Remove any malicious files or executables found on the system, ensuring that all remnants of the threat are eradicated.
- Restore the system from a known good backup if any critical system files or configurations have been altered.
- Update and patch the system to the latest security standards to close any vulnerabilities that may have been exploited.
- Escalate the incident to the security operations center (SOC) or incident response team for further investigation and to determine if additional systems are affected.


## Rule Query

```eql
network where host.os.type == "windows" and network.protocol == "dns" and
  /* Add new free SSL certificate provider domains here */
  dns.question.name : ("*letsencrypt.org", "*.sslforfree.com", "*.zerossl.com", "*.freessl.org") and

  /* Native Windows process paths that are unlikely to have network connections to domains secured using free SSL certificates */
  process.executable : ("C:\\Windows\\System32\\*.exe",
                        "C:\\Windows\\System\\*.exe",
	                  "C:\\Windows\\SysWOW64\\*.exe",
		          "C:\\Windows\\Microsoft.NET\\Framework*\\*.exe",
		          "C:\\Windows\\explorer.exe",
		          "C:\\Windows\\notepad.exe") and

  /* Insert noisy false positives here */
  not process.name : ("svchost.exe", "MicrosoftEdge*.exe", "msedge.exe")
```

**Framework:** MITRE ATT&CK
- Tactic:
  - Name: Command and Control
- Id: TA0011
- Reference URL: [[https://attack.mitre.org/tactics/TA0011/](https://attack.mitre.org/tactics/TA0011/)](https://attack.mitre.org/tactics/TA0011/)
- Technique:
  - Name: Encrypted Channel
- Id: T1573
- Reference URL: [[https://attack.mitre.org/techniques/T1573/](https://attack.mitre.org/techniques/T1573/)](https://attack.mitre.org/techniques/T1573/)