﻿---
title: Potential DNS Tunneling via NsLookup
description: This rule identifies a large number (15) of nslookup.exe executions with an explicit query type from the same host. This may indicate command and control...
url: https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/windows/command_and_control_dns_tunneling_nslookup
products:
  - Elastic Security
---

# Potential DNS Tunneling via NsLookup
This rule identifies a large number (15) of nslookup.exe executions with an explicit query type from the same host. This
may indicate command and control activity utilizing the DNS protocol.
**Rule type**: eql
**Rule indices**:
- endgame-*
- logs-endpoint.events.process-*
- logs-m365_defender.event-*
- logs-sentinel_one_cloud_funnel.*
- logs-system.security*
- logs-windows.forwarded*
- logs-windows.sysmon_operational-*
- winlogbeat-*

**Rule Severity**: medium
**Risk Score**: 47
**Runs every**: 
**Searches indices from**: `now-9m`
**Maximum alerts per execution**: 100
**References**:
- [[https://unit42.paloaltonetworks.com/dns-tunneling-in-the-wild-overview-of-oilrigs-dns-tunneling/](https://unit42.paloaltonetworks.com/dns-tunneling-in-the-wild-overview-of-oilrigs-dns-tunneling/)](https://unit42.paloaltonetworks.com/dns-tunneling-in-the-wild-overview-of-oilrigs-dns-tunneling/)

**Tags**:
- Domain: Endpoint
- OS: Windows
- Use Case: Threat Detection
- Tactic: Command and Control
- Resources: Investigation Guide
- Data Source: Elastic Endgame
- Data Source: Elastic Defend
- Data Source: Windows Security Event Logs
- Data Source: Microsoft Defender for Endpoint
- Data Source: SentinelOne
- Data Source: Sysmon

**Version**: 314
**Rule authors**:
- Elastic

**Rule license**: Elastic License v2

## Investigation guide


## Triage and analysis


### Investigating Potential DNS Tunneling via NsLookup

Attackers can abuse existing network rules that allow DNS communication with external resources to use the protocol as their command and control and/or exfiltration channel.
DNS queries can be used to infiltrate data such as commands to be run, malicious files, etc., and also for exfiltration, since queries can be used to send data to the attacker-controlled DNS server. This process is commonly known as DNS tunneling.
More information on how tunneling works and how it can be abused can be found on [Palo Alto Unit42 Research](https://unit42.paloaltonetworks.com/dns-tunneling-how-dns-can-be-abused-by-malicious-actors).

#### Possible investigation steps

- Investigate the script execution chain (parent process tree) for unknown processes. Examine their executable files for prevalence, whether they are located in expected locations, and if they are signed with valid digital signatures.
- Investigate other alerts associated with the user/host during the past 48 hours.
- Inspect the DNS query and identify the information sent.
- Extract this communication's indicators of compromise (IoCs) and use traffic logs to search for other potentially compromised hosts.


### False positive analysis

- This mechanism can be used legitimately. If the parent process is trusted and the data sent is not sensitive nor command and control related, this alert can be closed.


### Response and remediation

- Initiate the incident response process based on the outcome of the triage.
- Isolate the involved host to prevent further post-compromise behavior.
- Immediately block the identified indicators of compromise (IoCs).
- Implement any temporary network rules, procedures, and segmentation required to contain the attack.
- Investigate credential exposure on systems compromised or used by the attacker to ensure all compromised accounts are identified. Reset passwords for these accounts and other potentially compromised credentials, such as email, business systems, and web services.
- Update firewall rules to be more restrictive.
- Reimage the host operating system or restore the compromised files to clean versions.
- Run a full antimalware scan. This may reveal additional artifacts left in the system, persistence mechanisms, and malware components.
- Determine the initial vector abused by the attacker and take action to prevent reinfection through the same vector.
- Using the incident response data, update logging and audit policies to improve the mean time to detect (MTTD) and the mean time to respond (MTTR).


## Rule Query

```eql
sequence by host.id with maxspan=5m
[process where host.os.type == "windows" and event.type == "start" and
  process.name : "nslookup.exe" and process.args:("-querytype=*", "-qt=*", "-q=*", "-type=*")] with runs = 10
```

**Framework:** MITRE ATT&CK
- Tactic:
  - Name: Command and Control
- Id: TA0011
- Reference URL: [[https://attack.mitre.org/tactics/TA0011/](https://attack.mitre.org/tactics/TA0011/)](https://attack.mitre.org/tactics/TA0011/)
- Technique:
  - Name: Application Layer Protocol
- Id: T1071
- Reference URL: [[https://attack.mitre.org/techniques/T1071/](https://attack.mitre.org/techniques/T1071/)](https://attack.mitre.org/techniques/T1071/)
- Sub Technique:
  - Name: DNS
- Id: T1071.004
- Reference URL: [[https://attack.mitre.org/techniques/T1071/004/](https://attack.mitre.org/techniques/T1071/004/)](https://attack.mitre.org/techniques/T1071/004/)
- Technique:
  - Name: Protocol Tunneling
- Id: T1572
- Reference URL: [[https://attack.mitre.org/techniques/T1572/](https://attack.mitre.org/techniques/T1572/)](https://attack.mitre.org/techniques/T1572/)