﻿---
title: Connection to Commonly Abused Web Services
description: Adversaries may implement command and control (C2) communications that use common web services to hide their activity. This attack technique is typically...
url: https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/windows/command_and_control_common_webservices
products:
  - Elastic Security
---

# Connection to Commonly Abused Web Services
Adversaries may implement command and control (C2) communications that use common web services to hide their activity.
This attack technique is typically targeted at an organization and uses web services common to the victim network, which
allows the adversary to blend into legitimate traffic activity. These popular services are typically targeted since they
have most likely been used before compromise, which helps malicious traffic blend in.
**Rule type**: eql
**Rule indices**:
- logs-endpoint.events.network-*
- logs-sentinel_one_cloud_funnel.*

**Rule Severity**: low
**Risk Score**: 21
**Runs every**: 
**Searches indices from**: `now-9m`
**Maximum alerts per execution**: 100
**References**:
- [[https://www.elastic.co/security-labs/operation-bleeding-bear](https://www.elastic.co/security-labs/operation-bleeding-bear)](https://www.elastic.co/security-labs/operation-bleeding-bear)
- [[https://www.elastic.co/security-labs/siestagraph-new-implant-uncovered-in-asean-member-foreign-ministry](https://www.elastic.co/security-labs/siestagraph-new-implant-uncovered-in-asean-member-foreign-ministry)](https://www.elastic.co/security-labs/siestagraph-new-implant-uncovered-in-asean-member-foreign-ministry)
- [[https://specterops.io/blog/2026/01/30/weaponizing-whitelists-an-azure-blob-storage-mythic-c2-profile/](https://specterops.io/blog/2026/01/30/weaponizing-whitelists-an-azure-blob-storage-mythic-c2-profile/)](https://specterops.io/blog/2026/01/30/weaponizing-whitelists-an-azure-blob-storage-mythic-c2-profile/)

**Tags**:
- Domain: Endpoint
- OS: Windows
- Use Case: Threat Detection
- Tactic: Command and Control
- Resources: Investigation Guide
- Data Source: Elastic Defend
- Data Source: SentinelOne

**Version**: 126
**Rule authors**:
- Elastic

**Rule license**: Elastic License v2

## Investigation guide


## Triage and analysis


### Investigating Connection to Commonly Abused Web Services

Adversaries may use an existing, legitimate external Web service as a means for relaying data to/from a compromised system. Popular websites and social media acting as a mechanism for C2 may give a significant amount of cover due to the likelihood that hosts within a network are already communicating with them prior to a compromise.
This rule looks for processes outside known legitimate program locations communicating with a list of services that can be abused for exfiltration or command and control.> **Note**:
This investigation guide uses the [Osquery Markdown Plugin](https://www.elastic.co/guide/en/security/current/invest-guide-run-osquery.html) introduced in Elastic Stack version 8.5.0. Older Elastic Stack versions will display unrendered Markdown in this guide.
This investigation guide uses the [Investigate Markdown Plugin](https://www.elastic.co/guide/en/security/current/interactive-investigation-guides.html) introduced in Elastic Stack version 8.8.0. Older Elastic Stack versions will display unrendered Markdown in this guide.

#### Possible investigation steps

- Investigate the process execution chain (parent process tree) for unknown processes. Examine their executable files for prevalence, whether they are located in expected locations, and if they are signed with valid digital signatures.
- Investigate other alerts associated with the user/host during the past 48 hours.
  - $investigate_0
- $investigate_1
- Verify whether the digital signature exists in the executable.
- Identify the operation type (upload, download, tunneling, etc.).
- Examine the host for derived artifacts that indicate suspicious activities:
  - Analyze the process executable using a private sandboxed analysis system.
- Observe and collect information about the following activities in both the sandbox and the alert subject host:
  - Attempts to contact external domains and addresses.
  - Use the Elastic Defend network events to determine domains and addresses contacted by the subject process by filtering by the process' `process.entity_id`.
  - $investigate_2
- Examine the DNS cache for suspicious or anomalous entries.
  - $osquery_0
- Use the Elastic Defend registry events to examine registry keys accessed, modified, or created by the related processes in the process tree.
- Examine the host services for suspicious or anomalous entries.
  - $osquery_1
- $osquery_2
- $osquery_3
- Retrieve the files' SHA-256 hash values using the PowerShell `Get-FileHash` cmdlet and search for the existence and reputation of the hashes in resources like VirusTotal, Hybrid-Analysis, CISCO Talos, Any.run, etc.


### False positive analysis

- This rule has a high chance to produce false positives because it detects communication with legitimate services. Noisy false positives can be added as exceptions.


### Response and remediation

- Initiate the incident response process based on the outcome of the triage.
- Isolate the involved host to prevent further post-compromise behavior.
- If the triage identified malware, search the environment for additional compromised hosts.
  - Implement temporary network rules, procedures, and segmentation to contain the malware.
- Stop suspicious processes.
- Immediately block the identified indicators of compromise (IoCs).
- Inspect the affected systems for additional malware backdoors like reverse shells, reverse proxies, or droppers that attackers could use to reinfect the system.
- Remove and block malicious artifacts identified during triage.
- Run a full antimalware scan. This may reveal additional artifacts left in the system, persistence mechanisms, and malware components.
- Determine the initial vector abused by the attacker and take action to prevent reinfection through the same vector.
- Using the incident response data, update logging and audit policies to improve the mean time to detect (MTTD) and the mean time to respond (MTTR).


## Rule Query

```eql
network where host.os.type == "windows" and
    dns.question.name != null and process.name != null and
    not (?user.id in ("S-1-5-18", "S-1-5-19", "S-1-5-20") or user.domain == "NT AUTHORITY") and
    /* Add new WebSvc domains here */
    dns.question.name :
       (
        "raw.githubusercontent.*",
        "pastebin.*",
        "paste4btc.com",
        "paste.ee",
        "ghostbin.com",
        "drive.google.com",
        "?.docs.live.net",
        "api.dropboxapi.*",
        "content.dropboxapi.*",
        "dl.dropboxusercontent.*",
        "api.onedrive.com",
        "*.onedrive.org",
        "onedrive.live.com",
        "filebin.net",
        "*.ngrok.io",
        "ngrok.com",
        "*.portmap.*",
        "*serveo.net",
        "*localtunnel.me",
        "*pagekite.me",
        "*localxpose.io",
        "*notabug.org",
        "rawcdn.githack.*",
        "paste.nrecom.net",
        "zerobin.net",
        "controlc.com",
        "requestbin.net",
        "slack.com",
        "api.slack.com",
        "slack-redir.net",
        "slack-files.com",
        "cdn.discordapp.com",
        "discordapp.com",
        "discord.com",
        "apis.azureedge.net",
        "cdn.sql.gg",
        "?.top4top.io",
        "top4top.io",
        "www.uplooder.net",
        "*.cdnmegafiles.com",
        "transfer.sh",
        "gofile.io",
        "updates.peer2profit.com",
        "api.telegram.org",
        "t.me",
        "meacz.gq",
        "rwrd.org",
        "*.publicvm.com",
        "*.blogspot.com",
        "api.mylnikov.org",
        "file.io",
        "stackoverflow.com",
        "*files.1drv.com",
        "api.anonfile.com",
        "*hosting-profi.de",
        "ipbase.com",
        "ipfs.io",
        "*up.freeo*.space",
        "api.mylnikov.org",
        "script.google.com",
        "script.googleusercontent.com",
        "api.notion.com",
        "graph.microsoft.com",
        "*.sharepoint.com",
        "mbasic.facebook.com",
        "login.live.com",
        "api.gofile.io",
        "api.anonfiles.com",
        "api.notion.com",
        "api.trello.com",
        "gist.githubusercontent.com",
        "files.pythonhosted.org",
        "g.live.com",
        "*.zulipchat.com",
        "webhook.site",
        "run.mocky.io",
        "mockbin.org", 
        "www.googleapis.com", 
        "googleapis.com",
        "global.rel.tunnels.api.visualstudio.com",
        "*.devtunnels.ms",
        "api.github.com",
        "*.blob.core.windows.net",
        "*.blob.storage.azure.net",
        "files.catbox.moe",
        "*.supabase.co", 
        "*.elastic-cloud.com",
        "*.cloud.es.io") and
        
    /* Insert noisy false positives here */
    not (
      (
        process.executable : (
          "?:\\Program Files\\*.exe",
          "?:\\Program Files (x86)\\*.exe",
          "?:\\ProgramData\\Microsoft\\Windows Defender\\Platform\\*\\MsMpEng.exe",
          "?:\\Users\\*\\AppData\\Local\\BraveSoftware\\*\\Application\\brave.exe",
          "?:\\Users\\*\\AppData\\Local\\Google\\Chrome\\Application\\chrome.exe",
          "?:\\Users\\*\\AppData\\Local\\Microsoft\\OneDrive\\OneDrive.exe",
          "?:\\Users\\*\\AppData\\Local\\Programs\\Opera*\\opera.exe",
          "?:\\Users\\*\\AppData\\Local\\Programs\\Fiddler\\Fiddler.exe",
          "?:\\Users\\*\\AppData\\Local\\PowerToys\\PowerToys.exe",
          "?:\\Users\\*\\AppData\\Local\\Vivaldi\\Application\\vivaldi.exe",
          "?:\\Users\\*\\AppData\\Local\\Zen Browser\\zen.exe",
          "?:\\Users\\*\\Wavesor Software\\WaveBrowser\\wavebrowser.exe",
          "?:\\Windows\\System32\\MicrosoftEdgeCP.exe",
          "?:\\Windows\\system32\\mobsync.exe",
          "?:\\Windows\\SysWOW64\\mobsync.exe", 
          "?:\\Windows\\system32\\svchost.exe",
          "?:\\Windows\\System32\\smartscreen.exe",
          "?:\\Windows\\System32\\wsl.exe", 
          "?:\\Windows\\System32\\WWAHost.exe"
        )
      ) or
    
      /* Discord App */
      (process.name : "Discord.exe" and (process.code_signature.subject_name : "Discord Inc." and
       process.code_signature.trusted == true) and dns.question.name : ("discord.com", "cdn.discordapp.com", "discordapp.com")
      ) or 

      /* MS Sharepoint / OneDrive */
      (process.name : ("Microsoft.SharePoint.exe", "OneDrive.Sync.Service.exe") and dns.question.name : "onedrive.live.com" and
       (process.code_signature.subject_name : "Microsoft Corporation" and process.code_signature.trusted == true)
      ) or 

      /* Obsidian - Plugins are stored on raw.githubusercontent.com */
      (process.name : "Obsidian.exe" and (process.code_signature.subject_name : "Dynalist Inc" and
       process.code_signature.trusted == true) and dns.question.name : "raw.githubusercontent.com"
      ) or 

      /* WebExperienceHostApp */
      (process.name : "WebExperienceHostApp.exe" and (process.code_signature.subject_name : "Microsoft Windows" and
       process.code_signature.trusted == true) and dns.question.name : ("onedrive.live.com", "skyapi.onedrive.live.com")
      ) or

      /* IntelliJ IDEA connecting to raw.githubusercontent.com */
      (process.code_signature.subject_name : "JetBrains s.r.o." and
       process.code_signature.trusted == true and dns.question.name : ("api.github.com", "raw.githubusercontent.com")
      ) or 

      (process.code_signature.subject_name : "Microsoft *" and process.code_signature.trusted == true and
       dns.question.name : ("*.sharepoint.com", "graph.microsoft.com", "g.live.com", "login.live.com",
                            "*.blob.core.windows.net", "*.blob.storage.azure.net")
      ) or

      (process.code_signature.subject_name : ("Python Software Foundation", "Anaconda, Inc.") and
       process.code_signature.trusted == true and dns.question.name : "files.pythonhosted.org"
      ) or

      /* Zoom */
      (process.name : "Zoom.exe" and (
       process.code_signature.subject_name : ("Zoom Video Communications, Inc.", "Zoom Communications, Inc.") and
       process.code_signature.trusted == true) and dns.question.name : ("www.googleapis.com", "graph.microsoft.com")
      ) or

      /* VSCode */
      (process.name : "Code.exe" and (process.code_signature.subject_name : "Microsoft Corporation" and
       process.code_signature.trusted == true) and dns.question.name : ("api.github.com", "raw.githubusercontent.com")
      ) or

      /* Terraform */
      (process.name : "terraform-provider*.exe" and (process.code_signature.subject_name : "HashiCorp, Inc." and
       process.code_signature.trusted == true) and dns.question.name : "graph.microsoft.com"
      ) or

      (
        process.code_signature.trusted == true and
        process.code_signature.subject_name : (
                              "Johannes Schindelin",
                              "Redis Inc.",
                              "Slack Technologies, LLC",
                              "Cisco Systems, Inc.",
                              "Dropbox, Inc",
                              "Amazon.com Services LLC", 
                              "Island Technology Inc.", 
                              "GitHub, Inc.", 
                              "Red Hat, Inc",
                              "Mozilla Corporation"
        )
      )
    )
```

**Framework:** MITRE ATT&CK
- Tactic:
  - Name: Command and Control
- Id: TA0011
- Reference URL: [[https://attack.mitre.org/tactics/TA0011/](https://attack.mitre.org/tactics/TA0011/)](https://attack.mitre.org/tactics/TA0011/)
- Technique:
  - Name: Web Service
- Id: T1102
- Reference URL: [[https://attack.mitre.org/techniques/T1102/](https://attack.mitre.org/techniques/T1102/)](https://attack.mitre.org/techniques/T1102/)
- Technique:
  - Name: Dynamic Resolution
- Id: T1568
- Reference URL: [[https://attack.mitre.org/techniques/T1568/](https://attack.mitre.org/techniques/T1568/)](https://attack.mitre.org/techniques/T1568/)
- Sub Technique:
  - Name: Domain Generation Algorithms
- Id: T1568.002
- Reference URL: [[https://attack.mitre.org/techniques/T1568/002/](https://attack.mitre.org/techniques/T1568/002/)](https://attack.mitre.org/techniques/T1568/002/)
- Technique:
  - Name: Proxy
- Id: T1090
- Reference URL: [[https://attack.mitre.org/techniques/T1090/](https://attack.mitre.org/techniques/T1090/)](https://attack.mitre.org/techniques/T1090/)
- Sub Technique:
  - Name: External Proxy
- Id: T1090.002
- Reference URL: [[https://attack.mitre.org/techniques/T1090/002/](https://attack.mitre.org/techniques/T1090/002/)](https://attack.mitre.org/techniques/T1090/002/)

**Framework:** MITRE ATT&CK
- Tactic:
  - Name: Exfiltration
- Id: TA0010
- Reference URL: [[https://attack.mitre.org/tactics/TA0010/](https://attack.mitre.org/tactics/TA0010/)](https://attack.mitre.org/tactics/TA0010/)
- Technique:
  - Name: Exfiltration Over Web Service
- Id: T1567
- Reference URL: [[https://attack.mitre.org/techniques/T1567/](https://attack.mitre.org/techniques/T1567/)](https://attack.mitre.org/techniques/T1567/)
- Sub Technique:
  - Name: Exfiltration to Code Repository
- Id: T1567.001
- Reference URL: [[https://attack.mitre.org/techniques/T1567/001/](https://attack.mitre.org/techniques/T1567/001/)](https://attack.mitre.org/techniques/T1567/001/)
- Sub Technique:
  - Name: Exfiltration to Cloud Storage
- Id: T1567.002
- Reference URL: [[https://attack.mitre.org/techniques/T1567/002/](https://attack.mitre.org/techniques/T1567/002/)](https://attack.mitre.org/techniques/T1567/002/)