﻿---
title: PowerShell Script with Webcam Video Capture Capabilities
description: Detects PowerShell script block content that references webcam capture APIs or video capture device objects. Attackers use webcam recording to surveil...
url: https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/windows/collection_posh_webcam_video_capture
products:
  - Elastic Security
---

# PowerShell Script with Webcam Video Capture Capabilities
Detects PowerShell script block content that references webcam capture APIs or video capture device objects.
Attackers use webcam recording to surveil victims or collect sensitive footage for extortion.
**Rule type**: query
**Rule indices**:
- winlogbeat-*
- logs-windows.powershell*

**Rule Severity**: medium
**Risk Score**: 47
**Runs every**: 
**Searches indices from**: `now-9m`
**Maximum alerts per execution**: 100
**References**:
- [[https://github.com/EmpireProject/Empire/blob/master/lib/modules/powershell/collection/WebcamRecorder.py](https://github.com/EmpireProject/Empire/blob/master/lib/modules/powershell/collection/WebcamRecorder.py)](https://github.com/EmpireProject/Empire/blob/master/lib/modules/powershell/collection/WebcamRecorder.py)

**Tags**:
- Domain: Endpoint
- OS: Windows
- Use Case: Threat Detection
- Tactic: Collection
- Data Source: PowerShell Logs
- Resources: Investigation Guide

**Version**: 110
**Rule authors**:
- Elastic

**Rule license**: Elastic License v2

## Setup

PowerShell Script Block Logging must be enabled to generate the events used by this rule (e.g., 4104).
Setup instructions: [https://ela.st/powershell-logging-setup](https://ela.st/powershell-logging-setup)

## Investigation guide


## Triage and analysis> **Disclaimer**:
This investigation guide was created using generative AI technology and has been reviewed to improve its accuracy and relevance. While every effort has been made to ensure its quality, we recommend validating the content and adapting it to suit your specific environment and operational needs.

### Investigating PowerShell Script with Webcam Video Capture Capabilities

This alert indicates PowerShell script block content on a Windows host that references webcam or video capture components. The matched content may represent device enumeration, frame handling, or capture routines used to record from an attached camera. Because webcam collection has privacy and regulatory impact, prioritize confirming intent, scope, and whether any recordings were produced or transferred.

#### Key alert fields to review

- `user.name`, `user.domain`, `user.id`: Account execution context for correlation, prioritization, and scoping.
- `host.name`, `host.id`: Host execution context for correlation, prioritization, and scoping.
- `powershell.file.script_block_text`: Script block content that matched the detection logic.
- `powershell.file.script_block_id`, `powershell.sequence`, `powershell.total`: Script block metadata to pivot to other fragments or reconstruct full script content when split across multiple events.
- `file.path`, `file.directory`, `file.name`: File-origin context when the script block is sourced from an on-disk file.
- `powershell.file.script_block_length`: Script block length (size) context.


#### Possible investigation steps

- Analyze the script content in `powershell.file.script_block_text` to understand its functionality:
  - Identify references to webcam or video capture APIs, classes, or methods (for example, `VideoCaptureDevice`, `NewFrameEventHandler`, `DirectX.Capture.Filters`, `VideoCompressors`, or calls to `avicap32.dll` functions).
- Look for logic that initializes the camera, configures capture settings, handles frame events, and starts/stops recording.
- Note any output handling, such as saving recordings to disk or preparing data for transmission.
- Reconstruct the complete script when content is split across multiple events:
  - Group by `powershell.file.script_block_id` and order by `powershell.sequence` through `powershell.total`.
- Preserve the reconstructed content as an investigation artifact and note `powershell.file.script_block_length` for context (very large blocks may contain additional functionality beyond capture).
- Identify likely collection intent and potential artifacts by inspecting the script content:
  - Look for device enumeration and selection logic (for example, listing available devices, choosing a specific camera, or referencing device indices).
- Look for capture start/stop logic, timers, or loops that control duration and frequency.
- Look for references to output locations, file names, or post-processing steps (encoding, compression, or transformation of captured frames).
- Look for indications of onward handling of recordings (archiving, encryption, or transfer).
- Determine script origin and reuse:
  - If `file.path` and `file.name` are present, treat the script as file-backed content and assess whether the location in `file.directory` is expected for the user and host.
- Pivot on `file.path` or `file.name` to identify additional script block events that reference the same file, and whether the same content appears on other hosts.
- Establish user and host context:
  - Validate whether `user.name` and `user.domain` align with expected webcam usage on `host.name` (for example, support, QA, or multimedia testing roles) and whether the timing is consistent with normal activity.
- Pivot on `host.id` and `user.id` in a narrow time window around `@timestamp` to identify related PowerShell script blocks that suggest staging, repeated attempts, or follow-on activity.
- Correlate with adjacent telemetry in your environment to confirm execution and impact:
  - Process telemetry: determine how PowerShell was launched (interactive use vs. launched by another program) and whether the activity was isolated or part of a broader execution chain.
- File telemetry: identify creation or modification of video artifacts and any additional scripts written or fetched around the alert time.
- Network telemetry: identify outbound connections that could support remote tasking or transfer of captured content.
- Authentication telemetry: verify whether the user context was local, remote, or recently authenticated in an unusual way during the alert window.


### False positive analysis

- Benign camera diagnostics or hardware validation scripts may reference capture devices, frame handlers, and compressor lists without performing unauthorized recording.
- Development and testing environments may include sample or proof-of-concept code that imports or references capture libraries during troubleshooting or application development.
- Enterprise imaging, kiosk build, or A/V workstation provisioning workflows may temporarily stage scripts that validate camera availability and driver functionality.


### Response and remediation

- If activity is unexpected or violates policy, treat as a potential privacy-impacting collection incident:
  - Escalate according to your incident response and privacy handling procedures.
- Preserve the full script content (reconstructed if needed) and record key identifiers: `@timestamp`, `host.name`, `host.id`, `user.name`, `user.id`, and any `file.path`/`file.name` present.
- Contain potential ongoing collection:
  - Isolate the affected host using standard endpoint response controls.
- Restrict the suspected user account and investigate for additional malicious activity associated with `user.id` and `host.id` during the same period.
- If appropriate for your environment, temporarily restrict access to the camera device on the affected host until legitimacy is confirmed.
- Eradicate and recover:
  - Remove or quarantine unauthorized scripts referenced by `file.path`/`file.name` and any related artifacts identified during triage.
- If recordings were created, locate and secure them as evidence, and assess whether any transfer occurred.
- Reset credentials for impacted accounts if compromise is suspected and review for additional access paths.
- Post-incident actions:
  - Increase monitoring for similar PowerShell script block content on the scoped hosts and accounts to detect recurrence.
- Review endpoint hardening and least-privilege controls for camera access and script execution where feasible.


## Rule Query

```kuery
event.category:process and host.os.type:windows and
  powershell.file.script_block_text : (
    "NewFrameEventHandler" or
    "VideoCaptureDevice" or
    "DirectX.Capture.Filters" or
    "VideoCompressors" or
    "Start-WebcamRecorder" or
    (
      ("capCreateCaptureWindowA" or
       "capCreateCaptureWindow" or
       "capGetDriverDescription") and
      ("avicap32.dll" or "avicap32")
    )
  )
```

**Framework:** MITRE ATT&CK
- Tactic:
  - Name: Collection
- Id: TA0009
- Reference URL: [[https://attack.mitre.org/tactics/TA0009/](https://attack.mitre.org/tactics/TA0009/)](https://attack.mitre.org/tactics/TA0009/)
- Technique:
  - Name: Video Capture
- Id: T1125
- Reference URL: [[https://attack.mitre.org/techniques/T1125/](https://attack.mitre.org/techniques/T1125/)](https://attack.mitre.org/techniques/T1125/)

**Framework:** MITRE ATT&CK
- Tactic:
  - Name: Execution
- Id: TA0002
- Reference URL: [[https://attack.mitre.org/tactics/TA0002/](https://attack.mitre.org/tactics/TA0002/)](https://attack.mitre.org/tactics/TA0002/)
- Technique:
  - Name: Command and Scripting Interpreter
- Id: T1059
- Reference URL: [[https://attack.mitre.org/techniques/T1059/](https://attack.mitre.org/techniques/T1059/)](https://attack.mitre.org/techniques/T1059/)
- Sub Technique:
  - Name: PowerShell
- Id: T1059.001
- Reference URL: [[https://attack.mitre.org/techniques/T1059/001/](https://attack.mitre.org/techniques/T1059/001/)](https://attack.mitre.org/techniques/T1059/001/)