﻿---
title: Rapid7 Threat Command CVEs Correlation
description: This rule is triggered when CVEs collected from the Rapid7 Threat Command Integration have a match against vulnerabilities that were found in the customer...
url: https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/threat_intel/threat_intel_rapid7_threat_command
products:
  - Elastic Security
---

# Rapid7 Threat Command CVEs Correlation
This rule is triggered when CVEs collected from the Rapid7 Threat Command Integration have a match against
vulnerabilities that were found in the customer environment.
**Rule type**: threat_match
**Rule indices**:
- auditbeat-*
- endgame-*
- filebeat-*
- logs-*
- packetbeat-*
- winlogbeat-*

**Rule Severity**: high
**Risk Score**: 73
**Runs every**: 30m
**Searches indices from**: `now-35m`
**Maximum alerts per execution**: 1000
**References**:
- [[https://www.elastic.co/guide/en/beats/filebeat/current/filebeat-module-threatintel.html](https://www.elastic.co/guide/en/beats/filebeat/current/filebeat-module-threatintel.html)](https://www.elastic.co/guide/en/beats/filebeat/current/filebeat-module-threatintel.html)
- [[https://docs.elastic.co/integrations/ti_rapid7_threat_command](https://docs.elastic.co/integrations/ti_rapid7_threat_command)](https://docs.elastic.co/integrations/ti_rapid7_threat_command)

**Tags**:
- OS: Windows
- Data Source: Elastic Endgame
- Data Source: Windows
- Data Source: Network
- Data Source: Rapid7 Threat Command
- Rule Type: Threat Match
- Resources: Investigation Guide
- Use Case: Vulnerability
- Use Case: Asset Visibility
- Use Case: Continuous Monitoring

**Version**: 107
**Rule authors**:
- Elastic

**Rule license**: Elastic License v2

## Setup

This rule needs threat intelligence indicators to work.
Threat intelligence indicators can be collected using an [Elastic Agent integration](https://www.elastic.co/guide/en/security/current/es-threat-intel-integrations.html#agent-ti-integration),
the [Threat Intel module](https://www.elastic.co/guide/en/security/current/es-threat-intel-integrations.html#ti-mod-integration),
or a [custom integration](https://www.elastic.co/guide/en/security/current/es-threat-intel-integrations.html#custom-ti-integration).
More information can be found [here](https://www.elastic.co/guide/en/security/current/es-threat-intel-integrations.html).

### Additional notes

For information on troubleshooting the maximum alerts warning please refer to this [guide](https://www.elastic.co/guide/en/security/current/alerts-ui-monitor.html#troubleshoot-max-alerts).

## Investigation guide


## Triage and analysis


### Investigating Rapid7 Threat Command CVEs Correlation

Rapid7 Threat Command CVEs Correlation rule allows matching CVEs from user indices within the vulnerabilities collected from Rapid7 Threat Command integrations.
The matches will be based on the latest values of CVEs from the last 180 days. So it's essential to validate the data and review the results by investigating the associated activity to determine if it requires further investigation.
If a vulnerability matches a local observation, the following enriched fields will be generated to identify the vulnerability, field, and type matched.
- `threat.indicator.matched.atomic` - this identifies the atomic vulnerability that matched the local observation
- `threat.indicator.matched.field` - this identifies the vulnerability field that matched the local observation
- `threat.indicator.matched.type` - this identifies the vulnerability type that matched the local observation

Additional investigation can be done by reviewing the source of the activity and considering the history of the vulnerability that was matched. This can help understand if the activity is related to legitimate behavior.
- Investigation can be validated and reviewed based on the data that was matched and by viewing the source of that activity.
- Consider the history of the vulnerability that was matched. Has it happened before? Is it happening on multiple machines? These kinds of questions can help understand if the activity is related to legitimate behavior.
- Consider the user and their role within the company: is this something related to their job or work function?


## Rule Query

```kuery
vulnerability.id : *
```