﻿---
title: Threat Intel URL Indicator Match
description: This rule is triggered when a URL indicator from the Threat Intel Filebeat module or integrations has a match against an event that contains URL data,...
url: https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/threat_intel/threat_intel_indicator_match_url
products:
  - Elastic Security
---

# Threat Intel URL Indicator Match
This rule is triggered when a URL indicator from the Threat Intel Filebeat module or integrations has a match against an
event that contains URL data, like DNS events, network logs, etc.
**Rule type**: threat_match
**Rule indices**:
- auditbeat-*
- endgame-*
- filebeat-*
- logs-*
- packetbeat-*
- winlogbeat-*

**Rule Severity**: high
**Risk Score**: 73
**Runs every**: 1h
**Searches indices from**: `now-65m`
**Maximum alerts per execution**: 100
**References**:
- [[https://www.elastic.co/guide/en/beats/filebeat/current/filebeat-module-threatintel.html](https://www.elastic.co/guide/en/beats/filebeat/current/filebeat-module-threatintel.html)](https://www.elastic.co/guide/en/beats/filebeat/current/filebeat-module-threatintel.html)
- [[https://www.elastic.co/guide/en/security/current/es-threat-intel-integrations.html](https://www.elastic.co/guide/en/security/current/es-threat-intel-integrations.html)](https://www.elastic.co/guide/en/security/current/es-threat-intel-integrations.html)
- [[https://www.elastic.co/security/tip](https://www.elastic.co/security/tip)](https://www.elastic.co/security/tip)

**Tags**:
- OS: Windows
- Data Source: Elastic Endgame
- Rule Type: Threat Match
- Resources: Investigation Guide

**Version**: 9
**Rule authors**:
- Elastic

**Rule license**: Elastic License v2

## Setup

This rule needs threat intelligence indicators to work.
Threat intelligence indicators can be collected using an [Elastic Agent integration](https://www.elastic.co/guide/en/security/current/es-threat-intel-integrations.html#agent-ti-integration),
the [Threat Intel module](https://www.elastic.co/guide/en/security/current/es-threat-intel-integrations.html#ti-mod-integration),
or a [custom integration](https://www.elastic.co/guide/en/security/current/es-threat-intel-integrations.html#custom-ti-integration).
More information can be found [here](https://www.elastic.co/guide/en/security/current/es-threat-intel-integrations.html).

## Investigation guide


## Triage and analysis


### Investigating Threat Intel URL Indicator Match

Threat Intel indicator match rules allow matching from a local observation, such as an endpoint event that records a file hash with an entry of a file hash stored within the Threat Intel integrations index.
Matches are based on threat intelligence data that's been ingested during the last 30 days. Some integrations don't place expiration dates on their threat indicators, so we strongly recommend validating ingested threat indicators and reviewing match results. When reviewing match results, check associated activity to determine whether the event requires additional investigation.
This rule is triggered when a URL indicator from the Threat Intel Filebeat module or a threat intelligence integration matches against an event that contains URL data, like DNS events, network logs, etc.> **Note**:
This investigation guide uses the [Osquery Markdown Plugin](https://www.elastic.co/guide/en/security/current/invest-guide-run-osquery.html) introduced in Elastic Stack version 8.5.0. Older Elastic Stack versions will display unrendered Markdown in this guide.

#### Possible investigation steps

- Investigate the URL, which can be found in the `threat.indicator.matched.atomic` field:
  - Identify the type of malicious activity related to the URL (phishing, malware, etc.).
- Check the reputation of the IP address in resources like VirusTotal, Hybrid-Analysis, CISCO Talos, Any.run, etc.
- Execute a WHOIS lookup to retrieve information about the domain registration and contacts to report abuse.
- If dealing with a phishing incident:
  - Contact the user to gain more information around the delivery method, information sent, etc.
- Analyze whether the URL is trying to impersonate a legitimate address. Look for typosquatting, extra or unusual subdomains, or other anomalies that could lure the user.
- Investigate the phishing page to identify which information may have been sent to the attacker by the user.
- Identify the process responsible for the connection, and investigate the process execution chain (parent process tree) for unknown processes. Examine their executable files for prevalence, whether they are located in expected locations, and if they are signed with valid digital signatures.
- Retrieve the involved process executable and examine the host for derived artifacts that indicate suspicious activities:
  - Analyze the process executable using a private sandboxed analysis system.
- Observe and collect information about the following activities in both the sandbox and the alert subject host:
  - Attempts to contact external domains and addresses.
  - Use the Elastic Defend network events to determine domains and addresses contacted by the subject process by filtering by the process' `process.entity_id`.
- Examine the DNS cache for suspicious or anomalous entries.
  - $osquery_0
- Use the Elastic Defend registry events to examine registry keys accessed, modified, or created by the related processes in the process tree.
- Examine the host services for suspicious or anomalous entries.
  - $osquery_1
- $osquery_2
- $osquery_3
- Using the data collected through the analysis, scope users targeted and other machines infected in the environment.


### False Positive Analysis

- False positives might occur after large and publicly written campaigns if curious employees interact with attacker infrastructure.
- Some feeds may include internal or known benign addresses by mistake (e.g., 8.8.8.8, google.com, 127.0.0.1, etc.). Make sure you understand how blocking a specific domain or address might impact the organization or normal system functioning.


### Response and Remediation

- Initiate the incident response process based on the outcome of the triage.
- Isolate the involved host to prevent further post-compromise behavior.
- If the triage identified malware, search the environment for additional compromised hosts.
  - Implement temporary network rules, procedures, and segmentation to contain the malware.
- Stop suspicious processes.
- Immediately block the identified indicators of compromise (IoCs).
- Inspect the affected systems for additional malware backdoors like reverse shells, reverse proxies, or droppers that attackers could use to reinfect the system.
- Consider reporting the address for abuse using the provided contact information.
- Remove and block malicious artifacts identified during triage.
- Run a full antimalware scan. This may reveal additional artifacts left in the system, persistence mechanisms, and malware components.
- Determine the initial vector abused by the attacker and take action to prevent reinfection through the same vector.
- Using the incident response data, update logging and audit policies to improve the mean time to detect (MTTD) and the mean time to respond (MTTR).


## Rule Query

```kuery
url.full:*
```