﻿---
title: SentinelOne Alert External Alerts
description: Generates a detection alert for each SentinelOne alert written to the configured indices. Enabling this rule allows you to immediately begin investigating...
url: https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/promotions/sentinelone_alert_external_alerts
products:
  - Elastic Security
---

# SentinelOne Alert External Alerts
Generates a detection alert for each SentinelOne alert written to the configured indices. Enabling this rule allows you
to immediately begin investigating SentinelOne alerts in the app.
**Rule type**: query
**Rule indices**:
- logs-sentinel_one.alert-*

**Rule Severity**: medium
**Risk Score**: 47
**Runs every**: 1m
**Searches indices from**: `now-2m`
**Maximum alerts per execution**: 1000
**References**:
- [[https://docs.elastic.co/en/integrations/sentinel_one](https://docs.elastic.co/en/integrations/sentinel_one)](https://docs.elastic.co/en/integrations/sentinel_one)

**Tags**:
- Data Source: SentinelOne
- Use Case: Threat Detection
- Resources: Investigation Guide
- Promotion: External Alerts

**Version**: 1
**Rule authors**:
- Elastic

**Rule license**: Elastic License v2

## Setup


### SentinelOne Alert Integration

This rule is designed to capture alert events generated by the SentinelOne integration and promote them as Elastic detection alerts.
To capture SentinelOne alerts, install and configure the SentinelOne integration to ingest alert events into the `logs-sentinel_one.alert-*` index pattern.
If this rule is enabled alongside the External Alerts promotion rule (UUID: eb079c62-4481-4d6e-9643-3ca499df7aaa), you may receive duplicate alerts for the same SentinelOne events. Consider adding a rule exception for the External Alert rule to exclude datastream.dataset: sentinel_one.alert to avoid receiving duplicate alerts.

### Additional notes

For information on troubleshooting the maximum alerts warning please refer to this [guide](https://www.elastic.co/guide/en/security/current/alerts-ui-monitor.html#troubleshoot-max-alerts).

## Investigation guide


## Triage and analysis


### Investigating SentinelOne Alert External Alerts

SentinelOne is a cybersecurity platform that provides endpoint protection by detecting and responding to threats in real-time. The rule identifies such threats by monitoring specific alert events, enabling analysts to swiftly investigate and mitigate potential security incidents.

### Possible investigation steps

- Correlate the alert with recent activity on the affected endpoint to identify any unusual or suspicious behavior patterns.
- Check for any additional alerts or logs related to the same endpoint or user to determine if this is part of a broader attack or isolated incident.
- Investigate the source and destination IP addresses involved in the alert to assess if they are known to be malicious or associated with previous threats.
- Analyze any files or processes flagged in the alert to determine if they are legitimate or potentially malicious, using threat intelligence sources if necessary.
- Consult the SentinelOne investigation guide and resources tagged in the alert for specific guidance on handling similar threats.


### False positive analysis

- Alerts triggered by routine software updates or patches can be false positives. Review the context of the alert to determine if it aligns with scheduled maintenance activities.
- Legitimate administrative tools or scripts may trigger alerts. Identify and whitelist these tools if they are verified as non-threatening.
- Frequent alerts from known safe applications or processes can be excluded by creating exceptions for these specific behaviors in the SentinelOne configuration.
- Network scanning or monitoring tools used by IT teams might be flagged. Ensure these tools are documented and excluded from triggering alerts if they are part of regular operations.
- User behavior that is consistent with their role but triggers alerts should be reviewed. If deemed non-malicious, adjust the rule to exclude these specific user actions.


### Response and remediation

- Isolate the affected endpoint immediately to prevent lateral movement and further compromise within the network.
- Analyze the specific alert details to identify the nature of the threat and any associated indicators of compromise (IOCs).
- Remove or quarantine any malicious files or processes identified by the SentinelOne alert to neutralize the threat.
- Apply relevant security patches or updates to address any exploited vulnerabilities on the affected endpoint.
- Conduct a thorough scan of the network to identify any additional endpoints that may have been compromised or are exhibiting similar behavior.
- Document the incident and escalate to the appropriate security team or management if the threat is part of a larger attack campaign or if additional resources are needed for remediation.
- Review and update endpoint protection policies and configurations to enhance detection and prevention capabilities against similar threats in the future.


## Rule Query

```kuery
event.kind: event and data_stream.dataset: sentinel_one.alert
```