﻿---
title: Process Injection - Detected - Elastic Endgame
description: Elastic Endgame detected Process Injection. Click the Elastic Endgame icon in the event.module column or the link in the rule.reference column for additional...
url: https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/promotions/privilege_escalation_endgame_process_injection_detected
products:
  - Elastic Security
---

# Process Injection - Detected - Elastic Endgame
Elastic Endgame detected Process Injection. Click the Elastic Endgame icon in the event.module column or the link in the
rule.reference column for additional information.
**Rule type**: query
**Rule indices**:
- endgame-*

**Rule Severity**: high
**Risk Score**: 73
**Runs every**: 1m
**Searches indices from**: `now-2m`
**Maximum alerts per execution**: 1000
**References**:
**Tags**:
- Data Source: Elastic Endgame
- Use Case: Threat Detection
- Tactic: Privilege Escalation
- Resources: Investigation Guide

**Version**: 105
**Rule authors**:
- Elastic

**Rule license**: Elastic License v2

## Setup


### Additional notes

For information on troubleshooting the maximum alerts warning please refer to this [guide](https://www.elastic.co/guide/en/security/current/alerts-ui-monitor.html#troubleshoot-max-alerts).

## Investigation guide


## Triage and analysis> **Disclaimer**:
This investigation guide was created using generative AI technology and has been reviewed to improve its accuracy and relevance. While every effort has been made to ensure its quality, we recommend validating the content and adapting it to suit your specific environment and operational needs.

### Investigating Process Injection - Detected - Elastic Endgame

Elastic Endgame is a security solution that monitors and detects suspicious activities like process injection, a technique often used by adversaries to execute malicious code within the address space of another process, thereby evading detection. This detection rule identifies such threats by analyzing alerts and specific event actions related to kernel shellcode, indicating potential privilege escalation attempts. By leveraging MITRE ATT&CK frameworks, it effectively flags high-risk activities, aiding analysts in mitigating threats.

### Possible investigation steps

- Review the alert details in the Elastic Endgame console by clicking the Elastic Endgame icon in the event.module column or the link in the rule.reference column to gather more context about the detected process injection.
- Examine the specific event.action and endgame.event_subtype_full fields to confirm the presence of kernel_shellcode_event, which indicates potential malicious activity.
- Analyze the process tree and parent-child relationships of the affected process to identify any unusual or unauthorized processes that may have initiated the injection.
- Check for any recent privilege escalation attempts or suspicious activities associated with the affected process by correlating with other alerts or logs in the system.
- Investigate the source and destination IP addresses, if available, to determine if there is any external communication that could suggest a command and control connection.
- Assess the risk and impact of the detected activity by considering the risk score and severity level, and prioritize response actions accordingly.
- If necessary, isolate the affected system to prevent further malicious activity and begin remediation efforts based on the findings.


### False positive analysis

- Legitimate software updates or patches may trigger process injection alerts. Users can create exceptions for known update processes by identifying their unique process names or hashes.
- Security tools or monitoring software that use process injection for legitimate purposes might be flagged. Users should whitelist these tools by specifying their process identifiers or paths.
- Custom scripts or automation tasks that interact with system processes could be misidentified as threats. Users can exclude these scripts by defining their execution context or command-line arguments.
- Debugging or development activities involving process manipulation might cause false positives. Users should consider excluding these activities during known development periods or within specific environments.
- Virtualization or sandboxing solutions that mimic process injection techniques for isolation purposes may be detected. Users can create exceptions for these solutions by recognizing their specific signatures or behaviors.


### Response and remediation

- Isolate the affected system immediately to prevent further spread of the malicious code. Disconnect it from the network and any shared resources.
- Terminate the malicious process identified by the alert to stop the execution of injected code. Use process management tools to safely end the process.
- Conduct a thorough scan of the affected system using updated antivirus and anti-malware tools to identify and remove any additional threats or remnants of the attack.
- Review and analyze system logs and the specific event details from the alert to understand the scope of the intrusion and identify any other potentially compromised systems.
- Apply security patches and updates to the operating system and all software applications on the affected system to close any vulnerabilities exploited by the attacker.
- Restore the system from a known good backup taken before the incident occurred, ensuring that the backup is free from any malicious code.
- Report the incident to the appropriate internal security team or external authorities if required, providing them with detailed information about the attack and the steps taken for remediation.


## Rule Query

```kuery
event.kind:alert and event.module:endgame and endgame.metadata.type:detection and (event.action:kernel_shellcode_event or endgame.event_subtype_full:kernel_shellcode_event)
```

**Framework:** MITRE ATT&CK
- Tactic:
  - Name: Privilege Escalation
- Id: TA0004
- Reference URL: [[https://attack.mitre.org/tactics/TA0004/](https://attack.mitre.org/tactics/TA0004/)](https://attack.mitre.org/tactics/TA0004/)
- Technique:
  - Name: Process Injection
- Id: T1055
- Reference URL: [[https://attack.mitre.org/techniques/T1055/](https://attack.mitre.org/techniques/T1055/)](https://attack.mitre.org/techniques/T1055/)