﻿---
title: Permission Theft - Detected - Elastic Endgame
description: Elastic Endgame detected Permission Theft. Click the Elastic Endgame icon in the event.module column or the link in the rule.reference column for additional...
url: https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/promotions/privilege_escalation_endgame_permission_theft_detected
products:
  - Elastic Security
---

# Permission Theft - Detected - Elastic Endgame
Elastic Endgame detected Permission Theft. Click the Elastic Endgame icon in the event.module column or the link in the
rule.reference column for additional information.
**Rule type**: query
**Rule indices**:
- endgame-*

**Rule Severity**: high
**Risk Score**: 73
**Runs every**: 1m
**Searches indices from**: `now-2m`
**Maximum alerts per execution**: 1000
**References**:
**Tags**:
- Data Source: Elastic Endgame
- Use Case: Threat Detection
- Tactic: Privilege Escalation
- Resources: Investigation Guide

**Version**: 105
**Rule authors**:
- Elastic

**Rule license**: Elastic License v2

## Setup


### Additional notes

For information on troubleshooting the maximum alerts warning please refer to this [guide](https://www.elastic.co/guide/en/security/current/alerts-ui-monitor.html#troubleshoot-max-alerts).

## Investigation guide


## Triage and analysis> **Disclaimer**:
This investigation guide was created using generative AI technology and has been reviewed to improve its accuracy and relevance. While every effort has been made to ensure its quality, we recommend validating the content and adapting it to suit your specific environment and operational needs.

### Investigating Permission Theft - Detected - Elastic Endgame

Elastic Endgame is a security solution that monitors and detects unauthorized access attempts, focusing on privilege escalation tactics like access token manipulation. Adversaries exploit this by stealing or forging tokens to gain elevated permissions. The detection rule identifies suspicious token-related events, flagging high-risk activities indicative of permission theft, thus enabling timely threat response.

### Possible investigation steps

- Review the alert details to confirm the presence of event.kind:alert and event.module:endgame, ensuring the alert is related to Elastic Endgame's detection capabilities.
- Examine the event.action and endgame.event_subtype_full fields for token_protection_event to identify the specific token manipulation activity that triggered the alert.
- Investigate the source and destination user accounts involved in the alert to determine if there are any unauthorized access attempts or privilege escalations.
- Check for any recent changes or anomalies in the permissions or roles associated with the affected accounts to assess potential impact.
- Correlate the alert with other security events or logs to identify any patterns or additional indicators of compromise that may suggest a broader attack campaign.
- Consult the MITRE ATT&CK framework for additional context on the Access Token Manipulation technique (T1134) to understand potential adversary behaviors and mitigation strategies.


### False positive analysis

- Routine administrative tasks involving token management can trigger alerts. Review and document these tasks to create exceptions for known safe activities.
- Automated scripts or services that frequently access tokens for legitimate purposes may be flagged. Identify these scripts and whitelist them to prevent unnecessary alerts.
- Software updates or installations that require elevated permissions might be detected as suspicious. Monitor these events and adjust detection rules to accommodate regular update schedules.
- Internal security tools that perform token manipulation for testing or monitoring purposes can cause false positives. Ensure these tools are recognized and excluded from detection rules.
- User behavior analytics might misinterpret legitimate user actions as threats. Regularly update user profiles and behavior baselines to minimize false alerts.


### Response and remediation

- Immediately isolate the affected system from the network to prevent further unauthorized access or lateral movement by the adversary.
- Revoke any compromised or suspicious access tokens identified in the alert to prevent further misuse of elevated permissions.
- Conduct a thorough review of recent account activities associated with the compromised tokens to identify any unauthorized actions or changes.
- Reset passwords and enforce multi-factor authentication for accounts involved in the incident to enhance security and prevent future unauthorized access.
- Restore any altered or deleted data from backups, ensuring that the restored data is free from any malicious modifications.
- Escalate the incident to the security operations center (SOC) or incident response team for further investigation and to determine if additional systems or accounts have been affected.
- Implement enhanced monitoring and logging for token-related activities to detect and respond to similar threats more effectively in the future.


## Rule Query

```kuery
event.kind:alert and event.module:endgame and endgame.metadata.type:detection and (event.action:token_protection_event or endgame.event_subtype_full:token_protection_event)
```

**Framework:** MITRE ATT&CK
- Tactic:
  - Name: Privilege Escalation
- Id: TA0004
- Reference URL: [[https://attack.mitre.org/tactics/TA0004/](https://attack.mitre.org/tactics/TA0004/)](https://attack.mitre.org/tactics/TA0004/)
- Technique:
  - Name: Access Token Manipulation
- Id: T1134
- Reference URL: [[https://attack.mitre.org/techniques/T1134/](https://attack.mitre.org/techniques/T1134/)](https://attack.mitre.org/techniques/T1134/)