﻿---
title: Microsoft Sentinel External Alerts
description: Generates a detection alert for each Microsoft Sentinel alert written to the configured indices. Enabling this rule allows you to immediately begin investigating...
url: https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/promotions/microsoft_sentinel_external_alerts
products:
  - Elastic Security
---

# Microsoft Sentinel External Alerts
Generates a detection alert for each Microsoft Sentinel alert written to the configured indices. Enabling this rule
allows you to immediately begin investigating Microsoft Sentinel alerts in the app.
**Rule type**: query
**Rule indices**:
- logs-microsoft_sentinel.alert-*

**Rule Severity**: medium
**Risk Score**: 47
**Runs every**: 1m
**Searches indices from**: `now-2m`
**Maximum alerts per execution**: 1000
**References**:
- [[https://docs.elastic.co/en/integrations/microsoft_sentinel](https://docs.elastic.co/en/integrations/microsoft_sentinel)](https://docs.elastic.co/en/integrations/microsoft_sentinel)

**Tags**:
- Data Source: Microsoft Sentinel
- Use Case: Threat Detection
- Resources: Investigation Guide
- Promotion: External Alerts

**Version**: 1
**Rule authors**:
- Elastic

**Rule license**: Elastic License v2

## Setup


### Microsoft Sentinel Alert Integration

This rule is designed to capture alert events generated by the Microsoft Sentinel integration and promote them as Elastic detection alerts.
To capture Microsoft Sentinel alerts, install and configure the Microsoft Sentinel integration to ingest alert events into the `logs-microsoft_sentinel.alert-*` index pattern.
If this rule is enabled alongside the External Alerts promotion rule (UUID: eb079c62-4481-4d6e-9643-3ca499df7aaa), you may receive duplicate alerts for the same Sentinel events. Consider adding a rule exception for the External Alert rule to exclude data_stream.dataset:microsoft_sentinel.alert to avoid receiving duplicate alerts.

### Additional notes

For information on troubleshooting the maximum alerts warning please refer to this [guide](https://www.elastic.co/guide/en/security/current/alerts-ui-monitor.html#troubleshoot-max-alerts).

## Investigation guide

Triage and analysis

## Investigating Microsoft Sentinel External Alerts

Microsoft Sentinel is a cloud-native SIEM tool that aggregates security data for threat detection and response. The rule identifies each alert logged in Sentinel, enabling analysts to swiftly investigate potential threats.

### Possible investigation steps

- Examine the timeline of events leading up to the alert to identify any unusual or suspicious activities that may have occurred.
- Cross-reference the alert with other related alerts or logs in Microsoft Sentinel to determine if this is part of a larger pattern or isolated incident.
- Investigate the source and context of the alert to identify any patterns or anomalies that could indicate manipulation or false positives.
- Consult the Microsoft Sentinel investigation guide and resources tagged in the alert for specific guidance on handling similar threats.


### False positive analysis

- Alerts triggered by routine administrative tasks can be false positives. Identify these tasks and create exceptions to prevent unnecessary alerts.
- Frequent alerts from known safe IP addresses or domains may not indicate a threat. Whitelist these sources to reduce noise.
- Alerts generated by automated scripts or scheduled tasks that are part of regular operations can be excluded by setting up filters for these specific activities.
- Non-threatening alerts from internal network scans or vulnerability assessments should be reviewed and excluded if they are part of regular security practices.
- Alerts from test environments or sandboxed systems can be false positives. Exclude these environments from alert generation to focus on genuine threats.


### Response and remediation

- Contain the threat by isolating affected systems from the network to prevent further spread or data exfiltration.
- Review and terminate any suspicious processes or sessions identified in the alert to halt ongoing malicious activities.
- Conduct a thorough analysis of the alert details to identify any compromised accounts or credentials and reset passwords immediately.
- Apply relevant security patches or updates to affected systems to close any vulnerabilities exploited by the adversary.
- Restore affected systems from clean backups to ensure the integrity and security of the environment.
- Monitor network traffic and system logs closely for any signs of recurring or related suspicious activities.
- Escalate the incident to the security operations center (SOC) or incident response team for further investigation and to determine if additional resources are needed.


## Rule Query

```kuery
event.kind: alert and data_stream.dataset: microsoft_sentinel.alert
```