﻿---
title: External Alerts
description: Generates a detection alert for each external alert written to the configured indices. Enabling this rule allows you to immediately begin investigating...
url: https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/promotions/external_alerts
products:
  - Elastic Security
---

# External Alerts
Generates a detection alert for each external alert written to the configured indices. Enabling this rule allows you to
immediately begin investigating external alerts in the app.
**Rule type**: query
**Rule indices**:
- apm-*-transaction*
- traces-apm*
- auditbeat-*
- filebeat-*
- logs-*
- packetbeat-*
- winlogbeat-*

**Rule Severity**: medium
**Risk Score**: 47
**Runs every**: 1m
**Searches indices from**: `now-2m`
**Maximum alerts per execution**: 1000
**References**:
**Tags**:
- OS: Windows
- Data Source: APM
- OS: macOS
- OS: Linux
- Resources: Investigation Guide

**Version**: 107
**Rule authors**:
- Elastic

**Rule license**: Elastic License v2

## Setup


### Additional notes

For information on troubleshooting the maximum alerts warning please refer to this [guide](https://www.elastic.co/guide/en/security/current/alerts-ui-monitor.html#troubleshoot-max-alerts).

## Investigation guide


## Triage and analysis> **Disclaimer**:
This investigation guide was created using generative AI technology and has been reviewed to improve its accuracy and relevance. While every effort has been made to ensure its quality, we recommend validating the content and adapting it to suit your specific environment and operational needs.

### Investigating External Alerts

External alerts are crucial for identifying potential threats across diverse environments like Windows, macOS, and Linux. These alerts are generated from various sources, excluding specific modules like endpoint or cloud defend, to focus on broader threat landscapes. Adversaries may exploit vulnerabilities in these systems to execute unauthorized actions. The 'External Alerts' detection rule filters and highlights such activities by focusing on alert events, enabling analysts to swiftly investigate and mitigate risks.

### Possible investigation steps

- Review the alert details to identify the specific event.kind:alert that triggered the detection, ensuring it is not associated with the excluded modules (endgame, endpoint, or cloud_defend).
- Examine the source and context of the alert by checking the associated tags, such as 'OS: Windows', 'OS: macOS', or 'OS: Linux', to understand the environment affected.
- Gather additional context by correlating the alert with other logs or events from the same time frame or system to identify any related suspicious activities.
- Assess the risk score and severity level to prioritize the investigation and determine the potential impact on the organization.
- Investigate the origin of the alert by identifying the source IP, user account, or process involved, and check for any known vulnerabilities or exploits associated with them.
- Consult threat intelligence sources to determine if the alert corresponds to any known threat actors or campaigns targeting similar environments.


### False positive analysis

- Alerts from benign third-party applications may trigger false positives. Review and identify these applications, then create exceptions to exclude them from future alerts.
- Routine system updates or patches can generate alerts. Monitor update schedules and create exceptions for known update activities to reduce noise.
- Network monitoring tools might produce alerts due to their scanning activities. Verify these tools and exclude their activities if deemed non-threatening.
- Alerts from internal security testing or penetration testing exercises can be mistaken for threats. Coordinate with security teams to whitelist these activities during scheduled tests.
- Certain administrative scripts or automation tasks may trigger alerts. Evaluate these scripts and exclude them if they are part of regular operations and pose no risk.


### Response and remediation

- Isolate affected systems immediately to prevent further unauthorized actions and contain the threat.
- Conduct a thorough review of the alert details to identify any specific vulnerabilities or exploits used by the adversary.
- Apply relevant patches or updates to the affected systems to remediate any identified vulnerabilities.
- Restore systems from a known good backup if unauthorized changes or actions have been detected.
- Monitor network traffic and system logs closely for any signs of further suspicious activity or attempts to exploit similar vulnerabilities.
- Escalate the incident to the appropriate security team or management if the threat appears to be part of a larger attack campaign or if additional resources are needed for remediation.
- Enhance detection capabilities by updating security tools and configurations to better identify similar threats in the future.


## Rule Query

```kuery
event.kind:alert and not event.module:(endgame or endpoint or cloud_defend)
```