﻿---
title: Exploit - Prevented - Elastic Endgame
description: Elastic Endgame prevented an Exploit. Click the Elastic Endgame icon in the event.module column or the link in the rule.reference column for additional...
url: https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/promotions/execution_endgame_exploit_prevented
products:
  - Elastic Security
---

# Exploit - Prevented - Elastic Endgame
Elastic Endgame prevented an Exploit. Click the Elastic Endgame icon in the event.module column or the link in the
rule.reference column for additional information.
**Rule type**: query
**Rule indices**:
- endgame-*

**Rule Severity**: medium
**Risk Score**: 47
**Runs every**: 1m
**Searches indices from**: `now-2m`
**Maximum alerts per execution**: 1000
**References**:
**Tags**:
- Data Source: Elastic Endgame
- Use Case: Threat Detection
- Tactic: Execution
- Tactic: Privilege Escalation
- Resources: Investigation Guide

**Version**: 105
**Rule authors**:
- Elastic

**Rule license**: Elastic License v2

## Setup


### Additional notes

For information on troubleshooting the maximum alerts warning please refer to this [guide](https://www.elastic.co/guide/en/security/current/alerts-ui-monitor.html#troubleshoot-max-alerts).

## Investigation guide


## Triage and analysis> **Disclaimer**:
This investigation guide was created using generative AI technology and has been reviewed to improve its accuracy and relevance. While every effort has been made to ensure its quality, we recommend validating the content and adapting it to suit your specific environment and operational needs.

### Investigating Exploit - Prevented - Elastic Endgame

Elastic Endgame is a security solution designed to prevent exploits by monitoring and analyzing system behaviors. Adversaries often exploit vulnerabilities to execute unauthorized code or escalate privileges. This detection rule identifies prevention events where an exploit attempt was blocked, focusing on alerts from the Endgame module. By analyzing specific event actions and metadata, it helps security analysts quickly identify and respond to potential threats, ensuring system integrity and security.

### Possible investigation steps

- Review the alert details to confirm the event.kind is 'alert' and event.module is 'endgame', ensuring the alert is relevant to the Elastic Endgame module.
- Examine the endgame.metadata.type field to verify it is marked as 'prevention', indicating that the exploit attempt was successfully blocked.
- Analyze the event.action and endgame.event_subtype_full fields to determine the specific type of exploit event that was attempted, such as 'exploit_event'.
- Investigate the source and destination IP addresses, user accounts, and hostnames involved in the alert to identify potential points of compromise or targets.
- Check for any related alerts or logs within the same timeframe to identify patterns or additional indicators of compromise that may suggest a broader attack campaign.
- Assess the risk score and severity level to prioritize the investigation and determine if immediate action is required to mitigate potential threats.
- Document findings and any actions taken in response to the alert to maintain a comprehensive record for future reference and analysis.


### False positive analysis

- Routine software updates or patches may trigger prevention alerts as they modify system files or configurations. Review the update schedule and correlate alerts with known maintenance windows to verify legitimacy.
- Legitimate administrative tools or scripts that perform actions similar to exploit techniques can be flagged. Identify these tools and create exceptions for their known behaviors to reduce noise.
- Security testing or vulnerability scanning activities might mimic exploit attempts. Coordinate with IT and security teams to whitelist these activities during scheduled assessments.
- Custom applications with unique behaviors may be misidentified as threats. Work with development teams to understand these behaviors and adjust detection rules or create exceptions accordingly.
- Frequent alerts from specific systems or users could indicate a misconfiguration. Investigate these patterns and adjust system settings or user permissions to align with security policies.


### Response and remediation

- Immediately isolate the affected system from the network to prevent further exploitation or lateral movement by the adversary.
- Verify the integrity of critical system files and applications on the affected system to ensure no unauthorized changes have been made.
- Apply the latest security patches and updates to the affected system to address any known vulnerabilities that may have been targeted.
- Conduct a thorough review of user accounts and privileges on the affected system to identify and revoke any unauthorized access or privilege escalation.
- Restore the affected system from a known good backup if any unauthorized changes or exploit attempts have compromised system integrity.
- Monitor the network and system logs for any signs of similar exploit attempts or related suspicious activities to ensure no further threats are present.
- Escalate the incident to the security operations center (SOC) or incident response team for further investigation and to determine if additional systems may be at risk.


## Rule Query

```kuery
event.kind:alert and event.module:endgame and endgame.metadata.type:prevention and (event.action:exploit_event or endgame.event_subtype_full:exploit_event)
```

**Framework:** MITRE ATT&CK
- Tactic:
  - Name: Execution
- Id: TA0002
- Reference URL: [[https://attack.mitre.org/tactics/TA0002/](https://attack.mitre.org/tactics/TA0002/)](https://attack.mitre.org/tactics/TA0002/)

**Framework:** MITRE ATT&CK
- Tactic:
  - Name: Privilege Escalation
- Id: TA0004
- Reference URL: [[https://attack.mitre.org/tactics/TA0004/](https://attack.mitre.org/tactics/TA0004/)](https://attack.mitre.org/tactics/TA0004/)
- Technique:
  - Name: Exploitation for Privilege Escalation
- Id: T1068
- Reference URL: [[https://attack.mitre.org/techniques/T1068/](https://attack.mitre.org/techniques/T1068/)](https://attack.mitre.org/techniques/T1068/)