﻿---
title: Exploit - Detected - Elastic Endgame
description: Elastic Endgame detected an Exploit. Click the Elastic Endgame icon in the event.module column or the link in the rule.reference column for additional...
url: https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/promotions/execution_endgame_exploit_detected
products:
  - Elastic Security
---

# Exploit - Detected - Elastic Endgame
Elastic Endgame detected an Exploit. Click the Elastic Endgame icon in the event.module column or the link in the
rule.reference column for additional information.
**Rule type**: query
**Rule indices**:
- endgame-*

**Rule Severity**: high
**Risk Score**: 73
**Runs every**: 1m
**Searches indices from**: `now-2m`
**Maximum alerts per execution**: 1000
**References**:
**Tags**:
- Data Source: Elastic Endgame
- Use Case: Threat Detection
- Tactic: Execution
- Tactic: Privilege Escalation
- Resources: Investigation Guide

**Version**: 105
**Rule authors**:
- Elastic

**Rule license**: Elastic License v2

## Setup


### Additional notes

For information on troubleshooting the maximum alerts warning please refer to this [guide](https://www.elastic.co/guide/en/security/current/alerts-ui-monitor.html#troubleshoot-max-alerts).

## Investigation guide


## Triage and analysis> **Disclaimer**:
This investigation guide was created using generative AI technology and has been reviewed to improve its accuracy and relevance. While every effort has been made to ensure its quality, we recommend validating the content and adapting it to suit your specific environment and operational needs.

### Investigating Exploit - Detected - Elastic Endgame

Elastic Endgame is a security solution that monitors and detects exploit attempts within an environment. Adversaries exploit vulnerabilities to execute unauthorized code or escalate privileges. The detection rule identifies alerts from the Endgame module, focusing on exploit-related events. It leverages metadata and event actions to flag high-risk activities, aiding in swift threat detection and response.

### Possible investigation steps

- Review the alert details to confirm the presence of event.kind:alert and event.module:endgame, ensuring the alert is relevant to the Elastic Endgame detection.
- Examine the event.action and endgame.event_subtype_full fields to determine the specific exploit event type, which can provide insight into the nature of the exploit attempt.
- Investigate the endgame.metadata.type field to gather additional context about the detection, such as the source and target of the exploit attempt.
- Check the associated risk score and severity level to prioritize the investigation and response efforts, focusing on high-risk activities.
- Correlate the alert with other related events in the environment to identify potential patterns or additional indicators of compromise.
- Consult the MITRE ATT&CK framework for the Execution tactic (TA0002) to understand potential techniques that might have been used and to guide further investigation steps.


### False positive analysis

- Routine software updates or patches may trigger exploit detection alerts. Users can create exceptions for known update processes by identifying their unique metadata or event actions.
- Legitimate administrative tools that perform actions similar to exploits might be flagged. Users should whitelist these tools by specifying their event.module or event.action attributes.
- Automated scripts used for system maintenance could mimic exploit behavior. To prevent false positives, users can exclude these scripts by defining their specific endgame.event_subtype_full.
- Security testing activities, such as penetration tests, may generate alerts. Users can manage these by setting temporary exceptions during the testing period, based on the event.kind or event.module.


### Response and remediation

- Isolate the affected system immediately to prevent further exploitation or lateral movement within the network.
- Terminate any unauthorized processes identified as part of the exploit event to halt malicious activity.
- Apply relevant security patches or updates to the affected system to address the exploited vulnerability and prevent recurrence.
- Conduct a thorough forensic analysis of the affected system to identify any additional indicators of compromise or secondary payloads.
- Restore the system from a known good backup if necessary, ensuring that the backup is free from any malicious artifacts.
- Monitor the network for any signs of similar exploit attempts, using enhanced logging and alerting based on the identified threat indicators.
- Escalate the incident to the security operations center (SOC) or incident response team for further investigation and to ensure comprehensive remediation.


## Rule Query

```kuery
event.kind:alert and event.module:endgame and endgame.metadata.type:detection and (event.action:exploit_event or endgame.event_subtype_full:exploit_event)
```

**Framework:** MITRE ATT&CK
- Tactic:
  - Name: Execution
- Id: TA0002
- Reference URL: [[https://attack.mitre.org/tactics/TA0002/](https://attack.mitre.org/tactics/TA0002/)](https://attack.mitre.org/tactics/TA0002/)

**Framework:** MITRE ATT&CK
- Tactic:
  - Name: Privilege Escalation
- Id: TA0004
- Reference URL: [[https://attack.mitre.org/tactics/TA0004/](https://attack.mitre.org/tactics/TA0004/)](https://attack.mitre.org/tactics/TA0004/)
- Technique:
  - Name: Exploitation for Privilege Escalation
- Id: T1068
- Reference URL: [[https://attack.mitre.org/techniques/T1068/](https://attack.mitre.org/techniques/T1068/)](https://attack.mitre.org/techniques/T1068/)