﻿---
title: Ransomware - Prevented - Elastic Endgame
description: Elastic Endgame prevented ransomware. Click the Elastic Endgame icon in the event.module column or the link in the rule.reference column for additional...
url: https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/promotions/endgame_ransomware_prevented
products:
  - Elastic Security
---

# Ransomware - Prevented - Elastic Endgame
Elastic Endgame prevented ransomware. Click the Elastic Endgame icon in the event.module column or the link in the
rule.reference column for additional information.
**Rule type**: query
**Rule indices**:
- endgame-*

**Rule Severity**: high
**Risk Score**: 73
**Runs every**: 1m
**Searches indices from**: `now-2m`
**Maximum alerts per execution**: 1000
**References**:
**Tags**:
- Data Source: Elastic Endgame
- Resources: Investigation Guide

**Version**: 105
**Rule authors**:
- Elastic

**Rule license**: Elastic License v2

## Setup


### Additional notes

For information on troubleshooting the maximum alerts warning please refer to this [guide](https://www.elastic.co/guide/en/security/current/alerts-ui-monitor.html#troubleshoot-max-alerts).

## Investigation guide


## Triage and analysis> **Disclaimer**:
This investigation guide was created using generative AI technology and has been reviewed to improve its accuracy and relevance. While every effort has been made to ensure its quality, we recommend validating the content and adapting it to suit your specific environment and operational needs.

### Investigating Ransomware - Prevented - Elastic Endgame

Elastic Endgame is a security solution designed to prevent ransomware by monitoring and analyzing system events. Adversaries exploit vulnerabilities to deploy ransomware, encrypting files and demanding payment. The detection rule identifies ransomware activities by analyzing alerts and prevention events, focusing on specific actions and event types, thus enabling timely intervention and threat mitigation.

### Possible investigation steps

- Review the alert details in the Elastic Endgame console by clicking the Elastic Endgame icon in the event.module column or the link in the rule.reference column to gather more context about the specific prevention event.
- Examine the event.kind field to confirm that the alert is indeed an alert type and verify the event.module is set to endgame, ensuring the alert is generated by the Elastic Endgame module.
- Check the endgame.metadata.type field to ensure it is marked as prevention, indicating that the ransomware activity was successfully blocked.
- Investigate the event.action and endgame.event_subtype_full fields to identify the specific ransomware event that triggered the alert, which can provide insights into the type of ransomware activity that was attempted.
- Correlate the alert with other security events and logs from the same timeframe to identify any related activities or anomalies that might indicate a broader attack attempt or compromise.
- Assess the affected system(s) for any signs of compromise or residual malicious activity, ensuring that the ransomware prevention was comprehensive and no other threats remain.


### False positive analysis

- Routine software updates or installations may trigger alerts as they can mimic ransomware behavior. Users should review these events and create exceptions for trusted software update processes.
- Backup operations that involve large-scale file modifications or encryptions might be misidentified as ransomware activities. Exclude known backup software and processes from triggering alerts.
- Security testing tools or scripts designed to simulate ransomware for training or assessment purposes can cause false positives. Ensure these tools are whitelisted and their activities are documented.
- Automated file encryption services used for legitimate purposes, such as data protection, may be flagged. Identify and exclude these services from the rule to prevent unnecessary alerts.
- Frequent alerts from specific applications or processes that are known to be safe should be analyzed, and exceptions should be created to reduce noise and focus on genuine threats.


### Response and remediation

- Isolate the affected system immediately to prevent further spread of the ransomware. Disconnect it from the network and any shared drives.
- Use Elastic Endgame to identify and terminate any malicious processes associated with the ransomware event to halt encryption activities.
- Conduct a thorough scan of the affected system using updated antivirus and anti-malware tools to remove any remaining malicious files or components.
- Restore encrypted files from the most recent clean backup to ensure data integrity and minimize data loss.
- Review and update endpoint protection settings and policies in Elastic Endgame to enhance detection and prevention capabilities against similar ransomware threats.
- Notify the IT security team and relevant stakeholders about the incident for awareness and further investigation into potential vulnerabilities exploited.
- Document the incident details, including the response actions taken, to improve future incident response strategies and facilitate any necessary reporting or compliance requirements.


## Rule Query

```kuery
event.kind:alert and event.module:endgame and endgame.metadata.type:prevention and (event.action:ransomware_event or endgame.event_subtype_full:ransomware_event)
```