﻿---
title: Ransomware - Detected - Elastic Endgame
description: Elastic Endgame detected ransomware. Click the Elastic Endgame icon in the event.module column or the link in the rule.reference column for additional...
url: https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/promotions/endgame_ransomware_detected
products:
  - Elastic Security
---

# Ransomware - Detected - Elastic Endgame
Elastic Endgame detected ransomware. Click the Elastic Endgame icon in the event.module column or the link in the
rule.reference column for additional information.
**Rule type**: query
**Rule indices**:
- endgame-*

**Rule Severity**: critical
**Risk Score**: 99
**Runs every**: 1m
**Searches indices from**: `now-2m`
**Maximum alerts per execution**: 1000
**References**:
**Tags**:
- Data Source: Elastic Endgame
- Resources: Investigation Guide

**Version**: 105
**Rule authors**:
- Elastic

**Rule license**: Elastic License v2

## Setup


### Additional notes

For information on troubleshooting the maximum alerts warning please refer to this [guide](https://www.elastic.co/guide/en/security/current/alerts-ui-monitor.html#troubleshoot-max-alerts).

## Investigation guide


## Triage and analysis> **Disclaimer**:
This investigation guide was created using generative AI technology and has been reviewed to improve its accuracy and relevance. While every effort has been made to ensure its quality, we recommend validating the content and adapting it to suit your specific environment and operational needs.

### Investigating Ransomware - Detected - Elastic Endgame

Elastic Endgame is a security solution designed to detect and respond to threats like ransomware by analyzing system events and behaviors. Adversaries exploit vulnerabilities to deploy ransomware, encrypting files and demanding payment. The detection rule identifies ransomware activity by monitoring specific alert types and event actions, flagging critical threats for immediate investigation.

### Possible investigation steps

- Review the alert details in Elastic Endgame by clicking the icon in the event.module column or the link in the rule.reference column to gather more context about the detected ransomware event.
- Analyze the event.kind:alert and event.module:endgame fields to confirm the alert's origin and ensure it aligns with known ransomware activity.
- Examine the event.action:ransomware_event and endgame.event_subtype_full:ransomware_event fields to identify the specific actions or behaviors that triggered the alert.
- Investigate the affected systems and endpoints to determine the scope of the ransomware impact, focusing on any encrypted files or unusual system behaviors.
- Check for any additional alerts or related events in the Elastic Endgame logs that might indicate lateral movement or further malicious activity associated with the ransomware.


### False positive analysis

- Routine backup operations can sometimes mimic ransomware behavior by accessing and modifying large numbers of files. Users should review backup schedules and processes to ensure they are not triggering alerts.
- Legitimate software updates or installations may be flagged as ransomware events due to their file modification activities. Users can create exceptions for trusted software update processes to prevent false positives.
- Automated file encryption tools used for legitimate purposes, such as data protection, might trigger ransomware alerts. Users should whitelist these tools if they are verified and necessary for business operations.
- Security testing or penetration testing activities that simulate ransomware attacks can be mistaken for real threats. Ensure that these activities are coordinated with the security team and excluded from detection rules during testing periods.
- Frequent alerts from specific non-critical systems or applications that are known to exhibit similar behaviors should be reviewed and, if deemed safe, added to an exception list to reduce noise.


### Response and remediation

- Isolate the affected systems immediately to prevent the spread of ransomware to other networked devices. Disconnect them from the network and any shared storage.
- Identify and terminate any malicious processes associated with the ransomware event using endpoint detection and response tools.
- Restore encrypted files from the most recent clean backup. Ensure backups are scanned for malware before restoration to avoid reinfection.
- Conduct a thorough forensic analysis to determine the initial point of entry and the scope of the compromise. This will help in understanding how the ransomware was deployed.
- Apply security patches to address any vulnerabilities exploited by the ransomware. Ensure all systems are updated to prevent similar attacks.
- Enhance monitoring and detection capabilities by configuring alerts for similar event patterns and behaviors identified in the query fields.
- Report the incident to relevant authorities and stakeholders as per organizational policy and legal requirements, ensuring compliance with any regulatory obligations.


## Rule Query

```kuery
event.kind:alert and event.module:endgame and endgame.metadata.type:detection and (event.action:ransomware_event or endgame.event_subtype_full:ransomware_event)
```