﻿---
title: Malware - Prevented - Elastic Endgame
description: Elastic Endgame prevented Malware. Click the Elastic Endgame icon in the event.module column or the link in the rule.reference column for additional information...
url: https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/promotions/endgame_malware_prevented
products:
  - Elastic Security
---

# Malware - Prevented - Elastic Endgame
Elastic Endgame prevented Malware. Click the Elastic Endgame icon in the event.module column or the link in the
rule.reference column for additional information.
**Rule type**: query
**Rule indices**:
- endgame-*

**Rule Severity**: high
**Risk Score**: 73
**Runs every**: 1m
**Searches indices from**: `now-2m`
**Maximum alerts per execution**: 1000
**References**:
**Tags**:
- Data Source: Elastic Endgame
- Resources: Investigation Guide

**Version**: 105
**Rule authors**:
- Elastic

**Rule license**: Elastic License v2

## Setup


### Additional notes

For information on troubleshooting the maximum alerts warning please refer to this [guide](https://www.elastic.co/guide/en/security/current/alerts-ui-monitor.html#troubleshoot-max-alerts).

## Investigation guide


## Triage and analysis> **Disclaimer**:
This investigation guide was created using generative AI technology and has been reviewed to improve its accuracy and relevance. While every effort has been made to ensure its quality, we recommend validating the content and adapting it to suit your specific environment and operational needs.

### Investigating Malware - Prevented - Elastic Endgame

Elastic Endgame is a security solution designed to prevent malware by analyzing and classifying files in real-time. Adversaries may attempt to bypass such defenses by disguising malicious files to evade detection. The detection rule identifies prevention events where Elastic Endgame has successfully blocked a file classified as malware, focusing on alerts generated by file classification activities. This helps security analysts quickly respond to and investigate potential threats.

### Possible investigation steps

- Review the alert details to confirm the event.kind is 'alert' and event.module is 'endgame', ensuring the alert is relevant to the Elastic Endgame prevention mechanism.
- Examine the endgame.metadata.type field to verify it is 'prevention', indicating that the alert pertains to a successfully blocked malware attempt.
- Investigate the event.action or endgame.event_subtype_full fields to understand the specific file classification event that triggered the alert.
- Gather additional context by checking the file path, hash, and any associated metadata to identify the potentially malicious file and its origin.
- Cross-reference the alert with other security logs and alerts to determine if there are related events or patterns that could indicate a broader attack campaign.
- Assess the risk score and severity to prioritize the investigation and response efforts, considering the high severity and risk score of 73.
- Utilize the Elastic Endgame interface or provided links for further information and context about the specific prevention event and any recommended remediation actions.


### False positive analysis

- Legitimate software updates or installations may trigger the rule if they involve file classification activities. To manage this, create exceptions for known and trusted software update processes.
- Security tools or system processes that perform file scanning or classification might be flagged. Identify these processes and add them to an exception list to prevent unnecessary alerts.
- Custom scripts or applications developed in-house that perform file operations similar to malware can be mistaken for threats. Review these scripts and whitelist them if they are verified as safe.
- Frequent alerts from specific directories known to contain non-malicious files, such as temporary or backup folders, can be excluded by specifying these paths in the rule exceptions.
- If certain file types are consistently misclassified as threats, consider adjusting the rule to exclude these file types after confirming they are not harmful.


### Response and remediation

- Isolate the affected system immediately to prevent the spread of malware to other parts of the network. Disconnect the system from the network and any shared drives.
- Verify the alert by cross-referencing the blocked file details with known malware signatures or threat intelligence sources to confirm the threat.
- Remove the malicious file from the system using a trusted antivirus or endpoint protection tool. Ensure that the file is quarantined or deleted to prevent re-execution.
- Conduct a thorough scan of the affected system and any connected devices to identify and remove any additional malicious files or remnants.
- Restore any affected files or systems from a clean backup, ensuring that the backup is free from malware before restoration.
- Escalate the incident to the security operations center (SOC) or incident response team for further analysis and to determine if additional systems may be compromised.
- Review and update security policies and endpoint protection configurations to enhance detection and prevention capabilities against similar threats in the future.


## Rule Query

```kuery
event.kind:alert and event.module:endgame and endgame.metadata.type:prevention and (event.action:file_classification_event or endgame.event_subtype_full:file_classification_event)
```