﻿---
title: Malware - Detected - Elastic Endgame
description: Elastic Endgame detected Malware. Click the Elastic Endgame icon in the event.module column or the link in the rule.reference column for additional information...
url: https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/promotions/endgame_malware_detected
products:
  - Elastic Security
---

# Malware - Detected - Elastic Endgame
Elastic Endgame detected Malware. Click the Elastic Endgame icon in the event.module column or the link in the
rule.reference column for additional information.
**Rule type**: query
**Rule indices**:
- endgame-*

**Rule Severity**: critical
**Risk Score**: 99
**Runs every**: 1m
**Searches indices from**: `now-2m`
**Maximum alerts per execution**: 1000
**References**:
**Tags**:
- Data Source: Elastic Endgame
- Resources: Investigation Guide

**Version**: 105
**Rule authors**:
- Elastic

**Rule license**: Elastic License v2

## Setup


### Additional notes

For information on troubleshooting the maximum alerts warning please refer to this [guide](https://www.elastic.co/guide/en/security/current/alerts-ui-monitor.html#troubleshoot-max-alerts).

## Investigation guide


## Triage and analysis> **Disclaimer**:
This investigation guide was created using generative AI technology and has been reviewed to improve its accuracy and relevance. While every effort has been made to ensure its quality, we recommend validating the content and adapting it to suit your specific environment and operational needs.

### Investigating Malware - Detected - Elastic Endgame

Elastic Endgame is a security solution that provides endpoint protection by monitoring and analyzing system activities to detect malicious behavior. Adversaries may exploit this technology by attempting to bypass its detection capabilities or by executing malware that mimics legitimate processes. The detection rule identifies suspicious file classification events, flagging potential malware activities with a high-risk score, thus enabling swift investigation and response.

### Possible investigation steps

- Review the alert details in the Elastic Endgame console by clicking the Elastic Endgame icon in the event.module column or the link in the rule.reference column to gather more context about the detected malware.
- Examine the specific file classification event by checking the event.action or endgame.event_subtype_full fields to understand the nature of the suspicious file activity.
- Analyze the endpoint's recent activity logs to identify any unusual behavior or patterns that coincide with the time of the alert.
- Investigate the source and destination of the file involved in the alert to determine if it is part of a known legitimate process or if it has been flagged in previous incidents.
- Check for any additional alerts or related events from the same endpoint or user to assess if this is part of a broader attack or isolated incident.
- Consult threat intelligence sources to see if the file or behavior matches known malware signatures or tactics, techniques, and procedures (TTPs).


### False positive analysis

- Legitimate software updates or installations may trigger file classification events. Users can create exceptions for known update processes to prevent these from being flagged as malware.
- System maintenance tasks, such as disk cleanup or defragmentation, might mimic suspicious file activities. Exclude these routine tasks by identifying their specific processes and adding them to the exception list.
- Security tools or antivirus software performing scans can generate alerts. Identify these tools and configure the rule to ignore their activities to reduce false positives.
- Custom scripts or automation tools used within the organization may be misclassified. Review these scripts and whitelist them if they are verified as safe and necessary for business operations.
- Frequent alerts from specific directories known to store temporary or cache files can be excluded by specifying these directories in the rule settings.


### Response and remediation

- Isolate the affected endpoint immediately to prevent further spread of the detected malware across the network.
- Terminate any suspicious processes identified by Elastic Endgame that are associated with the file classification event.
- Quarantine the suspicious files flagged by the detection rule to prevent execution and further analysis.
- Conduct a thorough scan of the isolated endpoint using updated antivirus and anti-malware tools to identify and remove any additional threats.
- Restore the affected system from a known good backup if malware removal is not feasible or if system integrity is compromised.
- Review and update endpoint protection policies to ensure they are configured to detect similar threats in the future.
- Escalate the incident to the security operations center (SOC) or incident response team for further investigation and to determine if additional systems are affected.


## Rule Query

```kuery
event.kind:alert and event.module:endgame and endgame.metadata.type:detection and (event.action:file_classification_event or endgame.event_subtype_full:file_classification_event)
```