﻿---
title: Adversary Behavior - Detected - Elastic Endgame
description: Elastic Endgame detected an Adversary Behavior. Click the Elastic Endgame icon in the event.module column or the link in the rule.reference column for...
url: https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/promotions/endgame_adversary_behavior_detected
products:
  - Elastic Security
---

# Adversary Behavior - Detected - Elastic Endgame
Elastic Endgame detected an Adversary Behavior. Click the Elastic Endgame icon in the event.module column or the link in
the rule.reference column for additional information.
**Rule type**: query
**Rule indices**:
- endgame-*

**Rule Severity**: medium
**Risk Score**: 47
**Runs every**: 1m
**Searches indices from**: `now-2m`
**Maximum alerts per execution**: 1000
**References**:
**Tags**:
- Data Source: Elastic Endgame
- Resources: Investigation Guide

**Version**: 106
**Rule authors**:
- Elastic

**Rule license**: Elastic License v2

## Setup


### Additional notes

For information on troubleshooting the maximum alerts warning please refer to this [guide](https://www.elastic.co/guide/en/security/current/alerts-ui-monitor.html#troubleshoot-max-alerts).

## Investigation guide


## Triage and analysis> **Disclaimer**:
This investigation guide was created using generative AI technology and has been reviewed to improve its accuracy and relevance. While every effort has been made to ensure its quality, we recommend validating the content and adapting it to suit your specific environment and operational needs.

### Investigating Adversary Behavior - Detected - Elastic Endgame

Elastic Endgame is a security solution designed to detect and prevent adversarial actions by monitoring system behaviors. Adversaries may exploit system vulnerabilities or execute unauthorized actions to compromise environments. This detection rule identifies suspicious behavior by analyzing alerts and specific event actions, flagging potential threats for further investigation. The rule's medium severity and risk score highlight its importance in maintaining security posture.

### Possible investigation steps

- Review the alert details in the Elastic Endgame console by clicking the Elastic Endgame icon in the event.module column or the link in the rule.reference column to gather more context about the detected behavior.
- Analyze the event.action and endgame.event_subtype_full fields to understand the specific behavior protection event that triggered the alert.
- Correlate the alert with other recent alerts or logs from the same host or user to identify any patterns or additional suspicious activities.
- Investigate the affected system for any signs of compromise or unauthorized changes, focusing on the timeframe around the alert.
- Check for any known vulnerabilities or misconfigurations in the affected system that could have been exploited by the adversary.
- Consult with the IT or security team to determine if any recent changes or updates could have triggered the alert as a false positive.


### False positive analysis

- Routine software updates or installations may trigger alerts due to behavior resembling adversarial actions. Users can create exceptions for known update processes to reduce false positives.
- Legitimate administrative tasks, such as system configuration changes, might be flagged. Identifying and excluding these tasks from monitoring can help minimize unnecessary alerts.
- Security tools or scripts that perform regular scans or maintenance can mimic adversary behavior. Whitelisting these tools in the detection rule settings can prevent them from being flagged.
- Automated backup processes that access multiple files or systems simultaneously may be misinterpreted as suspicious. Users should ensure these processes are recognized and excluded from triggering alerts.
- Custom applications with unique behaviors might be incorrectly identified as threats. Users should document and exclude these behaviors if they are verified as non-threatening.


### Response and remediation

- Isolate the affected system immediately to prevent further unauthorized actions or potential lateral movement by the adversary.
- Review the specific event.action and endgame.event_subtype_full fields to understand the nature of the detected behavior and identify any compromised accounts or processes.
- Terminate any unauthorized processes or sessions identified during the investigation to halt adversary activities.
- Apply security patches or updates to address any exploited vulnerabilities that may have been used by the adversary.
- Conduct a thorough scan of the affected system and network to identify and remove any malicious artifacts or backdoors left by the adversary.
- Restore affected systems from a known good backup if necessary, ensuring that the backup is free from compromise.
- Escalate the incident to the security operations center (SOC) or incident response team for further analysis and to determine if additional systems are affected.


## Rule Query

```kuery
event.kind:alert and event.module:endgame and (event.action:behavior_protection_event or endgame.event_subtype_full:behavior_protection_event)
```