﻿---
title: CrowdStrike External Alerts
description: Generates a detection alert for each CrowdStrike alert written to the configured indices. Enabling this rule allows you to immediately begin investigating...
url: https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/promotions/crowdstrike_external_alerts
products:
  - Elastic Security
---

# CrowdStrike External Alerts
Generates a detection alert for each CrowdStrike alert written to the configured indices. Enabling this rule allows you
to immediately begin investigating CrowdStrike alerts in the app.
**Rule type**: query
**Rule indices**:
- logs-crowdstrike.alert-*

**Rule Severity**: medium
**Risk Score**: 47
**Runs every**: 1m
**Searches indices from**: `now-2m`
**Maximum alerts per execution**: 1000
**References**:
- [[https://docs.elastic.co/en/integrations/crowdstrike](https://docs.elastic.co/en/integrations/crowdstrike)](https://docs.elastic.co/en/integrations/crowdstrike)

**Tags**:
- Data Source: Crowdstrike
- Use Case: Threat Detection
- Resources: Investigation Guide
- Promotion: External Alerts

**Version**: 2
**Rule authors**:
- Elastic

**Rule license**: Elastic License v2

## Setup


### CrowdStrike Alert Integration

This rule is designed to capture alert events generated by the CrowdStrike integration and promote them as Elastic detection alerts.
To capture CrowdStrike alerts, install and configure the CrowdStrike integration to ingest alert events into the `logs-crowdstrike.alert-*` index pattern.
If this rule is enabled alongside the External Alerts promotion rule (UUID: eb079c62-4481-4d6e-9643-3ca499df7aaa), you may receive duplicate alerts for the same CrowdStrike events. Consider adding a rule exception for the External Alert rule to exclude data_stream.dataset:crowdstrike.alert to avoid receiving duplicate alerts.

### Additional notes

For information on troubleshooting the maximum alerts warning please refer to this [guide](https://www.elastic.co/guide/en/security/current/alerts-ui-monitor.html#troubleshoot-max-alerts).

## Investigation guide


## Triage and analysis


### Investigating CrowdStrike External Alerts

CrowdStrike Falcon is a cloud-native endpoint protection platform that delivers real-time threat detection and response capabilities. The rule captures security alerts generated by Falcon and enables analysts to investigate threats rapidly based on behavioral indicators and threat intelligence.

### Possible investigation steps

- Review the associated process, file path, and command line to determine whether the activity is legitimate or suspicious.
- Investigate the user account and host involved in the alert to validate whether the activity was authorized.
- Cross-reference the alert with CrowdStrike Falcon console for additional context, including process tree, behavioral tags, and threat intelligence matches.
- Check for any related alerts from the same host, user, or file hash to identify whether this is part of a larger attack chain.
- Consult the Crowdstrike investigation guide and resources tagged in the alert for specific guidance on handling similar threats.


### False positive analysis

- Alerts involving known and trusted software tools (e.g., remote administration tools) may be false positives. Confirm intent before excluding.
- Security assessments or penetration testing activities might mimic real threats. Validate the activity with responsible teams.
- Scheduled jobs, IT scripts, or automation tools may trigger alerts if they behave similarly to malicious code.
- Review alerts based on detection confidence levels and behavioral scoring to filter out low-confidence or known-benign triggers.


### Response and remediation

- Isolate affected endpoints to prevent lateral movement if malicious behavior is confirmed.
- Quarantine any identified malicious files and block related hashes or domains.
- Investigate how the threat entered the environment and close any exploited vulnerabilities.
- Reset credentials for compromised user accounts or escalate to incident response.
- Review CrowdStrike Falcon policies and detections to fine-tune future alerting and response coverage.
- Document the findings and update detection logic or exceptions accordingly.


## Rule Query

```kuery
event.kind: alert and data_stream.dataset: crowdstrike.alert
```