﻿---
title: Credential Dumping - Prevented - Elastic Endgame
description: Elastic Endgame prevented Credential Dumping. Click the Elastic Endgame icon in the event.module column or the link in the rule.reference column for additional...
url: https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/promotions/credential_access_endgame_cred_dumping_prevented
products:
  - Elastic Security
---

# Credential Dumping - Prevented - Elastic Endgame
Elastic Endgame prevented Credential Dumping. Click the Elastic Endgame icon in the event.module column or the link in
the rule.reference column for additional information.
**Rule type**: query
**Rule indices**:
- endgame-*

**Rule Severity**: medium
**Risk Score**: 47
**Runs every**: 1m
**Searches indices from**: `now-2m`
**Maximum alerts per execution**: 1000
**References**:
**Tags**:
- Data Source: Elastic Endgame
- Use Case: Threat Detection
- Tactic: Credential Access
- Resources: Investigation Guide

**Version**: 105
**Rule authors**:
- Elastic

**Rule license**: Elastic License v2

## Setup


### Additional notes

For information on troubleshooting the maximum alerts warning please refer to this [guide](https://www.elastic.co/guide/en/security/current/alerts-ui-monitor.html#troubleshoot-max-alerts).

## Investigation guide


## Triage and analysis> **Disclaimer**:
This investigation guide was created using generative AI technology and has been reviewed to improve its accuracy and relevance. While every effort has been made to ensure its quality, we recommend validating the content and adapting it to suit your specific environment and operational needs.

### Investigating Credential Dumping - Prevented - Elastic Endgame

Elastic Endgame is a security solution that proactively prevents credential dumping, a technique where attackers extract sensitive authentication data from systems. Adversaries exploit this to gain unauthorized access to networks. The detection rule identifies prevention alerts by monitoring specific event actions and metadata, signaling attempts to steal credentials, thus enabling timely threat mitigation.

### Possible investigation steps

- Review the alert details to confirm the presence of event.kind:alert and event.module:endgame, ensuring the alert is related to Elastic Endgame's prevention of credential dumping.
- Examine the event.action and endgame.event_subtype_full fields for the value cred_theft_event to understand the specific credential theft attempt that was prevented.
- Investigate the source and destination systems involved in the alert to identify potential points of compromise or targeted systems.
- Check for any related alerts or events in the same timeframe that might indicate a coordinated attack or further attempts at credential access.
- Assess the user accounts involved in the alert to determine if they have been compromised or if there are any unauthorized access attempts.
- Review the risk score and severity to prioritize the investigation and response actions based on the potential impact on the organization.


### False positive analysis

- Routine administrative tools or scripts that access credential stores may trigger alerts. Review and whitelist these tools if they are verified as non-threatening.
- Security software performing legitimate credential checks can be mistaken for credential dumping. Identify and exclude these processes from alert generation.
- Automated backup systems accessing credential data for legitimate purposes might be flagged. Ensure these systems are recognized and excluded from the rule.
- Regular system maintenance activities that involve credential verification could cause false positives. Document and exclude these activities if they are part of standard operations.
- User behavior analytics might misinterpret legitimate user actions as credential theft. Implement user behavior baselines to reduce such false positives.


### Response and remediation

- Isolate the affected system immediately to prevent further unauthorized access or lateral movement within the network.
- Terminate any suspicious processes identified as part of the credential dumping attempt to halt ongoing malicious activities.
- Change all potentially compromised credentials, especially those with elevated privileges, to prevent unauthorized access using stolen credentials.
- Conduct a thorough review of access logs and event data to identify any additional systems that may have been targeted or compromised.
- Escalate the incident to the security operations center (SOC) or incident response team for further investigation and to ensure comprehensive remediation.
- Implement additional monitoring on the affected system and related network segments to detect any further suspicious activities or attempts at credential theft.
- Review and update endpoint protection configurations to ensure that similar threats are detected and prevented in the future, leveraging insights from the MITRE ATT&CK framework.


## Rule Query

```kuery
event.kind:alert and event.module:endgame and endgame.metadata.type:prevention and (event.action:cred_theft_event or endgame.event_subtype_full:cred_theft_event)
```

**Framework:** MITRE ATT&CK
- Tactic:
  - Name: Credential Access
- Id: TA0006
- Reference URL: [[https://attack.mitre.org/tactics/TA0006/](https://attack.mitre.org/tactics/TA0006/)](https://attack.mitre.org/tactics/TA0006/)
- Technique:
  - Name: OS Credential Dumping
- Id: T1003
- Reference URL: [[https://attack.mitre.org/techniques/T1003/](https://attack.mitre.org/techniques/T1003/)](https://attack.mitre.org/techniques/T1003/)
- Sub Technique:
  - Name: LSASS Memory
- Id: T1003.001
- Reference URL: [[https://attack.mitre.org/techniques/T1003/001/](https://attack.mitre.org/techniques/T1003/001/)](https://attack.mitre.org/techniques/T1003/001/)