﻿---
title: Credential Dumping - Detected - Elastic Endgame
description: Elastic Endgame detected Credential Dumping. Click the Elastic Endgame icon in the event.module column or the link in the rule.reference column for additional...
url: https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/promotions/credential_access_endgame_cred_dumping_detected
products:
  - Elastic Security
---

# Credential Dumping - Detected - Elastic Endgame
Elastic Endgame detected Credential Dumping. Click the Elastic Endgame icon in the event.module column or the link in
the rule.reference column for additional information.
**Rule type**: query
**Rule indices**:
- endgame-*

**Rule Severity**: high
**Risk Score**: 73
**Runs every**: 1m
**Searches indices from**: `now-2m`
**Maximum alerts per execution**: 1000
**References**:
**Tags**:
- Data Source: Elastic Endgame
- Use Case: Threat Detection
- Tactic: Credential Access
- Resources: Investigation Guide

**Version**: 105
**Rule authors**:
- Elastic

**Rule license**: Elastic License v2

## Setup


### Additional notes

For information on troubleshooting the maximum alerts warning please refer to this [guide](https://www.elastic.co/guide/en/security/current/alerts-ui-monitor.html#troubleshoot-max-alerts).

## Investigation guide


## Triage and analysis> **Disclaimer**:
This investigation guide was created using generative AI technology and has been reviewed to improve its accuracy and relevance. While every effort has been made to ensure its quality, we recommend validating the content and adapting it to suit your specific environment and operational needs.

### Investigating Credential Dumping - Detected - Elastic Endgame

Elastic Endgame is a security solution that monitors and detects suspicious activities, such as credential dumping, which is a technique used by adversaries to extract sensitive authentication data. Attackers exploit this to gain unauthorized access to systems. The detection rule identifies such threats by analyzing alerts and specific event actions related to credential theft, ensuring timely threat detection and response.

### Possible investigation steps

- Review the alert details to confirm the presence of event.kind:alert and event.module:endgame, ensuring the alert is related to the Elastic Endgame detection.
- Examine the event.action and endgame.event_subtype_full fields for the value cred_theft_event to understand the specific credential theft activity detected.
- Check the associated host and user information to identify the potentially compromised system and user accounts.
- Investigate the timeline of events leading up to and following the alert to identify any suspicious activities or patterns that may indicate further compromise.
- Correlate the alert with other security events or logs to determine if this is part of a larger attack or isolated incident.
- Assess the risk score and severity to prioritize the response and determine if immediate action is required to contain the threat.
- Consult the MITRE ATT&CK framework for additional context on the T1003 technique to understand potential attacker methods and improve defensive measures.


### False positive analysis

- Routine administrative tasks that involve legitimate credential access tools may trigger alerts. Users can create exceptions for known administrative accounts or tools that are frequently used in these tasks.
- Security software updates or scans that access credential stores might be flagged. Exclude these processes by identifying their specific event actions and adding them to the exception list.
- Automated scripts for system maintenance that require credential access could be misidentified. Review and whitelist these scripts by their unique identifiers or execution paths.
- Legitimate software installations that require elevated privileges may cause alerts. Monitor and exclude these installation processes by verifying their source and purpose.
- Regularly scheduled backups that access credential data might be detected. Ensure these backup processes are recognized and excluded by specifying their event actions in the rule configuration.


### Response and remediation

- Isolate the affected system immediately to prevent further unauthorized access and lateral movement within the network.
- Terminate any suspicious processes identified as part of the credential dumping activity to halt ongoing malicious actions.
- Change all potentially compromised credentials, prioritizing those with elevated privileges, to mitigate unauthorized access risks.
- Conduct a thorough review of access logs and system events to identify any additional compromised accounts or systems.
- Restore affected systems from a known good backup to ensure the integrity of the system and data.
- Implement enhanced monitoring on the affected systems and accounts to detect any signs of recurring or related malicious activity.
- Escalate the incident to the security operations center (SOC) or incident response team for further investigation and to determine if additional containment or remediation actions are necessary.


## Rule Query

```kuery
event.kind:alert and event.module:endgame and endgame.metadata.type:detection and (event.action:cred_theft_event or endgame.event_subtype_full:cred_theft_event)
```

**Framework:** MITRE ATT&CK
- Tactic:
  - Name: Credential Access
- Id: TA0006
- Reference URL: [[https://attack.mitre.org/tactics/TA0006/](https://attack.mitre.org/tactics/TA0006/)](https://attack.mitre.org/tactics/TA0006/)
- Technique:
  - Name: OS Credential Dumping
- Id: T1003
- Reference URL: [[https://attack.mitre.org/techniques/T1003/](https://attack.mitre.org/techniques/T1003/)](https://attack.mitre.org/techniques/T1003/)
- Sub Technique:
  - Name: LSASS Memory
- Id: T1003.001
- Reference URL: [[https://attack.mitre.org/techniques/T1003/001/](https://attack.mitre.org/techniques/T1003/001/)](https://attack.mitre.org/techniques/T1003/001/)